/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CrossCollectionSearch
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)CrossCollectionSearch.class.getName());
    protected static final String QUERY_PARAM = "query";
    protected static final String COLLECTION_PARAM = "collection";
    protected static final String TEXT_QUERY_SERVICE = "TextQuery";
    protected static final String ADV_QUERY_SERVICE = "AdvTextQuery";
    protected static final String DOCUMENT_METADATA_RETRIEVE_SERVICE = "DocumentMetadataRetrieve";
    protected String[] coll_ids_list = null;
    protected String[] coll_ids_list_no_all = null;
    protected String[] coll_names_list = null;

    public boolean configure(Element info, Element extra_info) {
        logger.info((Object)"Configuring CrossCollectionSearch...");
        Element ccs_service = this.doc.createElement("service");
        ccs_service.setAttribute("type", QUERY_PARAM);
        ccs_service.setAttribute("name", TEXT_QUERY_SERVICE);
        this.short_service_info.appendChild(ccs_service);
        Element dmr_service = this.doc.createElement("service");
        dmr_service.setAttribute("type", "retrieve");
        dmr_service.setAttribute("name", DOCUMENT_METADATA_RETRIEVE_SERVICE);
        this.short_service_info.appendChild(dmr_service);
        Element format_info = (Element)GSXML.getChildByTagName(info, "format");
        if (format_info != null) {
            this.format_info_map.put(TEXT_QUERY_SERVICE, this.doc.importNode(format_info, true));
        } else {
            String format_string = "<format xmlns:gsf='http://www.greenstone.org/greenstone3/schema/ConfigFormat' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><gsf:template match='documentNode'><td><a><xsl:attribute name='href'>?a=d&amp;c=<xsl:value-of select='@collection'/>&amp;d=<xsl:value-of select='@nodeID'/><xsl:if test=\"@nodeType='leaf'\">&amp;sib=1</xsl:if>&amp;dt=<xsl:value-of select='@docType'/>&amp;p.a=q&amp;p.s=TextQuery&amp;p.c=";
            if (this.cluster_name != null) {
                format_string = format_string + this.cluster_name;
            }
            format_string = format_string + "</xsl:attribute><gsf:icon/></a></td><td><gsf:metadata name='Title'/> (<xsl:value-of select='@collection'/>) </td></gsf:template></format>";
            this.format_info_map.put(TEXT_QUERY_SERVICE, this.doc.importNode(this.converter.getDOM(format_string).getDocumentElement(), true));
        }
        return true;
    }

    protected Element getServiceDescription(String service, String lang, String subset) {
        if (service.equals(TEXT_QUERY_SERVICE)) {
            Element ccs_service = this.doc.createElement("service");
            ccs_service.setAttribute("type", QUERY_PARAM);
            ccs_service.setAttribute("name", TEXT_QUERY_SERVICE);
            if (subset == null || subset.equals("displayItemList")) {
                ccs_service.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getTextString("TextQuery.name", lang)));
                ccs_service.appendChild(GSXML.createDisplayTextElement(this.doc, "submit", this.getTextString("TextQuery.submit", lang)));
                ccs_service.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getTextString("TextQuery.description", lang)));
            }
            if (subset == null || subset.equals("paramList")) {
                Element param_list = this.doc.createElement("paramList");
                if (this.coll_ids_list == null) {
                    this.initCollectionList();
                }
                Element param = GSXML.createParameterDescription(this.doc, COLLECTION_PARAM, this.getTextString("param.collection", lang), "enum_multi", "all", this.coll_ids_list, this.coll_names_list);
                param_list.appendChild(param);
                param = GSXML.createParameterDescription(this.doc, QUERY_PARAM, this.getTextString("param.query", lang), "string", null, null, null);
                param_list.appendChild(param);
                ccs_service.appendChild(param_list);
            }
            logger.debug((Object)("service description=" + XMLConverter.getPrettyString(ccs_service)));
            return ccs_service;
        }
        Element service_elem = this.doc.createElement("service");
        service_elem.setAttribute("type", "retrieve");
        service_elem.setAttribute("name", service);
        return service_elem;
    }

    protected Element processTextQuery(Element request) {
        String coll_list;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", TEXT_QUERY_SERVICE);
        result.setAttribute("type", "process");
        String lang = request.getAttribute("lang");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"TextQuery request had no paramList.");
            return result;
        }
        String[] colls_list = this.coll_ids_list_no_all;
        Element coll_param = GSXML.getNamedElement(param_list, "param", "name", COLLECTION_PARAM);
        if (coll_param != null && !(coll_list = GSXML.getValue(coll_param)).equals("all") && !coll_list.equals("")) {
            colls_list = coll_list.split(",");
        }
        Element query_message = this.doc.createElement("message");
        StringBuffer to_att = new StringBuffer();
        for (int i = 0; i < colls_list.length; ++i) {
            if (i > 0) {
                to_att.append(",");
            }
            to_att.append(GSPath.appendLink(colls_list[i], TEXT_QUERY_SERVICE));
        }
        Element query_request = GSXML.createBasicRequest(this.doc, "process", to_att.toString(), lang, "");
        query_message.appendChild(query_request);
        Element new_param_list = this.doc.createElement("paramList");
        query_request.appendChild(new_param_list);
        new_param_list.appendChild(this.doc.importNode(GSXML.getNamedElement(param_list, "param", "name", QUERY_PARAM), true));
        Element query_result = (Element)this.router.process(query_message);
        int numDocsMatched = 0;
        int numDocsReturned = 0;
        NodeList metadata = query_result.getElementsByTagName("metadata");
        for (int j = 0; j < metadata.getLength(); ++j) {
            Element meta = (Element)metadata.item(j);
            if (meta.getAttribute("name").equals("numDocsReturned")) {
                numDocsReturned += Integer.parseInt(GSXML.getValue(meta));
                continue;
            }
            if (!meta.getAttribute("name").equals("numDocsMatched")) continue;
            numDocsMatched += Integer.parseInt(GSXML.getValue(meta));
        }
        Element metadata_list = this.doc.createElement("metadataList");
        result.appendChild(metadata_list);
        GSXML.addMetadata(this.doc, metadata_list, "numDocsReturned", "" + numDocsReturned);
        Element doc_node_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_node_list);
        NodeList responses = query_result.getElementsByTagName("response");
        for (int k = 0; k < responses.getLength(); ++k) {
            String coll_name = GSPath.removeLastLink(((Element)responses.item(k)).getAttribute("from"));
            NodeList nodes = ((Element)responses.item(k)).getElementsByTagName("documentNode");
            if (nodes == null || nodes.getLength() == 0) continue;
            Element last_node = null;
            Element this_node = null;
            for (int n = 0; n < nodes.getLength(); ++n) {
                this_node = (Element)nodes.item(n);
                this_node.setAttribute(COLLECTION_PARAM, coll_name);
                if (k == 0) {
                    doc_node_list.appendChild(this.doc.importNode(this_node, true));
                    continue;
                }
                if (last_node == null) {
                    last_node = (Element)GSXML.getChildByTagName(doc_node_list, "documentNode");
                }
                last_node = GSXML.insertIntoOrderedList(doc_node_list, "documentNode", last_node, this_node, "rank", true);
            }
        }
        return result;
    }

    protected boolean initCollectionList() {
        String lang = "en";
        String uid = "";
        Element coll_list_message = this.doc.createElement("message");
        Element coll_list_request = GSXML.createBasicRequest(this.doc, "describe", "", lang, "");
        coll_list_message.appendChild(coll_list_request);
        logger.debug((Object)("coll list request = " + XMLConverter.getPrettyString(coll_list_request)));
        Element coll_list_response = (Element)this.router.process(coll_list_message);
        if (coll_list_response == null) {
            logger.error((Object)"couldn't query the message router!");
            return false;
        }
        logger.debug((Object)("coll list response = " + XMLConverter.getPrettyString(coll_list_response)));
        NodeList colls = coll_list_response.getElementsByTagName(COLLECTION_PARAM);
        Element metadata_message = this.doc.createElement("message");
        for (int i = 0; i < colls.getLength(); ++i) {
            Element c = (Element)colls.item(i);
            String name = c.getAttribute("name");
            Element metadata_request = GSXML.createBasicRequest(this.doc, "describe", name, lang, uid);
            metadata_message.appendChild(metadata_request);
        }
        logger.debug((Object)("metadata request = " + XMLConverter.getPrettyString(metadata_message)));
        Element metadata_response = (Element)this.router.process(metadata_message);
        logger.debug((Object)("metadata response = " + XMLConverter.getPrettyString(metadata_response)));
        NodeList coll_responses = metadata_response.getElementsByTagName("response");
        ArrayList<String> valid_colls = new ArrayList<String>();
        ArrayList<String> valid_coll_names = new ArrayList<String>();
        for (int i = 0; i < coll_responses.getLength(); ++i) {
            Element query_service;
            Element response = (Element)coll_responses.item(i);
            Element coll = (Element)GSXML.getChildByTagName(response, COLLECTION_PARAM);
            Element service_list = (Element)GSXML.getChildByTagName(coll, "serviceList");
            if (service_list == null || (query_service = GSXML.getNamedElement(service_list, "service", "name", TEXT_QUERY_SERVICE)) == null) continue;
            String coll_id = response.getAttribute("from");
            String coll_name = coll_id + ": " + GSXML.getDisplayText(coll, "name", "en", "en");
            valid_colls.add(coll_id);
            valid_coll_names.add(coll_name);
        }
        if (valid_colls.size() == 0) {
            return false;
        }
        this.coll_ids_list_no_all = new String[1];
        this.coll_ids_list_no_all = valid_colls.toArray(this.coll_ids_list_no_all);
        valid_colls.add(0, "all");
        valid_coll_names.add(0, this.getTextString("param.collection.all", "en"));
        this.coll_ids_list = new String[1];
        this.coll_names_list = new String[1];
        this.coll_ids_list = valid_colls.toArray(this.coll_ids_list);
        this.coll_names_list = valid_coll_names.toArray(this.coll_names_list);
        return true;
    }

    protected Element processDocumentMetadataRetrieve(Element request) {
        int i;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", DOCUMENT_METADATA_RETRIEVE_SERVICE);
        result.setAttribute("type", "process");
        String lang = request.getAttribute("lang");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"DocumentMetadataRetrieve request had no paramList.");
            return result;
        }
        NodeList query_doc_list = request.getElementsByTagName("documentNode");
        if (query_doc_list.getLength() == 0) {
            logger.error((Object)"DocumentMetadataRetrieve request had no documentNodes.");
            return result;
        }
        Element result_node_list = this.doc.createElement("documentNodeList");
        result.appendChild(result_node_list);
        Element new_param_list = this.doc.createElement("paramList");
        Element param = GSXML.createParameter(this.doc, "metadata", "Title");
        new_param_list.appendChild(param);
        HashMap<String, Node> coll_map = new HashMap<String, Node>();
        for (int i2 = 0; i2 < query_doc_list.getLength(); ++i2) {
            Element doc_node = (Element)query_doc_list.item(i2);
            String coll_name = doc_node.getAttribute(COLLECTION_PARAM);
            Element coll_items = (Element)coll_map.get(coll_name);
            if (coll_items == null) {
                coll_items = this.doc.createElement("documentNodeList");
                coll_map.put(coll_name, coll_items);
            }
            coll_items.appendChild(this.doc.importNode(doc_node, true));
        }
        Element meta_request_message = this.doc.createElement("message");
        Set mapping_set = coll_map.entrySet();
        for (Map.Entry e : mapping_set) {
            String cname = (String)e.getKey();
            Element doc_nodes = (Element)e.getValue();
            Element meta_request = GSXML.createBasicRequest(this.doc, "process", GSPath.appendLink(cname, DOCUMENT_METADATA_RETRIEVE_SERVICE), lang, "");
            meta_request.appendChild(doc_nodes);
            meta_request.appendChild(new_param_list.cloneNode(true));
            meta_request_message.appendChild(meta_request);
        }
        Node meta_result_node = this.router.process(meta_request_message);
        Element meta_result = XMLConverter.nodeToElement(meta_result_node);
        NodeList meta_responses = meta_result.getElementsByTagName("response");
        for (i = 0; i < meta_responses.getLength(); ++i) {
            String collname = GSPath.removeLastLink(((Element)meta_responses.item(i)).getAttribute("from"));
            Element first_elem = (Element)GSXML.getNodeByPath(meta_responses.item(i), "documentNodeList/documentNode");
            coll_map.put(collname, first_elem);
        }
        for (i = 0; i < query_doc_list.getLength(); ++i) {
            Element doc_node = (Element)query_doc_list.item(i);
            Element new_node = (Element)this.doc.importNode(doc_node, false);
            result_node_list.appendChild(new_node);
            String coll_name = doc_node.getAttribute(COLLECTION_PARAM);
            Element meta_elem = (Element)coll_map.get(coll_name);
            GSXML.mergeMetadataLists(new_node, meta_elem);
            coll_map.put(coll_name, meta_elem.getNextSibling());
        }
        return result;
    }
}

