/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.GSException;
import org.greenstone.gsdl3.service.AbstractGS2DocumentRetrieve;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.mg.MGRetrieveWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GS2MGRetrieve
extends AbstractGS2DocumentRetrieve {
    static Logger logger = Logger.getLogger((String)GS2MGRetrieve.class.getName());
    private static final String DEFAULT_INDEX_ELEM = "defaultIndex";
    private static final String INDEX_LIST_ELEM = "indexList";
    private static final String INDEX_ELEM = "index";
    private static final String DEFAULT_INDEX_SUBCOLLECTION_ELEM = "defaultIndexSubcollection";
    private static final String DEFAULT_INDEX_LANGUAGE_ELEM = "defaultIndexLanguage";
    private static MGRetrieveWrapper mg_src = null;
    private String mg_basedir = null;
    private String mg_textdir = null;
    private String default_index = null;
    private boolean has_default_index = false;

    public GS2MGRetrieve() {
        if (mg_src == null) {
            mg_src = new MGRetrieveWrapper();
        }
    }

    public void cleanUp() {
        super.cleanUp();
        mg_src.unloadIndexData();
    }

    public boolean configure(Element info, Element extra_info) {
        Element defLang;
        Element defSub;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring GS2MGRetrieve...");
        Element def = (Element)GSXML.getChildByTagName(info, DEFAULT_INDEX_ELEM);
        if (def != null) {
            this.default_index = def.getAttribute("shortname");
        }
        if ((defSub = (Element)GSXML.getChildByTagName(info, DEFAULT_INDEX_SUBCOLLECTION_ELEM)) != null) {
            this.default_index = this.default_index + defSub.getAttribute("shortname");
            logger.info((Object)("default indexSubcollection is " + defSub.getAttribute("shortname")));
        }
        if ((defLang = (Element)GSXML.getChildByTagName(info, DEFAULT_INDEX_LANGUAGE_ELEM)) != null) {
            this.default_index = this.default_index + defLang.getAttribute("shortname");
            logger.info((Object)("default indexLanguage is " + defLang.getAttribute("shortname")));
        }
        if (this.default_index == null || this.default_index.equals("")) {
            logger.error((Object)"default index is not specified, the content of a document will not be retrieved");
            this.has_default_index = false;
            return true;
        }
        logger.debug((Object)("Default index: " + this.default_index));
        this.mg_basedir = GSFile.collectionBaseDir(this.site_home, this.cluster_name) + File.separatorChar;
        this.mg_textdir = GSFile.collectionTextPath(this.index_stem);
        String indexpath = GSFile.collectionIndexPath(this.index_stem, this.default_index);
        mg_src.setIndex(indexpath);
        this.has_default_index = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element getNodeContent(String doc_id, String lang) throws GSException {
        long doc_num = this.coll_db.OID2DocnumLong(doc_id);
        if (doc_num == -1L) {
            logger.error((Object)("OID " + doc_id + " couldn't be converted to mg num"));
            return null;
        }
        Element content_node = this.doc.createElement("nodeContent");
        String doc_content = null;
        if (this.has_default_index) {
            MGRetrieveWrapper mGRetrieveWrapper = mg_src;
            synchronized (mGRetrieveWrapper) {
                String indexpath = GSFile.collectionIndexPath(this.index_stem, this.default_index);
                mg_src.setIndex(indexpath);
                doc_content = mg_src.getDocument(this.mg_basedir, this.mg_textdir, doc_num);
            }
        }
        if (doc_content != null) {
            doc_content = doc_content.replaceAll("\u0002|\u0003", "");
            doc_content = this.resolveTextMacros(doc_content, doc_id, lang);
        } else {
            logger.error((Object)"the doc content was null, not getting that section\n");
            doc_content = "couldn't retrieve content for this section, please check the log file for more detail\n";
        }
        Text t = this.doc.createTextNode(doc_content);
        content_node.appendChild(t);
        return content_node;
    }
}

