/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.GSException;
import org.greenstone.gsdl3.service.AbstractDocumentRetrieve;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.Misc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IViaRetrieve
extends AbstractDocumentRetrieve {
    static Logger logger = Logger.getLogger((String)IViaRetrieve.class.getName());
    protected String ivia_server_url = null;

    public IViaRetrieve() {
        this.does_structure = false;
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        Element server_elem = (Element)GSXML.getChildByTagName(info, "iViaServer");
        if (server_elem == null) {
            logger.error((Object)"no iViaServer element found");
            return false;
        }
        this.ivia_server_url = server_elem.getAttribute("url");
        if (this.ivia_server_url.equals("")) {
            logger.error((Object)"no url for the iViaServer element");
            return false;
        }
        return true;
    }

    protected Element getNodeContent(String doc_id, String lang) throws GSException {
        String url_string = this.ivia_server_url + "/cgi-bin/view_record?theme=gsdl3&record_id=" + doc_id;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            BufferedReader reader = Misc.makeHttpConnection(url_string);
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (MalformedURLException e) {
            throw new GSException("Malformed URL: " + url_string, "system");
        }
        catch (IOException e) {
            throw new GSException("IOException during connection to " + url_string + ": " + e.toString(), "system");
        }
        String node_content = buffer.toString();
        String escaped_content = GSXML.xmlSafe(node_content);
        StringBuffer processed_content = new StringBuffer(escaped_content.length());
        processed_content.append("<nodeContent>");
        int pos = 0;
        int lastpos = 0;
        while ((pos = escaped_content.indexOf("&lt;a ", lastpos)) != -1) {
            processed_content.append(escaped_content.substring(lastpos, pos));
            int endpos = escaped_content.indexOf("&lt;/a&gt;", pos);
            if (endpos == -1) break;
            String link = escaped_content.substring(pos, endpos + 10);
            link = this.convertLink(link);
            processed_content.append(link);
            lastpos = endpos + 10;
        }
        processed_content.append(escaped_content.substring(lastpos));
        processed_content.append("</nodeContent>");
        Document content_doc = this.converter.getDOM(processed_content.toString());
        if (content_doc == null) {
            logger.error((Object)"Couldn't parse node content");
            logger.error((Object)processed_content.toString());
            return null;
        }
        Element content_element = content_doc.getDocumentElement();
        return (Element)this.doc.importNode(content_element, true);
    }

    protected String convertLink(String aref) {
        if (aref.indexOf("href=&quot;http") != -1) {
            return aref;
        }
        String type = "other";
        if (aref.indexOf("/cgi-bin/canned_search") != -1) {
            type = "query";
        } else if (aref.indexOf("/cgi-bin/click_through") != -1) {
            type = "external";
        } else if (aref.indexOf("/cgi-bin/view_record") != -1) {
            type = "document";
        }
        int href_start = aref.indexOf("href=&quot;") + 11;
        int href_end = aref.indexOf("&gt;", href_start);
        String href = aref.substring(href_start, href_end);
        String link_content = aref.substring(href_end + 4, aref.length() - 10);
        if (type.equals("external")) {
            String address = href.substring(href.lastIndexOf("http"));
            address = address.replaceAll("%3[aA]", ":");
            address = address.replaceAll("%2[fF]", "/");
            return "&lt;a href=\"" + address + "\"&gt;" + link_content + "&lt;/a&gt;";
        }
        if (type.equals("other")) {
            return "other type of link (" + link_content + ")";
        }
        StringBuffer result = new StringBuffer();
        result.append("<link type='");
        result.append(type);
        result.append("'");
        if (type.equals("query")) {
            result.append(" service='TextQuery'");
        }
        result.append(">");
        href = href.substring(href.indexOf("?") + 1);
        String[] params = href.split("&amp;");
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            int eq_pos = param.indexOf("=");
            if (eq_pos == -1) continue;
            result.append("<param name='" + param.substring(0, eq_pos) + "' value='" + param.substring(eq_pos + 1) + "'/>");
        }
        result.append(link_content);
        result.append("</link>");
        return result.toString();
    }

    protected boolean isAcceptableMetadata(String meta) {
        String valid_metadata = ",title,url,ivia_description,keywords,subjects,";
        return valid_metadata.indexOf("," + meta + ",") != -1;
    }

    protected String translateId(String oid) {
        int p = oid.lastIndexOf(46);
        if (p != oid.length() - 3) {
            logger.info((Object)"translateoid error: '.' is not the third to last char!!");
            return oid;
        }
        String top = oid.substring(0, p);
        return top;
    }

    protected String translateExternalId(String id) {
        return id;
    }

    protected String getDocType(String node_id) {
        return "simple";
    }

    protected String getRootId(String node_id) {
        return node_id;
    }

    protected ArrayList getChildrenIds(String node_id) {
        return null;
    }

    protected String getParentId(String node_id) {
        return null;
    }

    protected Element getMetadataList(String doc_id, boolean all_metadata, ArrayList metadata_names) throws GSException {
        Element meta_list = this.doc.createElement("metadataList");
        StringBuffer field_list = new StringBuffer();
        boolean metadata_found = false;
        for (int i = 0; i < metadata_names.size(); ++i) {
            if (!this.isAcceptableMetadata((String)metadata_names.get(i))) continue;
            metadata_found = true;
            field_list.append((String)metadata_names.get(i));
            field_list.append(",");
        }
        if (!metadata_found) {
            return meta_list;
        }
        String url_string = this.ivia_server_url + "/cgi-bin/view_record_set?theme=gsdl3&record_id_list=" + doc_id + "&field_list=" + field_list.toString();
        try {
            int col_pos;
            String line;
            BufferedReader reader = Misc.makeHttpConnection(url_string);
            while ((line = reader.readLine()) != null && (col_pos = line.indexOf(58)) != -1) {
                String name = line.substring(0, col_pos);
                String value = line.substring(col_pos + 2);
                GSXML.addMetadata(this.doc, meta_list, name, value);
            }
        }
        catch (MalformedURLException e) {
            throw new GSException("Malformed URL: " + url_string, "system");
        }
        catch (IOException e) {
            throw new GSException("IOException: " + e.toString(), "system");
        }
        return meta_list;
    }

    protected String getStructureInfo(String doc_id, String info_type) {
        return "";
    }
}

