/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.selfContained.GeneratedDocumentStream;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTServices
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)XSLTServices.class.getName());
    private static final String XSLT_QUERY_SERVICE = "XSLTQuery";
    private static final String RESOURCE_RETRIEVE_SERVICE = "ResourceRetrieve";
    private static final String QUERY_PARAM = "query";
    private static final String ALPHABET_PARAM = "alphabet";
    private static final int RESULT_SET_SIZE = 10;
    private static final String MINIMUM_ALPHABET = "minimum";
    private static final String ASCII_ALPHABET = "ascii";
    private static final String UNICODE_ALPHABET = "unicode";
    private static final String DEFAULT_QUERY_STRING = "<xsl:stylesheet version=\"1.0\"                xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">    <xsl:template match=\"*|/\">         <xsl:apply-templates/>    </xsl:template>    <xsl:template match=\"*|/\" mode=\"m\">         <xsl:apply-templates mode=\"m\"/>    </xsl:template>    <xsl:template match=\"text()|@*\">         <xsl:value-of select=\".\"/>    </xsl:template>    <xsl:template match=\"processing-instruction()|comment()\"/></xsl:stylesheet>";
    private String alphabet = "minimum";
    private Element config_info_ = null;

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"configuring XSLTServices");
        this.config_info = info;
        try {
            logger.info((Object)"called with:");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Element doc = GSXML.getFirstElementChild(info);
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult result = new StreamResult(System.out);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }
        catch (Throwable t) {
            logger.error((Object)"Error printing XML in XSLTService::configure()");
        }
        return true;
    }

    protected Element getServiceDescription(String service, String lang, String subset) {
        return null;
    }

    protected Element processService(String service, Element request) {
        if (service.equals(XSLT_QUERY_SERVICE)) {
            return this.processXSLTQuery(request);
        }
        if (service.equals(RESOURCE_RETRIEVE_SERVICE)) {
            return this.processResourceRetrieve(request);
        }
        Element response = this.doc.createElement("response");
        String from = GSPath.appendLink(this.cluster_name, RESOURCE_RETRIEVE_SERVICE);
        response.setAttribute("from", from);
        response.setAttribute("type", "process");
        logger.error((Object)("should never get here. service type wrong:" + service));
        GSXML.addError(this.doc, response, "XSLTServices:should never get here. service type wrong:" + service);
        return response;
    }

    protected Element processResourceRetrieve(Element request) {
        Element response = this.doc.createElement("response");
        String from = GSPath.appendLink(this.cluster_name, RESOURCE_RETRIEVE_SERVICE);
        response.setAttribute("from", from);
        response.setAttribute("type", "process");
        Element param_elem = null;
        for (Node n = request.getFirstChild(); n != null; n = n.getNextSibling()) {
            String node_name = n.getNodeName();
            if (!node_name.equals("paramList")) continue;
            param_elem = (Element)n;
            break;
        }
        if (param_elem == null) {
            logger.error((Object)"bad query request");
            GSXML.addError(this.doc, response, "bad query request in XSLTServices");
            return response;
        }
        Element doc_list = (Element)GSXML.getChildByTagName(request, "documentList");
        String[] ids = GSXML.getAttributeValuesFromList(doc_list, "name");
        for (int j = 0; j < ids.length; ++j) {
            String document = null;
            try {
                document = URLDecoder.decode(ids[j], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e.toString());
            }
            Element new_doc = this.doc.createElement("document");
            new_doc.setAttribute("name", ids[j]);
            GSXML.addDocText(this.doc, new_doc, document);
            response.appendChild(new_doc);
        }
        return response;
    }

    protected Element processXSLTQuery(Element request) {
        Element response = this.doc.createElement("response");
        String from = GSPath.appendLink(this.cluster_name, XSLT_QUERY_SERVICE);
        response.setAttribute("from", from);
        response.setAttribute("type", "process");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(param_list, false);
        String query = (String)params.get(QUERY_PARAM);
        if (query == null || query.equals("")) {
            query = DEFAULT_QUERY_STRING;
        }
        GeneratedDocumentStream stream = null;
        if (this.alphabet.equals(MINIMUM_ALPHABET)) {
            stream = new GeneratedDocumentStream('a', 'c');
        } else if (this.alphabet.equals(ASCII_ALPHABET)) {
            stream = new GeneratedDocumentStream();
        } else if (this.alphabet.equals(UNICODE_ALPHABET)) {
            stream = new GeneratedDocumentStream('\u0000', '\uffff');
        } else {
            logger.error((Object)("bad alphabet name : " + this.alphabet));
            GSXML.addError(this.doc, response, "XSLTServices: bad alphabet name : " + this.alphabet);
            stream = new GeneratedDocumentStream();
        }
        Element resource_list = this.doc.createElement("resourceList");
        response.appendChild(resource_list);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        for (int d = 0; d < 10; ++d) {
            try {
                Document document = stream.nextDocument();
                Element doc = GSXML.getFirstElementChild(document);
                Transformer transformer = transformerFactory.newTransformer();
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                String id = writer.toString();
                Element e = this.doc.createElement("document");
                e.setAttribute("name", id);
                resource_list.appendChild(e);
                continue;
            }
            catch (Throwable t) {
                GSXML.addError(this.doc, response, "Error in XSLTServices finding results:" + t.toString());
            }
        }
        return response;
    }
}

