/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import java.io.*;
import java.util.*;
import org.greenstone.gatherer.greenstone.Classifiers;
import org.greenstone.gatherer.util.StaticStrings;
import org.greenstone.gatherer.util.Utility;
import org.w3c.dom.*;


/** This class is responsible for storing information from a parsed classinfo.pl call in such a way that it allows easy access to parsed details for the purposes of user design and specification of classifiers.
 * @author John Thompson, Greenstone Digital Library, University of Waikato
 * @version 2.3
 */
public class Classifier
    extends ArgumentContainer
{
    static final public String CLASSIFIER_PREFIX = "CL";

    private boolean loading_options_failed = false;


    /** Constructor used only in DOMProxyListModel initializations.
     */
    public Classifier() {
    }

    
    public Classifier(Element element, Classifier base_classifier) {
	super(element, base_classifier);
    }


    /** The assigned classifier constructor.
     * @param element the DOM Element this classifier is based upon
     */
    public DOMProxyListEntry create(Element element) {
	String classifier_name = element.getAttribute(StaticStrings.TYPE_ATTRIBUTE);
	// Determine the base classifier from the classifier name
	Classifier base_classifier = Classifiers.getClassifier(classifier_name, true);
	Classifier classifier = new Classifier(element, base_classifier);
	if (base_classifier == null) {
	    // this is kind of a place holder classifier for one which is invalid. It won't get written out to the config file when its next saved.
	    classifier.setAssigned(false);
	}
	base_classifier = null;
	classifier_name = null;
	return classifier;
    }


    public boolean didLoadingOptionsFail()
    {
	return loading_options_failed;
    }


    /** Generate the string showing this classifiers position. */
    public String getPositionString() {
	String position_string = CLASSIFIER_PREFIX;
	if(element != null) {
	    // Determine our place in the collect.cfg file
	    int position_int = CollectionDesignManager.classifier_manager.indexOf(this) + 1;
	    if(position_int != -1) {
		position_string = position_string + position_int;
	    }
	}
	return position_string;
    }


    public void setLoadingOptionsFailed()
    {
	this.loading_options_failed = true;
    }
}
