/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: Katherine Don, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */

package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.HelpFrame;
import org.greenstone.gatherer.gui.MenuBar;

/** creates a header pane containing the title of the screen, and a help button which links to the appropriate help page */
public class DesignPaneHeader
    extends JPanel
{
    protected String help_key_name;


    public DesignPaneHeader(String label_key, String help_key)
    {
        this.setComponentOrientation(Dictionary.getOrientation());
	JLabel title_label = new JLabel("<HTML><STRONG><FONT FACE={FONT} COLOR=Black SIZE=5>" + Dictionary.get(label_key) + "</FONT></STRONG></HTML>");
        title_label.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel title_pane = new JPanel();
	title_pane.setBorder(BorderFactory.createEmptyBorder(0,0,0,5));
	title_pane.setLayout(new BorderLayout());
	title_pane.add(title_label, BorderLayout.CENTER);
	title_pane.add(new JSeparator(), BorderLayout.SOUTH);
        title_pane.setComponentOrientation(Dictionary.getOrientation());
        
	GLIButton help_button = new GLIButton(Dictionary.get("CDM.HelpButton"), Dictionary.get("CDM.HelpButton_Tooltip"));
	this.help_key_name = help_key;
	help_button.setIcon(MenuBar.HELP_ICON);
	help_button.addActionListener(new ActionListener()
	    {
		public void actionPerformed(ActionEvent event) {
		    HelpFrame.setView(help_key_name);
		}
	    });

	setLayout(new BorderLayout());
	add(title_pane, BorderLayout.CENTER);
	add(help_button, BorderLayout.LINE_END);
    }
}
