/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui.metaaudit;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.util.JarTools;

/** This custom button renderer replaces the boring old column headers with clickable versions which are based on JToggleButtons.
 * @author John Thompson, Greenstone Digital Library, University of Waikato
 * @version 2.3
 */
public class HeaderRenderer 
    extends JToggleButton
    implements TableCellRenderer {

    /** The constructor sets up a margin around the button, and adds the filter icons.
     */
    public HeaderRenderer() {
	setMargin(new Insets(0,0,0,0));
	setIcon(JarTools.getImage("filter.gif"));
	setSelectedIcon(JarTools.getImage("filter-on.gif")); 
    }

    /** Called to create the component to be used as the 'rubber-stamp' for the table cell given the follwing arguments.
     * @param table The <strong>JTable</strong> that is asking the renderer to draw; can be <i>null</i>.
     * @param value The value of the cell to be rendered as an <strong>Object</strong>. It is up to the specific renderer to interpret and draw the value. For example, if value is the string "true", it could be rendered as a string or it could be rendered as a check box that is checked. null is a valid value.
     * @param isSelected <i>true</i> if the cell is to be rendered with the selection highlighted; otherwise <i>false</i>.
     * @param hasFocus If <i>true</i>, render cell appropriately. For example, put a special border on the cell, if the cell can be edited, render in the color used to indicate editing.
     * @param row The row index of the cell being drawn as an <i>int</i>. When drawing the header, the value of row is -1.
     * @param column The column index of the cell being drawn as an <i>int</i>.
     * @see org.greenstone.gatherer.gui.metaaudit.MetaAuditTable
     */
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
	setText(value.toString());
	setToolTipText(Dictionary.get("Autofilter.Table_Header_Tooltip", value.toString()));
	MetaAuditTable temp = (MetaAuditTable) table;
	if (temp != null) { // And it may if this is called during table init.
	    setSelected(temp.isFiltered(column));
	}
	return this;
    }
}
