/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: David Bainbridge, NZDL Project, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2005 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */

package org.greenstone.gatherer.remote;

import java.io.*;
import java.util.*;
import java.util.zip.*;


public class Unzip 
{

    public static final void copyInputStream(InputStream in, OutputStream out)
	throws IOException
    {
	byte[] buffer = new byte[1024];
	int len;

	while((len = in.read(buffer)) >= 0)
	    out.write(buffer, 0, len);

	in.close();
	out.close();
    }


    static public void main(String[] args) 
    {
	if (args.length != 2) {
	    System.err.println("Usage: Unzip <zip-file> <destination-directory>");
	    return;
	}

	String zip_file_path = args[0];
	// System.err.println("Zip file path: " + zip_file_path);
	String destination_directory_path = args[1];
	if (!destination_directory_path.endsWith(File.separator)) {
	    destination_directory_path += File.separator;
	}
	// System.err.println("Destination directory path: " + destination_directory_path);

	try {
	    ZipFile zipFile = new ZipFile(zip_file_path);

	    Enumeration entries = zipFile.entries();
	    while (entries.hasMoreElements()) {
		ZipEntry entry = (ZipEntry) entries.nextElement();

		if (entry.isDirectory()) {
		    // Assume directories are stored parents first then children.
		    // System.err.println("Extracting directory: " + entry.getName());
		    // This is not robust, just for demonstration purposes.
		    String dir_name = entry.getName();
		    String full_dir_name = destination_directory_path + dir_name;
		    // System.err.println("Full directory name: " + full_dir_name);
		    File dirFile = new File(full_dir_name);
		    dirFile.mkdir();
		}
		else {
		    // System.err.println("Extracting file: " + entry.getName());
		    String file_name = entry.getName();
		    String full_file_name = destination_directory_path + file_name;
		    File directory = (new File(full_file_name)).getParentFile();
		    // System.err.println("Full file name: " + full_file_name);
		    if (!directory.exists() && !directory.mkdirs()) {
			System.err.println("Error: Could not create directory " + directory + "!");
		    }

		    FileOutputStream fos = new FileOutputStream(full_file_name);
		    BufferedOutputStream bos = new BufferedOutputStream(fos);

		    copyInputStream(zipFile.getInputStream(entry),bos);
		}
	    }

	    zipFile.close();
	}
	catch (Exception exception) {
	    System.out.println("ERROR: " + exception);
	    exception.printStackTrace();
	    System.exit(1);
	}
    }
}
