/**
 *#########################################################################
 *
 * A component of the Greenstone Librarian Interface (GLI) application, 
 * part of the Greenstone digital library software suite from the New 
 * Zealand Digital Library Project at the University of Waikato, 
 * New Zealand.
 *
 * Author: John Thompson
 *         Greenstone Project, New Zealand Digital Library
 *         University of Waikato
 *         http://www.nzdl.org
 *
 * Copyright (C) 2004 New Zealand Digital Library, University of Waikato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.util;


/** Any class that wants to act as the owner of an AppendLineOnlyFileDocument has to implement this.
 * @author John Thompson, Greenstone Project, New Zealand Digital Library, University of Waikato
 * @version 2.41 final
 */
public interface AppendLineOnlyFileDocumentOwner {
    /** Remove the given document from the owner. The is called by the document itself when it no longer needs a hanging reference in the owner class.
     * @param document the AppendLineOnlyFileDocument to remove
     */
    public void remove(AppendLineOnlyFileDocument document);
}



