/**********************************************************************
 *
 * phrasesearch.h -- tools to search for a phrase in a larger text
 * Copyright (C) 1999  DigiLib Systems Limited
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef PHRASESEARCH_H
#define PHRASESEARCH_H


#include "text_t.h"
#include "unitool.h"

#ifdef ENABLE_MG
#include "mgsearch.h"
#endif

#include "dbclass.h"


// looks for the phrase in the metadata or text associated with
// a document number. This function has not been coded with all
// situations in mind and expects mgsearch and db set up ready to go
#ifdef ENABLE_MG
bool OID_phrase_search (mgsearchclass &mgsearch,
			dbclass &db,
			const text_t &index,
			const text_t &subcollection,
			const text_t &language,
			const text_t &longindex,
			const text_t &collection,
			const termfreqclassarray &phrase,
			int docnum);
#endif

#endif
