/**********************************************************************
 *
 * converter.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "converter.h"



// the converters within converterinfo become the property of this class
// after add_converter has been called. The converters remain the
// responsability of the calling code and will not be deleted by this
// class.
void convertinfoclass::add_converter (const text_t &name, inconvertclass *inconverter,
				      rzwsoutconvertclass *outconverter) {
  // can't add a null converter or an action with no name
  if (inconverter == NULL || outconverter == NULL || name.empty()) {
    return;
  }

  converterinfo info;
  info.name = name;
  info.inconverter = inconverter;
  info.outconverter = outconverter;
  converters[name] = info;
}


bool operator==(const converterinfo &x, const converterinfo &y) {
  return ((x.name == y.name) && (x.inconverter == y.inconverter) &&
	  (x.outconverter == y.outconverter));
}

bool operator<(const converterinfo &x, const converterinfo &y) {
  return ((x.name < y.name) ||
	  ((x.name == y.name) &&
	   ((x.inconverter < y.inconverter) ||
	    ((x.inconverter == y.inconverter) &&
	     ((x.outconverter < y.outconverter))))));
}


// get_inconverter will return NULL if the convert could not be found
inconvertclass *convertinfoclass::get_inconverter (const text_t &name) {
  iterator here = converters.find (name);
  if (here == converters.end()) return NULL;

  return (*here).second.inconverter;
}

// get_outconverter will return NULL if the convert could not be found
rzwsoutconvertclass *convertinfoclass::get_outconverter (const text_t &name) {
  iterator here = converters.find (name);
  if (here == converters.end()) return NULL;

  return (*here).second.outconverter;
}
