/**********************************************************************
 *
 * gtiaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef GTIACTION_H
#define GTIACTION_H


#include "action.h"
#include "receptionist.h"



struct GTI_Response
{
  text_t translation_file_key;
  text_tmap translation_files_index_to_key_mapping;
  text_tmap translation_files_key_to_num_chunks_translated_mapping;
  text_tmap translation_files_key_to_num_chunks_requiring_translation_mapping;
  text_tmap translation_files_key_to_num_chunks_requiring_updating_mapping;
  text_tmap translation_files_key_to_target_file_path_mapping;

  text_t chunk_key;
  text_tmap source_file_chunks_key_to_text_mapping;
  text_tmap source_file_chunks_key_to_date_mapping;

  // For chunks requiring updating
  text_tmap target_file_chunks_key_to_text_mapping;
  text_tmap target_file_chunks_key_to_date_mapping;

  text_t num_chunks_matching_query;

  bool is_recording_text;
  text_t recorded_text;

  text_t error_message;
};


class gtiaction : public action {

protected:
  receptionist *recpt;

  char* set_gsdlhome_cstr;
  char* set_gsdlos_cstr;

  text_t path_separator;
  text_t java; // path to java executable

public:
  gtiaction ();
  virtual ~gtiaction ();

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  text_t get_action_name () {return "gti";}

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      recptprotolistclass *protos, ostream &logout);

  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response,text_t &response_data, 
			 ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

  bool init (ostream & /*logout*/);


  // The interesting functions
  void define_gti_home_page(displayclass& disp, cgiargsclass& args, ostream& logout);

  void define_gti_lang_page(displayclass& disp, cgiargsclass& args, ostream& logout);

  void define_gti_find_page(displayclass& disp, cgiargsclass& args, ostream& logout);

  void define_gti_offline_page(displayclass& disp, cgiargsclass& args, ostream& logout);

  void define_gti_core_page(displayclass& disp, cgiargsclass& args, ostream& logout);

  text_t escape_all(text_t source_string, char character_to_escape);

  void process_gti_submissions(displayclass& disp, cgiargsclass& args, ostream& logout, bool force_submission);

  text_t do_gti_request(text_t gti_arguments, ostream& logout);

  GTI_Response parse_gti_response(text_t gti_response_xml_text, ostream& logout);

  void do_gti_submission(text_t gti_arguments, text_t gti_submission, ostream& logout);

  void define_gti_status_page(displayclass& disp, cgiargsclass& args, ostream& logout);

  bool produce_excel_spreadsheet(cgiargsclass& args, ostream& logout);

  bool produce_glihelp_zipfile(displayclass& disp, cgiargsclass& args, ostream& logout);
};


#endif
