/**********************************************************************
 *
 * hlistbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "hlistbrowserclass.h"
#include "OIDtools.h"
#include "recptprototools.h"
#include "cgiutils.h"


hlistbrowserclass::hlistbrowserclass () {
}

hlistbrowserclass::~hlistbrowserclass () {
}

// returns the name that specifies the browserclass type
text_t hlistbrowserclass::get_browser_name () {
  return "HList";
}

browserclass* hlistbrowserclass::clone()
{
  return new hlistbrowserclass();
}

void hlistbrowserclass::load_metadata_defaults (text_tset &metadata) {
  metadata.insert ("doctype");
}

text_t hlistbrowserclass::get_default_formatstring () {
  return "[link][highlight][Title][/highlight][/link]";
}

// need to change OID to it's child 
void hlistbrowserclass::processOID (cgiargsclass &args, recptproto *collectproto,
				    ostream &logout) {

  text_t OID = args["d"];
  bool is_classify = false;
  if (OID.empty()) {
    is_classify = true;
    OID = args["cl"];
  }

  FilterResponse_t response;
  text_tset metadata;
  metadata.insert ("childtype");
  text_t classifytype = "Invisible";
  text_tarray OIDs;

  while (classifytype == "Invisible" || classifytype == "HList") {
    OIDs.erase (OIDs.begin(), OIDs.end());
    
    OIDs.push_back (OID);
    OIDs.push_back (OID + ".fc");

    get_info (OIDs, args["c"], args["l"], metadata, false, collectproto, response, logout);

    // Avoid infinite loops in strange situations by checking that the OID has changed
    if (response.docInfo[1].OID == OID) {
      break;
    }
    OID = response.docInfo[1].OID;
    classifytype = response.docInfo[1].metadata["childtype"].values[0];
  }
  if (is_classify) args["cl"] = OID;
  else args["d"] = OID;
}

int hlistbrowserclass::output_section_group (ResultDocInfo_t &section, cgiargsclass &args,
					     const text_t& collection, int colnumber, 
					     format_t *formatlistptr, bool use_table, 
					     text_tset &metadata, bool &getParents, 
					     recptproto *collectproto, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream &logout)
{
  // expanded contents are going to cause some nasty recursions
  // so we'll only continue if being passed the current section
  if ((args["gc"] == 1) && (section.OID != args["d"])) return 0;

  // get all siblings
  FilterResponse_t response;
  get_children (section.OID + ".pr", args["c"], args["l"], metadata, getParents, 
		collectproto, response, logout);

  return output_section_group (response, args, collection, colnumber, formatlistptr, use_table, metadata, getParents, collectproto, disp, outconvert, textout, logout);
}

int hlistbrowserclass::output_section_group (FilterResponse_t &response, cgiargsclass &args,
					     const text_t &collection, int colnumber, 
					     format_t * formatlistptr, bool use_table, 
					     text_tset &metadata, bool &getParents,
					     recptproto * collectproto, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream &logout)
{
  /* use_table is set to true if the format string starts with <td> */
  if (use_table || colnumber > 0) {
    textout << outconvert << "<table><tr><td>";
    // get tab size
    text_t tab; int itab;
    disp.expandstring (displayclass::defaultpackage, "_tabwidth_", tab);
    itab = tab.getint();
    if (colnumber > 0) textout << outconvert << disp 
			       << "<img alt=\"\" src=\"_httpiconspace_\" width=\"" 
			       << (itab*colnumber) << "\"/>";
    textout << outconvert << "</td>\n";
  }

  if (use_table)
    textout << outconvert << "<table class=\"h_list\"><tr>\n";
  else
    textout << outconvert << "<div class=\"h_list\">\n";

  ResultDocInfo_tarray::iterator tsibling = response.docInfo.begin();
  ResultDocInfo_tarray::iterator esibling = response.docInfo.end();

  text_t icon, link;
  
  while (tsibling != esibling)
  {
    get_link_icon (*tsibling, args, link, icon);

    bool highlight = false;
    if ((*tsibling).OID == args["cl"] || is_child_of ((*tsibling).OID, args["cl"]) ||
	(*tsibling).OID == args["dcn"] || starts_with (args["dcn"], (*tsibling).OID))
    {
      link.clear();
      highlight = true;
    }

    text_tmap options;
    options["link"] = link;
    options["icon"] = icon;
    if (highlight) options["highlight"] = "1";
    else options["highlight"] = "0";
    
    text_t fmt_str=get_formatted_string (collection, collectproto,
					  *tsibling, disp, formatlistptr,
					  options, logout);

    text_t span_class = "h_item";
    if (highlight) {
      // the current option
      span_class += " h_item_current";
    }
      
    textout << outconvert << "<span class=\""<<span_class<<"\">" << disp << fmt_str << "</span>\n";
    ++tsibling;
  }

  if (use_table)
    textout << outconvert << "</tr></table>\n";
  else
    textout << outconvert << "</div>\n";

  if (use_table  || colnumber > 0) textout << outconvert << "</tr></table>\n";

  return 0;
}


void hlistbrowserclass::get_link_icon (ResultDocInfo_t &section, cgiargsclass &args, text_t &link, text_t &icon)
{
  link = "<a href=\"_httpdocument_";

  text_t &doctype = section.metadata["doctype"].values[0];
  if (doctype == "classify")
  {
    // Dynamic classifier nodes
    if (args["a"] == "dc")
    {
      // The node label is going into the URL, so make it CGI-safe
      text_t classifier_node_dcn_cgi_safe = cgi_safe_utf8(section.OID);
      link = "<a href=\"_gwcgi_?c=" + args["c"] + "&amp;a=dc&amp;dcl=" + args["dcl"] + "&amp;dcn=" + classifier_node_dcn_cgi_safe + "\">";
    }
    // Static classifier nodes
    else
    {
      link += "&amp;cl=" + section.OID + "\">";
    }
  }
  else
  {
    link += "&amp;cl=" + args["cl"] + "&amp;d=" + section.OID;

    // [modification to allow default document detach settings -- kjdon]
    if (args["xx"] == "1")
    {
      // documents should be detached
      link += "&amp;x=1\" target=\"_blank\">";
    }
    else
    {
      link += "\">";
    }
  }
}
