/**********************************************************************
 *
 * ispersistentaction.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"


#include "ispersistentaction.h"

ispersistentaction::ispersistentaction (isPersistentEnum isPersistentVal) {
  // this action uses cgi variable "a"
  cgiarginfo arg_ainfo;
  arg_ainfo.shortname = "a";
  arg_ainfo.longname = "action";
  arg_ainfo.multiplechar = true;
  arg_ainfo.multiplevalue = false;
  arg_ainfo.defaultstatus = cgiarginfo::weak;
  arg_ainfo.argdefault = "is-persistent";
  arg_ainfo.savedarginfo = cgiarginfo::must;

  argsinfo.addarginfo (NULL, arg_ainfo);

  isPersistentBool = (isPersistentVal==isPersistent);
   
}

void ispersistentaction::get_cgihead_info (cgiargsclass &/*args*/, recptprotolistclass * /*protos*/,
				   response_t &response, text_t &response_data, 
				   ostream &/*logout*/) {
  response = content;
  response_data = "text/html";
}


bool ispersistentaction::do_action (cgiargsclass &args, recptprotolistclass *protos, 
			    browsermapclass * /*browsers*/, displayclass &/*disp*/, 
			    outconvertclass &outconvert, ostream &textout, 
			    ostream &logout) {
				
  
 
  textout << outconvert
	  << "<html>\n"
	  << "<head>\n"
	  << "<title>Is Persistent</title>\n"
	  << "</head>\n"
	  << "<body>\n"
	  << "isPersistent: ";
	  
  if(isPersistentBool) {
	textout << outconvert << "true\n";
  } else {
	textout << outconvert << "false\n";
  }

  textout << outconvert 
	  << "</body>\n"
	  << "</html>\n";

  return true;
};

