/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class Configuration {
    private static Hashtable<String, String> hash = null;
    private static final String TOKENIZER_PATTERN1 = " ,\n\t";
    private static final String TOKENIZER_PATTERN2 = "_\n\t";
    private static final String TOKENIZER_PATTERN3 = ",\n\t";

    public Configuration() {
        hash = new Hashtable();
        hash.put("admin.log", "true");
        hash.put("admin.conf", "true");
        hash.put("admin.ext", "true");
        hash.put("admin.monitor", "true");
        hash.put("coloring.workspace_selection_foreground", "0, 0, 0");
        hash.put("coloring.workspace_selection_background", "176, 208, 176");
        hash.put("coloring.table_noneditable_background", "255, 255, 255");
        hash.put("coloring.table_editable_background", "255, 255, 255");
        hash.put("coloring.collection_tree_background", "224, 240, 224");
        hash.put("coloring.collection_tree_foreground", "0, 0, 0");
        hash.put("coloring.workspace_tree_foreground", "0, 0, 0");
        hash.put("coloring.workspace_tree_background", "218, 237, 252");
        hash.put("coloring.workspace_heading_background", "128, 180, 216");
        hash.put("coloring.workspace_heading_foreground", "0, 0, 0");
    }

    public static boolean get(String property) {
        String value = hash.get(property);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static String getString(String property) {
        return hash.get(property);
    }

    public static Locale getLocale(String property) {
        Locale result = Locale.getDefault();
        try {
            String raw = hash.get(property);
            if (raw == null) {
                return result;
            }
            StringTokenizer tokenizer = new StringTokenizer(raw, TOKENIZER_PATTERN2);
            String language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String country = tokenizer.nextToken();
                result = new Locale(language, country);
            } else {
                result = new Locale(language);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        return result;
    }

    public static Color getColor(String property) {
        Color result = Color.white;
        String raw = hash.get(property);
        if (raw == null || raw.equals("")) {
            return result;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(raw, TOKENIZER_PATTERN1);
            int red = Integer.parseInt(tokenizer.nextToken());
            int green = Integer.parseInt(tokenizer.nextToken());
            int blue = Integer.parseInt(tokenizer.nextToken());
            result = new Color(red, green, blue);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        return result;
    }
}

