/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import java.util.Properties;

public class ProtocolPortProperties {
    public static final int ALL_CORRECT = 0;
    public static final int SECONDARY_PORT_NON_NUMERIC = 1;
    public static final int INVALID_PRIMARY_PORT = 2;
    public static final int NO_PROTOCOL = 3;
    public static final int INVALID_PROTOCOL = 4;
    public static final int NO_HTTP_PORT = 5;
    public static final int NO_HTTPS_PORT = 6;
    private static final String FALLBACK_PROTOCOL = "http";
    private static final String FALLBACK_HTTP_PORT = "8383";
    private static final String FALLBACK_HTTPS_PORT = "8443";
    private String protocol;
    private String port;
    private String httpPort;
    private String httpsPort;
    private String errorMsg;
    private int errorCode;
    private boolean httpRestrictedToLocal;
    private boolean supportsHttps;
    private String defaultPortPropertyName;
    private String localHttpURL;

    public String getProtocol() {
        return this.protocol;
    }

    public String getPort() {
        return this.port;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public int getPortNum() {
        return Integer.parseInt(this.port);
    }

    public boolean supportsHttp() {
        return !this.httpRestrictedToLocal;
    }

    public boolean supportsHttps() {
        return this.supportsHttps;
    }

    public String getDefaultPortPropertyName() {
        return this.defaultPortPropertyName;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean hadError() {
        return this.errorCode != 0;
    }

    public String getLocalHttpBaseAddress() {
        return this.localHttpURL;
    }

    public ProtocolPortProperties(Properties props) throws Exception {
        this(props, false);
    }

    public ProtocolPortProperties(Properties props, boolean recover) throws Exception {
        StringBuffer msg;
        block23: {
            String supportedProtocols;
            this.errorCode = 0;
            this.httpRestrictedToLocal = true;
            this.supportsHttps = false;
            this.defaultPortPropertyName = "localhost.port.http";
            msg = new StringBuffer();
            this.httpPort = props.getProperty("localhost.port.http");
            if (this.httpPort == null || this.httpPort.equals("")) {
                this.errorCode = 5;
                msg.append("compulsory property localhost.port.http has no value (must be set to a valid port number not already in use).");
                this.httpPort = FALLBACK_HTTP_PORT;
            }
            this.localHttpURL = "http://" + props.getProperty("localhost.server.http", "127.0.0.1");
            if (!this.httpPort.equals("80")) {
                this.localHttpURL = this.localHttpURL + ":" + this.httpPort;
            }
            if ((supportedProtocols = props.getProperty("server.protocols")) == null || supportedProtocols.equals("")) {
                this.errorCode = 3;
                msg.append("server.protocols not set.");
                this.protocol = FALLBACK_PROTOCOL;
                this.port = this.httpPort;
            } else {
                if (!supportedProtocols.contains(FALLBACK_PROTOCOL)) {
                    this.errorCode = 4;
                    msg.append("server.protocols must contain http or https, or both (in order of preference) separated by commas.");
                    this.protocol = FALLBACK_PROTOCOL;
                    this.port = this.httpPort;
                }
                if (supportedProtocols.contains("https")) {
                    this.supportsHttps = true;
                    this.httpsPort = props.getProperty("tomcat.port.https");
                    if (this.httpsPort == null || this.httpsPort.equals("")) {
                        this.errorCode = 6;
                        msg.append("server.protocols includes https but property tomcat.port.https has no value (must be set to a valid port number not already in use).");
                        this.httpsPort = FALLBACK_HTTPS_PORT;
                    }
                }
                if (supportedProtocols.matches("http(,|\\s+|$)")) {
                    this.httpRestrictedToLocal = false;
                }
                if (supportedProtocols.matches("^[,\\s]*https")) {
                    this.protocol = "https";
                    this.port = this.httpsPort;
                } else {
                    this.protocol = FALLBACK_PROTOCOL;
                    this.port = this.httpPort;
                }
            }
            if (!recover && this.errorCode == 0) {
                block22: {
                    if (this.httpPort != null) {
                        try {
                            Integer.parseInt(this.httpPort);
                        }
                        catch (NumberFormatException nfe) {
                            msg.append("\nInvalid localhost.port.http specified: must be numeric.");
                            if (this.port == this.httpPort) {
                                this.errorCode = 2;
                                this.httpPort = FALLBACK_HTTP_PORT;
                                this.port = FALLBACK_HTTP_PORT;
                            }
                            this.errorCode = 1;
                            this.httpPort = null;
                            if (!recover) break block22;
                            msg.append("\nNot using this port");
                        }
                    }
                }
                if (this.httpsPort != null) {
                    try {
                        Integer.parseInt(this.httpsPort);
                    }
                    catch (NumberFormatException nfe) {
                        msg.append("\nInvalid port specified for over https (tomcat.port.https): must be numeric.");
                        if (this.port == this.httpsPort) {
                            this.errorCode = 2;
                            this.httpsPort = FALLBACK_HTTPS_PORT;
                            this.port = FALLBACK_HTTPS_PORT;
                        }
                        this.errorCode = 1;
                        this.httpsPort = null;
                        if (!recover) break block23;
                        msg.append("\nNot using this port");
                    }
                }
            }
        }
        if (this.port == this.httpsPort) {
            this.defaultPortPropertyName = "tomcat.port.https";
        }
        if (recover) {
            msg.append("\nFalling back to port ").append(this.port).append(" and protocol ").append(this.protocol).append(".");
        }
        this.errorMsg = msg.toString();
        if (!recover && this.errorCode != 0) {
            throw new Exception(this.errorMsg);
        }
    }
}

