/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Scanner;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.greenstone.util.Misc;

public class SafeProcess {
    public static int DEBUG = 0;
    public static final int STDERR = 0;
    public static final int STDOUT = 1;
    public static final int STDIN = 2;
    public static String WIN_KILL_CMD;
    public Boolean interruptible = Boolean.TRUE;
    static Logger logger;
    private String command = null;
    private String[] command_args = null;
    private String[] envp = null;
    private File dir = null;
    private String inputStr = null;
    private Process process = null;
    private boolean forciblyTerminateProcess = false;
    private Thread theProcessThread = null;
    private String outputStr = "";
    private String errorStr = "";
    private int exitValue = -1;
    private ExceptionHandler exceptionHandler = null;
    private MainProcessHandler mainHandler = null;
    private boolean splitStdOutputNewLines = false;
    private boolean splitStdErrorNewLines = false;

    public SafeProcess(String[] cmd_args) {
        this.command_args = cmd_args;
    }

    public SafeProcess(String cmdStr) {
        this.command = cmdStr;
    }

    public SafeProcess(String[] cmd_args, String[] envparams, File launchDir) {
        this.command_args = cmd_args;
        this.envp = envparams;
        this.dir = launchDir;
    }

    public String getStdOutput() {
        return this.outputStr;
    }

    public String getStdError() {
        return this.errorStr;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public void setInputString(String sendStr) {
        this.inputStr = sendStr;
    }

    public void setExceptionHandler(ExceptionHandler exception_handler) {
        this.exceptionHandler = exception_handler;
    }

    public void setMainHandler(MainProcessHandler handler) {
        this.mainHandler = handler;
    }

    public void setSplitStdOutputNewLines(boolean split) {
        this.splitStdOutputNewLines = split;
    }

    public void setSplitStdErrorNewLines(boolean split) {
        this.splitStdErrorNewLines = split;
    }

    public boolean cancelRunningProcess() {
        boolean forceWaitUntilInterruptible = true;
        return this.cancelRunningProcess(!forceWaitUntilInterruptible);
    }

    public synchronized boolean cancelRunningProcess(boolean forceWaitUntilInterruptible) {
        if (this.process == null) {
            SafeProcess.log("@@@ No Java process to interrupt.");
            return false;
        }
        boolean sentInterrupt = false;
        if (this.interruptible.booleanValue()) {
            if (this.theProcessThread != null) {
                this.theProcessThread.interrupt();
                SafeProcess.log("@@@ Successfully sent interrupt to process.");
                sentInterrupt = true;
            }
        } else {
            if (!forceWaitUntilInterruptible && SwingUtilities.isEventDispatchThread()) {
                SafeProcess.log("#### Event Dispatch thread, returning");
                return false;
            }
            while (!this.interruptible.booleanValue()) {
                SafeProcess.log("######### Waiting for process to become interruptible...");
                try {
                    this.wait();
                }
                catch (Exception e) {
                    SafeProcess.log("@@@ Interrupted exception while waiting for SafeProcess' worker threads to finish joining on cancelling process");
                }
            }
        }
        return sentInterrupt;
    }

    private Process doRuntimeExec() throws IOException {
        Process prcs = null;
        Runtime rt = Runtime.getRuntime();
        if (this.command != null) {
            SafeProcess.log("SafeProcess running: " + this.command);
            prcs = rt.exec(this.command);
        } else {
            StringBuffer cmdDisplay = new StringBuffer();
            for (int i = 0; i < this.command_args.length; ++i) {
                cmdDisplay.append(" ").append(this.command_args[i]);
            }
            SafeProcess.log("SafeProcess running: [" + cmdDisplay + "]");
            cmdDisplay = null;
            prcs = this.envp == null && this.dir == null ? rt.exec(this.command_args) : (this.dir == null ? rt.exec(this.command_args, this.envp) : rt.exec(this.command_args, this.envp, this.dir));
        }
        this.theProcessThread = Thread.currentThread();
        return prcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitForWithStreams(OutputStreamGobbler inputGobbler, InputStreamGobbler outputGobbler, InputStreamGobbler errorGobbler) throws IOException, InterruptedException {
        inputGobbler.start();
        errorGobbler.start();
        outputGobbler.start();
        try {
            this.exitValue = this.process.waitFor();
        }
        catch (InterruptedException ie) {
            SafeProcess.log("*** Process interrupted (InterruptedException). Expected to be a Cancel operation.");
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ie);
            }
            inputGobbler.interrupt();
            errorGobbler.interrupt();
            outputGobbler.interrupt();
            this.forciblyTerminateProcess = true;
        }
        finally {
            if (this.mainHandler != null) {
                this.forciblyTerminateProcess = this.mainHandler.beforeWaitingForStreamsToEnd(this.forciblyTerminateProcess);
            }
            Object object = this.interruptible;
            synchronized (object) {
                this.interruptible = Boolean.FALSE;
            }
            outputGobbler.join();
            errorGobbler.join();
            inputGobbler.join();
            object = this.interruptible;
            synchronized (object) {
                this.interruptible = Boolean.TRUE;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
            this.outputStr = outputGobbler.getOutput();
            this.errorStr = errorGobbler.getOutput();
            if (this.mainHandler != null) {
                this.forciblyTerminateProcess = this.mainHandler.afterStreamsEnded(this.forciblyTerminateProcess);
            }
        }
        return this.exitValue;
    }

    public synchronized boolean processRunning() {
        if (this.process == null) {
            return false;
        }
        return SafeProcess.processRunning(this.process);
    }

    public int runBasicProcess() {
        try {
            this.forciblyTerminateProcess = true;
            this.process = this.doRuntimeExec();
            this.exitValue = this.process.waitFor();
            this.forciblyTerminateProcess = false;
        }
        catch (IOException ioe) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ioe);
            } else {
                SafeProcess.log("IOException: " + ioe.getMessage(), ioe);
            }
        }
        catch (InterruptedException ie) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ie);
            } else {
                SafeProcess.log("Process InterruptedException: " + ie.getMessage(), ie);
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanUp("SafeProcess.runBasicProcess");
        }
        return this.exitValue;
    }

    public int runProcess() {
        return this.runProcess(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(CustomProcessHandler procInHandler, CustomProcessHandler procOutHandler, CustomProcessHandler procErrHandler) {
        OutputStreamGobbler inputGobbler = null;
        InputStreamGobbler errorGobbler = null;
        InputStreamGobbler outputGobbler = null;
        try {
            this.forciblyTerminateProcess = false;
            this.process = this.doRuntimeExec();
            inputGobbler = procInHandler == null ? new OutputStreamGobbler(this.process.getOutputStream(), this.inputStr) : new OutputStreamGobbler(this.process.getOutputStream(), procInHandler);
            errorGobbler = procErrHandler == null ? new InputStreamGobbler(this.process.getErrorStream(), this.splitStdErrorNewLines) : new InputStreamGobbler(this.process.getErrorStream(), procErrHandler);
            outputGobbler = procOutHandler == null ? new InputStreamGobbler(this.process.getInputStream(), this.splitStdOutputNewLines) : new InputStreamGobbler(this.process.getInputStream(), procOutHandler);
            this.exitValue = this.waitForWithStreams(inputGobbler, outputGobbler, errorGobbler);
        }
        catch (IOException ioe) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ioe);
            } else {
                SafeProcess.log("IOexception: " + ioe.getMessage(), ioe);
            }
        }
        catch (InterruptedException ie) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ie);
                SafeProcess.log("@@@@ Unexpected InterruptedException when waiting for process stream gobblers to die");
            } else {
                SafeProcess.log("*** Unexpected InterruptException when waiting for process stream gobblers to die: " + ie.getMessage(), ie);
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanUp("SafeProcess.runProcess(3 params)");
        }
        return this.exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(LineByLineHandler outLineByLineHandler, LineByLineHandler errLineByLineHandler) {
        OutputStreamGobbler inputGobbler = null;
        InputStreamGobbler errorGobbler = null;
        InputStreamGobbler outputGobbler = null;
        try {
            this.forciblyTerminateProcess = false;
            this.process = this.doRuntimeExec();
            inputGobbler = new OutputStreamGobbler(this.process.getOutputStream(), this.inputStr);
            errorGobbler = new InputStreamGobbler(this.process.getErrorStream(), this.splitStdErrorNewLines);
            outputGobbler = new InputStreamGobbler(this.process.getInputStream(), this.splitStdOutputNewLines);
            if (outLineByLineHandler != null) {
                outputGobbler.setLineByLineHandler(outLineByLineHandler);
            }
            if (errLineByLineHandler != null) {
                errorGobbler.setLineByLineHandler(errLineByLineHandler);
            }
            this.exitValue = this.waitForWithStreams(inputGobbler, outputGobbler, errorGobbler);
        }
        catch (IOException ioe) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ioe);
            } else {
                SafeProcess.log("IOexception: " + ioe.getMessage(), ioe);
            }
        }
        catch (InterruptedException ie) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(ie);
                SafeProcess.log("@@@@ Unexpected InterruptedException when waiting for process stream gobblers to die");
            } else {
                SafeProcess.log("*** Unexpected InterruptException when waiting for process stream gobblers to die: " + ie.getMessage(), ie);
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanUp("SafeProcess.runProcess(2 params)");
        }
        return this.exitValue;
    }

    private void cleanUp(String callingMethod) {
        if (this.forciblyTerminateProcess) {
            SafeProcess.log("*** Going to call process.destroy from " + callingMethod);
            if (this.mainHandler != null) {
                this.mainHandler.beforeProcessDestroy();
            }
            boolean noNeedToDestroyIfOnLinux = true;
            SafeProcess.destroyProcess(this.process, noNeedToDestroyIfOnLinux);
            if (this.mainHandler != null) {
                this.mainHandler.afterProcessDestroy();
            }
            SafeProcess.log("*** Have called process.destroy from " + callingMethod);
        }
        this.process = null;
        this.theProcessThread = null;
        boolean wasForciblyTerminated = this.forciblyTerminateProcess;
        this.forciblyTerminateProcess = false;
        if (this.mainHandler != null) {
            this.mainHandler.doneCleanup(wasForciblyTerminated);
        }
    }

    public static long getProcessID(Process p) {
        long pid = -1L;
        try {
            if (p.getClass().getName().equals("java.lang.Win32Process") || p.getClass().getName().equals("java.lang.ProcessImpl")) {
                Field f = p.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(p);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE hand = new WinNT.HANDLE();
                hand.setPointer(Pointer.createConstant((long)handl));
                pid = kernel.GetProcessId(hand);
                f.setAccessible(false);
            } else if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        }
        catch (Exception ex) {
            SafeProcess.log("SafeProcess.getProcessID(): Exception when attempting to get process ID for process " + ex.getMessage(), ex);
            pid = -1L;
        }
        return pid;
    }

    static void killWinProcessWithID(long processID) {
        String cmd = SafeProcess.getWinProcessKillCmd(processID);
        if (cmd == null) {
            return;
        }
        try {
            SafeProcess.log("\tAttempting to terminate Win subprocess with pid: " + processID);
            SafeProcess proc = new SafeProcess(cmd);
            int n = proc.runProcess();
        }
        catch (Exception e) {
            SafeProcess.log("@@@ Exception attempting to stop perl " + e.getMessage(), e);
        }
    }

    static boolean killUnixProcessWithID(long processID, boolean force, boolean killEntireTree) {
        String signal;
        String string = signal = force ? "KILL" : "TERM";
        String cmd = killEntireTree ? (Misc.isMac() ? "pkill -" + signal + " -P " + processID : "kill -" + signal + " -" + processID) : "kill -" + signal + " " + processID;
        SafeProcess proc = new SafeProcess(cmd);
        int exitValue = proc.runProcess();
        if (exitValue == 0) {
            if (force) {
                SafeProcess.log("@@@ Successfully sent SIGKILL to unix process tree rooted at " + processID);
            } else {
                SafeProcess.log("@@@ Successfully sent SIGTERM to unix process tree rooted at " + processID);
            }
            return true;
        }
        if (exitValue == 1 && proc.getStdOutput().trim().equals("") && proc.getStdError().trim().equals("")) {
            SafeProcess.log("@@@ Sending termination signal returned exit value 1. On unix this can happen when the process has already been terminated.");
            return true;
        }
        SafeProcess.log("@@@ Not able to successfully terminate process. Got exitvalue: " + exitValue);
        SafeProcess.log("@@@ Got output: |" + proc.getStdOutput() + "|");
        SafeProcess.log("@@@ Got err output: |" + proc.getStdError() + "|");
        return false;
    }

    public static void destroyProcess(Process p) {
        boolean canSkipExtraWorkIfLinux = true;
        SafeProcess.destroyProcess(p, !canSkipExtraWorkIfLinux);
    }

    private static void destroyProcess(Process p, boolean canSkipExtraWorkIfLinux) {
        SafeProcess.log("### in SafeProcess.destroyProcess(Process p)");
        if (Misc.isWindows()) {
            if (!SafeProcess.isAvailable("wmic")) {
                SafeProcess.log("wmic, used to kill subprocesses, is not available. Unable to terminate subprocesses...");
                SafeProcess.log("Kill them manually from the TaskManager or they will proceed to run to termination");
                p.destroy();
                return;
            }
            long processID = SafeProcess.getProcessID(p);
            if (processID == -1L) {
                p.destroy();
            } else {
                SafeProcess.log("Attempting to terminate sub processes of Windows process with pid " + processID);
                SafeProcess.terminateSubProcessesRecursively(processID, p);
            }
            return;
        }
        if (!Misc.isMac() && canSkipExtraWorkIfLinux) {
            SafeProcess.log("@@@ Linux: Cancelling a SafeProcess instance does not require any complicated system destroy operation");
            p.destroy();
            return;
        }
        long pid = SafeProcess.getProcessID(p);
        if (pid == -1L) {
            p.destroy();
        } else {
            boolean killEntireProcessTree;
            boolean forceKill = true;
            if (!SafeProcess.killUnixProcessWithID(pid, !forceKill, killEntireProcessTree = true)) {
                SafeProcess.killUnixProcessWithID(pid, forceKill, killEntireProcessTree);
            }
            p.destroy();
        }
    }

    private static void macTerminateSubProcessesRecursively(long parent_pid, Process p) {
        SafeProcess.log("@@@ Attempting to terminate mac process recursively");
        SafeProcess proc = new SafeProcess("pgrep -P " + parent_pid);
        int exitValue = proc.runProcess();
        String stdOutput = proc.getStdOutput();
        String stdErrOutput = proc.getStdError();
        if (p != null) {
            p.destroy();
        } else {
            boolean killSubprocesses;
            boolean forceKill = true;
            if (!SafeProcess.killUnixProcessWithID(parent_pid, !forceKill, !(killSubprocesses = true))) {
                SafeProcess.killUnixProcessWithID(parent_pid, forceKill, !killSubprocesses);
            }
        }
        if (stdOutput.trim().equals("") && stdErrOutput.trim().equals("") && exitValue == 1) {
            SafeProcess.log("No child processes");
            return;
        }
        SafeProcess.log("Got childpids on STDOUT: " + stdOutput);
        SafeProcess.log("Got childpids on STDERR: " + stdErrOutput);
    }

    private static void terminateSubProcessesRecursively(long parent_pid, Process p) {
        long child_pid;
        SafeProcess proc = new SafeProcess("wmic process where (parentprocessid=" + parent_pid + ") get processid");
        proc.setSplitStdOutputNewLines(true);
        int exitValue = proc.runProcess();
        String stdOutput = proc.getStdOutput();
        String stdErrOutput = proc.getStdError();
        if (p != null) {
            p.destroy();
        } else {
            SafeProcess.killWinProcessWithID(parent_pid);
        }
        if (stdErrOutput.indexOf("No Instance(s) Available.") != -1) {
            return;
        }
        Stack<Long> subprocs = new Stack<Long>();
        Scanner sc = new Scanner(stdOutput);
        while (sc.hasNext()) {
            if (!sc.hasNextLong()) {
                sc.next();
                continue;
            }
            child_pid = sc.nextLong();
            subprocs.push(child_pid);
        }
        sc.close();
        if (!subprocs.empty()) {
            child_pid = (Long)subprocs.pop();
            SafeProcess.terminateSubProcessesRecursively(child_pid, null);
        }
    }

    private static String getWinProcessKillCmd(Long processID) {
        if (WIN_KILL_CMD == null) {
            WIN_KILL_CMD = SafeProcess.isAvailable("wmic") ? "wmic process _PROCID_ delete" : (SafeProcess.isAvailable("taskkill") ? "taskkill /f /t /PID _PROCID_" : "tskill _PROCID_");
        }
        if (WIN_KILL_CMD == null) {
            return null;
        }
        return WIN_KILL_CMD.replace("_PROCID_", Long.toString(processID));
    }

    public static boolean isAvailable(String program) {
        try {
            SafeProcess prcs = new SafeProcess("which " + program);
            prcs.runProcess();
            String output = prcs.getStdOutput().trim();
            if (output.equals("")) {
                return false;
            }
            if (output.indexOf("no " + program) != -1) {
                SafeProcess.log("@@@ SafeProcess.isAvailable(): " + program + "is not available");
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static void log(String msg) {
        if (DEBUG == 0) {
            return;
        }
        logger.info((Object)msg);
    }

    public static void log(String msg, Exception e) {
        logger.error((Object)msg, (Throwable)e);
    }

    public static void log(Exception e) {
        logger.error((Object)e);
    }

    public static void log(String msg, Exception e, boolean printStackTrace) {
        if (printStackTrace) {
            SafeProcess.log(msg, e);
        } else {
            SafeProcess.log(msg);
        }
    }

    public static String streamToString(int src) {
        String stream;
        switch (src) {
            case 0: {
                stream = "stderr";
                break;
            }
            case 1: {
                stream = "stdout";
                break;
            }
            default: {
                stream = "stdin";
            }
        }
        return stream;
    }

    public static boolean closeResource(Closeable resourceHandle) {
        boolean success = false;
        try {
            if (resourceHandle != null) {
                resourceHandle.close();
                resourceHandle = null;
                success = true;
                return success;
            }
        }
        catch (Exception e) {
            SafeProcess.log("Exception closing resource: " + e.getMessage(), e);
            resourceHandle = null;
            success = false;
            return success;
        }
        finally {
            return success;
        }
    }

    public static boolean closeSocket(Socket resourceHandle) {
        boolean success = false;
        try {
            if (resourceHandle != null) {
                resourceHandle.close();
                resourceHandle = null;
                success = true;
                return success;
            }
        }
        catch (Exception e) {
            SafeProcess.log("Exception closing resource: " + e.getMessage(), e);
            resourceHandle = null;
            success = false;
            return success;
        }
        finally {
            return success;
        }
    }

    public static boolean closeProcess(Process prcs) {
        boolean success = true;
        if (prcs != null) {
            success = success && SafeProcess.closeResource(prcs.getErrorStream());
            success = success && SafeProcess.closeResource(prcs.getOutputStream());
            success = success && SafeProcess.closeResource(prcs.getInputStream());
            prcs.destroy();
        }
        return success;
    }

    public static boolean processRunning(Process process) {
        boolean process_running = false;
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            process_running = true;
        }
        catch (Exception exception) {
            SafeProcess.log(exception);
        }
        return process_running;
    }

    static {
        logger = Logger.getLogger((String)SafeProcess.class.getName());
    }

    public static class OutputStreamGobbler
    extends Thread {
        private OutputStream os = null;
        private String inputstr = "";
        private CustomProcessHandler customHandler = null;

        protected OutputStreamGobbler() {
            super("stdinOutputStreamGobbler");
        }

        public OutputStreamGobbler(OutputStream os) {
            this();
            this.os = os;
        }

        public OutputStreamGobbler(OutputStream os, String inputstr) {
            this();
            this.os = os;
            this.inputstr = inputstr;
        }

        public OutputStreamGobbler(OutputStream os, CustomProcessHandler customHandler) {
            this();
            this.os = os;
            this.customHandler = customHandler;
        }

        public void runDefault() {
            if (this.inputstr == null) {
                return;
            }
            if (this.isInterrupted()) {
                SafeProcess.log(this.getName() + " thread was interrupted.");
                return;
            }
            BufferedWriter osw = null;
            try {
                osw = new BufferedWriter(new OutputStreamWriter(this.os, "UTF-8"));
                osw.write(this.inputstr, 0, this.inputstr.length());
                osw.newLine();
                osw.flush();
                SafeProcess.closeResource(osw);
            }
            catch (IOException ioe) {
                SafeProcess.log("Exception writing to SafeProcess' inputstream: ", ioe);
            }
            finally {
                SafeProcess.closeResource(osw);
            }
        }

        public void runCustom() {
            this.customHandler.run(this.os);
        }

        @Override
        public void run() {
            if (this.customHandler == null) {
                this.runDefault();
            } else {
                this.runCustom();
            }
        }
    }

    public static class InputStreamGobbler
    extends Thread {
        private InputStream is = null;
        private StringBuffer outputstr = new StringBuffer();
        private boolean split_newlines = false;
        private CustomProcessHandler customHandler = null;
        private LineByLineHandler lineByLineHandler = null;

        protected InputStreamGobbler() {
            super("InputStreamGobbler");
        }

        public InputStreamGobbler(InputStream is) {
            this();
            this.is = is;
            this.split_newlines = false;
        }

        public InputStreamGobbler(InputStream is, boolean split_newlines) {
            this();
            this.is = is;
            this.split_newlines = split_newlines;
        }

        public InputStreamGobbler(InputStream is, CustomProcessHandler customHandler) {
            this();
            this.is = is;
            this.customHandler = customHandler;
            this.adjustThreadName(customHandler.getThreadNamePrefix());
        }

        private void adjustThreadName(String prefix) {
            this.setName(prefix + this.getName());
        }

        public void setLineByLineHandler(LineByLineHandler lblHandler) {
            this.lineByLineHandler = lblHandler;
            this.adjustThreadName(lblHandler.getThreadNamePrefix());
        }

        public void runDefault() {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
                String line = null;
                while (!this.isInterrupted() && (line = br.readLine()) != null) {
                    this.outputstr.append(line);
                    if (this.split_newlines) {
                        this.outputstr.append(Misc.NEWLINE);
                    }
                    if (this.lineByLineHandler == null) continue;
                    this.lineByLineHandler.gotLine(line);
                }
            }
            catch (IOException ioe) {
                block10: {
                    try {
                        if (this.lineByLineHandler != null) {
                            this.lineByLineHandler.gotException(ioe);
                            break block10;
                        }
                        SafeProcess.log("Exception when reading process stream with " + this.getName() + ": ", ioe);
                    }
                    catch (Throwable throwable) {
                        if (this.isInterrupted()) {
                            SafeProcess.log("@@@ Successfully interrupted " + this.getName() + ".");
                        }
                        SafeProcess.closeResource(br);
                        throw throwable;
                    }
                }
                if (this.isInterrupted()) {
                    SafeProcess.log("@@@ Successfully interrupted " + this.getName() + ".");
                }
                SafeProcess.closeResource(br);
            }
            if (this.isInterrupted()) {
                SafeProcess.log("@@@ Successfully interrupted " + this.getName() + ".");
            }
            SafeProcess.closeResource(br);
        }

        public void runCustom() {
            this.customHandler.run(this.is);
        }

        @Override
        public void run() {
            if (this.customHandler == null) {
                this.runDefault();
            } else {
                this.runCustom();
            }
        }

        public String getOutput() {
            return this.outputstr.toString();
        }
    }

    public static abstract class LineByLineHandler {
        protected final int source;

        protected LineByLineHandler(int src) {
            this.source = src;
        }

        public String getThreadNamePrefix() {
            return SafeProcess.streamToString(this.source);
        }

        public abstract void gotLine(String var1);

        public abstract void gotException(Exception var1);
    }

    public static abstract class CustomProcessHandler {
        protected final int source;

        protected CustomProcessHandler(int src) {
            this.source = src;
        }

        public String getThreadNamePrefix() {
            return SafeProcess.streamToString(this.source);
        }

        public abstract void run(Closeable var1);
    }

    public static interface MainProcessHandler {
        public boolean beforeWaitingForStreamsToEnd(boolean var1);

        public boolean afterStreamsEnded(boolean var1);

        public void beforeProcessDestroy();

        public void afterProcessDestroy();

        public void doneCleanup(boolean var1);
    }

    public static interface ExceptionHandler {
        public void gotException(Exception var1);
    }
}

