/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.CallParamRule;
import org.apache.commons.digester.FactoryCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.digester.SetPropertyRule;
import org.apache.commons.digester.SetTopRule;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Digester
extends DefaultHandler {
    protected StringBuffer bodyText = new StringBuffer();
    protected ArrayStack bodyTexts = new ArrayStack();
    protected ClassLoader classLoader = null;
    protected boolean configured = false;
    protected int debug = 0;
    protected HashMap dtds = new HashMap();
    protected ErrorHandler errorHandler = null;
    protected static SAXParserFactory factory = null;
    protected Locator locator = null;
    protected String match = "";
    protected boolean namespaceAware = false;
    protected HashMap namespaces = new HashMap();
    protected ArrayStack params = new ArrayStack();
    protected SAXParser parser = null;
    protected String publicId = null;
    protected XMLReader reader = null;
    protected Object root = null;
    protected Rules rules = null;
    protected ArrayStack stack = new ArrayStack();
    protected boolean useContextClassLoader = false;
    protected boolean validating = false;
    protected PrintWriter writer = null;

    public Digester() {
    }

    public Digester(SAXParser parser) {
        this.parser = parser;
    }

    public Digester(XMLReader reader) {
        this.reader = reader;
    }

    public String findNamespaceURI(String prefix) {
        ArrayStack stack = (ArrayStack)this.namespaces.get(prefix);
        if (stack == null) {
            return null;
        }
        try {
            return (String)stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getCount() {
        return this.stack.size();
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getRuleNamespaceURI() {
        return this.getRules().getNamespaceURI();
    }

    public void setRuleNamespaceURI(String ruleNamespaceURI) {
        this.getRules().setNamespaceURI(ruleNamespaceURI);
    }

    /*
     * WARNING - void declaration
     */
    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        Digester digester = this;
        synchronized (digester) {
            try {
                void e;
                if (factory == null) {
                    factory = SAXParserFactory.newInstance();
                }
                factory.setNamespaceAware(this.namespaceAware);
                factory.setValidating(this.validating);
                SAXParser sAXParser = this.parser = factory.newSAXParser();
                return e;
            }
            catch (Exception e) {
                this.log("Digester.getParser: ", e);
                SAXParser sAXParser = null;
                return sAXParser;
            }
        }
    }

    public synchronized XMLReader getReader() {
        if (this.reader == null) {
            try {
                this.reader = this.getParser().getXMLReader();
            }
            catch (SAXException se) {
                return null;
            }
        }
        this.reader.setContentHandler(this);
        this.reader.setDTDHandler(this);
        this.reader.setEntityResolver(this);
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new RulesBase();
            this.rules.setDigester(this);
        }
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.debug >= 3) {
            this.log("characters(" + new String(buffer, start, length) + ")");
        }
        this.bodyText.append(buffer, start, length);
    }

    public void endDocument() throws SAXException {
        if (this.debug >= 3) {
            this.log("endDocument()");
        }
        if (this.getCount() > 1) {
            this.log("endDocument():  " + this.getCount() + " elements left");
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        Iterator rules = this.getRules().rules().iterator();
        while (rules.hasNext()) {
            Rule rule = (Rule)rules.next();
            try {
                rule.finish();
            }
            catch (Exception e) {
                this.log("Finish event threw exception", e);
                throw this.createSAXException(e);
            }
            catch (Throwable t) {
                this.log("Finish event threw exception", t);
                throw this.createSAXException(t.getMessage());
            }
        }
        this.clear();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        int slash;
        Rule rule;
        List rules;
        if (this.debug >= 3) {
            this.log("endElement(" + namespaceURI + "," + localName + "," + qName + ")");
        }
        if ((rules = this.getRules().match(namespaceURI, this.match)) != null && rules.size() > 0) {
            String bodyText = this.bodyText.toString().trim();
            int i = 0;
            while (i < rules.size()) {
                try {
                    rule = (Rule)rules.get(i);
                    if (this.debug >= 4) {
                        this.log("  Fire body() for " + rule);
                    }
                    rule.body(bodyText);
                }
                catch (Exception e) {
                    this.log("Body event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Throwable t) {
                    this.log("Body event threw exception", t);
                    throw this.createSAXException(t.getMessage());
                }
                ++i;
            }
        }
        this.bodyText = (StringBuffer)this.bodyTexts.pop();
        if (rules != null) {
            int i = 0;
            while (i < rules.size()) {
                int j = rules.size() - i - 1;
                try {
                    rule = (Rule)rules.get(j);
                    if (this.debug >= 4) {
                        this.log("  Fire end() for " + rule);
                    }
                    rule.end();
                }
                catch (Exception e) {
                    this.log("End event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Throwable t) {
                    this.log("End event threw exception", t);
                    throw this.createSAXException(t.getMessage());
                }
                ++i;
            }
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        ArrayStack stack;
        if (this.debug >= 3) {
            this.log("endPrefixMapping(" + prefix + ")");
        }
        if ((stack = (ArrayStack)this.namespaces.get(prefix)) == null) {
            return;
        }
        try {
            stack.pop();
            if (stack.empty()) {
                this.namespaces.remove(prefix);
            }
        }
        catch (EmptyStackException e) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
        if (this.debug >= 3) {
            this.log("ignorableWhitespace(" + new String(buffer, start, len) + ")");
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.debug >= 3) {
            this.log("processingInstruction('" + target + "','" + data + "')");
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.debug >= 3) {
            this.log("setDocumentLocator(" + locator + ")");
        }
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.debug >= 3) {
            this.log("skippedEntity(" + name + ")");
        }
    }

    public void startDocument() throws SAXException {
        if (this.debug >= 3) {
            this.log("startDocument()");
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        List rules;
        if (this.debug >= 3) {
            this.log("startElement(" + namespaceURI + "," + localName + "," + qName + ")");
        }
        this.bodyTexts.push(this.bodyText);
        this.bodyText.setLength(0);
        StringBuffer sb = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            sb.append('/');
        }
        if (localName == null || localName.length() < 1) {
            sb.append(qName);
        } else {
            sb.append(localName);
        }
        this.match = sb.toString();
        if (this.debug >= 3) {
            this.log("  New match='" + this.match + "'");
        }
        if ((rules = this.getRules().match(namespaceURI, this.match)) != null && rules.size() > 0) {
            String bodyText = this.bodyText.toString();
            int i = 0;
            while (i < rules.size()) {
                try {
                    Rule rule = (Rule)rules.get(i);
                    if (this.debug >= 4) {
                        this.log("  Fire begin() for " + rule);
                    }
                    rule.begin(list);
                }
                catch (Exception e) {
                    this.log("Begin event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Throwable t) {
                    this.log("Begin event threw exception", t);
                    throw this.createSAXException(t.getMessage());
                }
                ++i;
            }
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        ArrayStack stack;
        if (this.debug >= 3) {
            this.log("startPrefixMapping(" + prefix + "," + namespaceURI + ")");
        }
        if ((stack = (ArrayStack)this.namespaces.get(prefix)) == null) {
            stack = new ArrayStack();
            this.namespaces.put(prefix, stack);
        }
        stack.push(namespaceURI);
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (this.debug >= 3) {
            this.log("notationDecl(" + name + "," + publicId + "," + systemId + ")");
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        if (this.debug >= 3) {
            this.log("unparsedEntityDecl(" + name + "," + publicId + "," + systemId + "," + notation + ")");
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.debug >= 1) {
            this.log("resolveEntity('" + publicId + "', '" + systemId + "')");
        }
        this.publicId = publicId;
        String dtdURL = null;
        if (publicId != null) {
            dtdURL = (String)this.dtds.get(publicId);
        }
        if (dtdURL == null) {
            if (this.debug >= 1) {
                this.log(" Not registered, use system identifier");
            }
            return null;
        }
        if (this.debug >= 1) {
            this.log(" Resolving to alternate DTD '" + dtdURL + "'");
        }
        try {
            URL url = new URL(dtdURL);
            InputStream stream = url.openStream();
            return new InputSource(stream);
        }
        catch (Exception e) {
            throw this.createSAXException(e);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        this.log("Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.log("Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.log("Parse Warning at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    public void log(String message) {
        if (this.writer == null) {
            System.out.println(message);
        } else {
            this.writer.println(message);
        }
    }

    public void log(String message, Throwable exception) {
        if (this.writer == null) {
            System.out.println(message);
            exception.printStackTrace(System.out);
        } else {
            this.writer.println(message);
            exception.printStackTrace(this.writer);
        }
    }

    public Object parse(File file) throws IOException, SAXException {
        this.configure();
        this.getReader().parse(new InputSource(new FileReader(file)));
        return this.root;
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        this.configure();
        this.getReader().parse(input);
        return this.root;
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        this.configure();
        this.getReader().parse(new InputSource(input));
        return this.root;
    }

    public Object parse(String uri) throws IOException, SAXException {
        this.configure();
        this.getReader().parse(uri);
        return this.root;
    }

    public void register(String publicId, String dtdURL) {
        if (this.debug >= 1) {
            this.log("register('" + publicId + "', '" + dtdURL + "'");
        }
        this.dtds.put(publicId, dtdURL);
    }

    public void addRule(String pattern, Rule rule) {
        this.getRules().add(pattern, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        String oldNamespaceURI = this.getRuleNamespaceURI();
        String newNamespaceURI = ruleSet.getNamespaceURI();
        if (this.debug >= 3) {
            if (newNamespaceURI == null) {
                this.log("addRuleSet() with no namespace URI");
            } else {
                this.log("addRuleSet() with namespace URI " + newNamespaceURI);
            }
        }
        this.setRuleNamespaceURI(newNamespaceURI);
        ruleSet.addRuleInstances(this);
        this.setRuleNamespaceURI(oldNamespaceURI);
    }

    public void addCallMethod(String pattern, String methodName, int paramCount) {
        this.addRule(pattern, new CallMethodRule(this, methodName, paramCount));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, String[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(this, methodName, paramCount, paramTypes));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, Class[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(this, methodName, paramCount, paramTypes));
    }

    public void addCallParam(String pattern, int paramIndex) {
        this.addRule(pattern, new CallParamRule(this, paramIndex));
    }

    public void addCallParam(String pattern, int paramIndex, String attributeName) {
        this.addRule(pattern, new CallParamRule(this, paramIndex, attributeName));
    }

    public void addFactoryCreate(String pattern, String className) {
        this.addRule(pattern, new FactoryCreateRule(this, className));
    }

    public void addFactoryCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new FactoryCreateRule(this, className, attributeName));
    }

    public void addFactoryCreate(String pattern, ObjectCreationFactory creationFactory) {
        this.addRule(pattern, new FactoryCreateRule(this, creationFactory));
    }

    public void addObjectCreate(String pattern, String className) {
        this.addRule(pattern, new ObjectCreateRule(this, className));
    }

    public void addObjectCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new ObjectCreateRule(this, className, attributeName));
    }

    public void addSetNext(String pattern, String methodName) {
        this.addRule(pattern, new SetNextRule(this, methodName));
    }

    public void addSetNext(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetNextRule(this, methodName, paramType));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new SetPropertiesRule(this));
    }

    public void addSetProperty(String pattern, String name, String value) {
        this.addRule(pattern, new SetPropertyRule(this, name, value));
    }

    public void addSetTop(String pattern, String methodName) {
        this.addRule(pattern, new SetTopRule(this, methodName));
    }

    public void addSetTop(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetTopRule(this, methodName, paramType));
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.params.clear();
        this.publicId = null;
        this.stack.clear();
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Object pop() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void push(Object object) {
        if (this.stack.size() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.configured = true;
    }

    Map getRegistrations() {
        return this.dtds;
    }

    List getRules(String match) {
        return this.getRules().match(match);
    }

    Object peekParams() {
        try {
            return this.params.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    Object peekParams(int n) {
        try {
            return this.params.peek(n);
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    Object popParams() {
        try {
            return this.params.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    void pushParams(Object object) {
        this.params.push(object);
    }

    protected SAXException createSAXException(String message, Exception e) {
        if (this.locator != null) {
            String error = "Error at (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + ": " + message;
            if (e != null) {
                return new SAXParseException(error, this.locator, e);
            }
            return new SAXParseException(error, this.locator);
        }
        System.out.println("No Locator!");
        if (e != null) {
            return new SAXException(message, e);
        }
        return new SAXException(message);
    }

    protected SAXException createSAXException(Exception e) {
        return this.createSAXException(e.getMessage(), e);
    }

    protected SAXException createSAXException(String message) {
        return this.createSAXException(message, null);
    }
}

