/*
 * Decompiled with CFR 0.152.
 */
package org.nzdl.gsdl.Phind;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.nzdl.gsdl.Phind.ResultBox;
import org.nzdl.gsdl.Phind.ResultDisplay;
import org.nzdl.gsdl.Phind.ResultItem;
import org.nzdl.gsdl.Phind.URLUTF8Encoder;

public class Phind
extends Applet {
    public String collection;
    public String classifier;
    public String library_address;
    public String phindcgi_address;
    public String initialSearch;
    public int phraseBlockSize;
    public boolean vertical;
    public int depth;
    public boolean righttoleft;
    public int fontSize;
    public String fontName;
    public Font plainFont;
    public Font boldFont;
    public boolean showImage;
    public String backdrop_address;
    public Image backgroundImage;
    public boolean showBorder;
    public Color panel_fg;
    public Color panel_bg;
    public Color column_1_fg;
    public Color column_1_bg;
    public Color column_2_fg;
    public Color column_2_bg;
    public Color highlight_fg;
    public Color highlight_bg;
    public Color thesaurus_fg;
    public Color thesaurus_bg;
    public Color thesaurus_bar_fg;
    public Color thesaurus_bar_bg;
    public Color expansion_fg;
    public Color expansion_bg;
    public Color expansion_bar_fg;
    public Color expansion_bar_bg;
    public Color document_fg;
    public Color document_bg;
    public Color document_bar_fg;
    public Color document_bar_bg;
    public Color message_fg;
    public Color message_bg;
    int column_1_width;
    int column_2_width;
    String searchWindowName;
    String documentWindowName;
    int mode;
    final int initMode = 0;
    final int idleMode = 1;
    final int searchMode = 2;
    boolean showControlPanel;
    Label titleLabel;
    TextField wordField;
    Button searchButton;
    Button prevButton;
    Button nextButton;
    Panel resultPanel;
    ResultDisplay firstDisplay;
    ResultDisplay lastDisplay;
    Date lastQueryEndTime;
    private int timeout = 60;

    public String getAppletInfo() {
        return "Phind by Gordon Paynter (paynter@cs.waikato.ac.nz). Copyright 1997-2000.";
    }

    public void init() {
        this.mode = 0;
        System.out.println("Java vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java version: " + System.getProperty("java.version"));
        this.getParameters();
        this.setBackground(this.panel_bg);
        this.lastQueryEndTime = new Date();
        this.plainFont = new Font(this.fontName, 0, this.fontSize);
        this.boldFont = new Font(this.fontName, 1, this.fontSize);
        this.setLayout(new BorderLayout());
        this.resultPanel = new Panel();
        if (this.vertical) {
            this.resultPanel.setLayout(new GridLayout(this.depth, 1, 0, 2));
        } else {
            System.out.println("horizontal");
            this.resultPanel.setLayout(new GridLayout(1, this.depth, 2, 0));
        }
        this.add("Center", this.resultPanel);
        ResultDisplay resultDisplay = null;
        this.firstDisplay = new ResultDisplay(this, null);
        this.resultPanel.add(this.firstDisplay);
        if (this.depth == 1) {
            this.lastDisplay = this.firstDisplay;
        } else {
            ResultDisplay resultDisplay2 = this.firstDisplay;
            for (int i = 2; i <= this.depth; ++i) {
                resultDisplay = new ResultDisplay(this, resultDisplay2);
                this.resultPanel.add(resultDisplay);
                resultDisplay2 = resultDisplay;
            }
            this.lastDisplay = resultDisplay;
        }
        this.initialiseControlPanel();
        this.setStatus("Welcome to Phind.");
        this.mode = 1;
        if (this.initialSearch.length() > 0) {
            this.searchForWord(this.initialSearch);
        }
    }

    void setStatus(String string) {
        this.showStatus(string);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.searchButton) {
            this.searchForWord(this.getSearchTerm());
        } else if (event.target == this.wordField) {
            this.searchForWord(this.getSearchTerm());
        } else if (event.target == this.prevButton) {
            this.shiftPrevious();
        } else if (event.target == this.nextButton) {
            this.shiftNext();
        } else {
            System.out.println("unknown action: " + event.toString() + ", object: " + object.toString());
        }
        return true;
    }

    void searchForWord(String string) {
        if (this.mode == 1) {
            this.setSearchTerm(string);
            String string2 = string;
            string = URLUTF8Encoder.encode(string);
            if (string.length() > 1) {
                this.setStatus("searching for \"" + string + "\"");
                this.firstDisplay.emptyContents();
                ResultBox resultBox = this.lookupPhraseOnServer(null, false, string, string2, 2);
                if (resultBox == null) {
                    this.setStatus("No results for \"" + string + "\"");
                    return;
                }
                resultBox.display = this.firstDisplay.display(resultBox);
                resultBox.resize(resultBox.display.size());
                resultBox.paintAll(resultBox.getGraphics());
            }
            this.enablePreviousAndNext();
        }
    }

    void searchForPhrase(ResultBox resultBox, String string, String string2, int n) {
        if (this.mode == 1) {
            if (n <= 2 && resultBox.display.next != null) {
                resultBox.display.next.emptyContents();
            }
            this.setStatus("Searching for \"" + string2 + "\"");
            ResultBox resultBox2 = this.lookupPhraseOnServer(resultBox, true, string, string2, n);
            if (resultBox2 == null) {
                this.setStatus("No result for \"" + string2 + "\"");
                return;
            }
            if (n <= 2) {
                resultBox2.display = this.lastDisplay.display(resultBox2);
                resultBox2.resize(resultBox2.display.size());
                resultBox2.paintAll(resultBox2.getGraphics());
            }
            this.enablePreviousAndNext();
        }
    }

    ResultBox lookupPhraseOnServer(ResultBox resultBox, boolean bl, String string, String string2, int n) {
        this.disableSearchButton();
        this.mode = 2;
        ResultBox resultBox2 = null;
        if (n <= 2) {
            resultBox2 = new ResultBox(this, this.collection, string, string2, resultBox);
        } else if (n == 3 || n == 4 || n == 5) {
            resultBox2 = resultBox;
        }
        try {
            this.queryServer(bl, string, n, resultBox2);
        }
        catch (Exception exception) {
            System.out.println("Phind query error: " + exception.toString());
            this.setStatus("Query error: " + exception.toString());
            this.mode = 1;
            this.enableSearchButton();
            return null;
        }
        this.setStatus(resultBox2.c.numberOfItems + " results for \"" + string2 + "\"");
        this.mode = 1;
        this.enableSearchButton();
        this.lastQueryEndTime = new Date();
        return resultBox2;
    }

    void queryServer(boolean bl, String string, int n, ResultBox resultBox) throws IOException {
        String string2 = this.phindcgi_address + "pxml=1&c=" + this.collection + "&pc=" + this.classifier;
        string2 = bl ? string2 + "&ppnum=" + string : string2 + "&pptext=" + string;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n <= 2) {
            n3 = this.phraseBlockSize;
            n5 = this.phraseBlockSize;
            n7 = this.phraseBlockSize;
        } else if (n == 3) {
            n2 = resultBox.nextPhraseBlock * this.phraseBlockSize;
            ++resultBox.nextPhraseBlock;
            n3 = resultBox.nextPhraseBlock * this.phraseBlockSize;
        } else if (n == 4) {
            n4 = resultBox.nextDocumentBlock * this.phraseBlockSize;
            ++resultBox.nextDocumentBlock;
            n5 = resultBox.nextDocumentBlock * this.phraseBlockSize;
        } else if (n == 5) {
            n6 = resultBox.nextThesaurusLinkBlock * this.phraseBlockSize;
            ++resultBox.nextThesaurusLinkBlock;
            n7 = resultBox.nextThesaurusLinkBlock * this.phraseBlockSize;
        }
        string2 = string2 + "&pfe=" + n2 + "&ple=" + n3 + "&pfd=" + n4 + "&pld=" + n5 + "&pfl=" + n6 + "&pll=" + n7;
        System.out.println("sending query: " + string2);
        boolean bl2 = false;
        try {
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            boolean bl3 = false;
            while (!resultBox.finished) {
                int n8 = 0;
                SafeReader safeReader = new SafeReader(dataInputStream);
                safeReader.start();
                while (!safeReader.isComplete()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("test.init(): Unexpected InterruptedException. Non-fatal.");
                        interruptedException.printStackTrace();
                    }
                    if (safeReader.poll() != 0L || ++n8 <= safeReader.getTimeout()) continue;
                    safeReader.interrupt();
                    throw new InterruptedIOException("No data recieved in " + safeReader.getTimeout() + " seconds. Connection timed-out.");
                }
                System.err.println("Done reading");
                resultBox.parseBytes(safeReader.getBuffer());
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error sending query to phindcgi: " + exception);
        }
        resultBox.repaint();
    }

    String tidy_URL(String string, boolean bl) {
        if (!string.startsWith("http")) {
            if (string.startsWith("/")) {
                URL uRL = this.getDocumentBase();
                String string2 = uRL.getProtocol();
                String string3 = uRL.getHost();
                String string4 = "";
                if (uRL.getPort() != -1) {
                    string4 = ":" + uRL.getPort();
                }
                string = string2 + "://" + string3 + string4 + string;
            } else {
                URL uRL = this.getDocumentBase();
                String string5 = uRL.getProtocol();
                String string6 = uRL.getHost();
                String string7 = uRL.getFile();
                int n = string7.lastIndexOf(47);
                String string8 = "";
                if (uRL.getPort() != -1) {
                    string8 = ":" + uRL.getPort();
                }
                string7 = string7.substring(0, n + 1);
                string = string5 + "://" + string6 + string8 + string7 + string;
            }
        }
        if (bl) {
            if (string.indexOf(63) == -1) {
                string = string + "?";
            } else if (!string.endsWith("?")) {
                string = string + "&";
            }
        }
        return string;
    }

    void displayWebPage(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (string2.length() > 0) {
                this.getAppletContext().showDocument(uRL, string2);
            } else {
                this.getAppletContext().showDocument(uRL);
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot open web page: " + exception.toString());
        }
    }

    void getParameters() {
        Object object;
        this.collection = this.parameterValue("collection");
        System.out.println("Phind collection: " + this.collection);
        this.classifier = this.parameterValue("classifier", "1");
        System.out.println("Phind classifier: " + this.classifier);
        this.phindcgi_address = this.parameterValue("phindcgi");
        this.phindcgi_address = this.tidy_URL(this.phindcgi_address, true);
        System.out.println("Phind phindcgi: " + this.phindcgi_address);
        this.library_address = this.parameterValue("library");
        this.library_address = this.tidy_URL(this.library_address, true);
        System.out.println("Phind library: " + this.library_address);
        this.initialSearch = this.parameterValue("initial_search", "");
        this.showControlPanel = true;
        if (this.parameterValue("control_panel", "show").toLowerCase().equals("hide")) {
            this.showControlPanel = false;
        }
        this.backdrop_address = this.parameterValue("backdrop", "");
        if (this.backdrop_address.length() > 0) {
            this.backdrop_address = this.tidy_URL(this.backdrop_address, false);
            System.out.println("Phind backdrop URL: " + this.backdrop_address);
            try {
                object = new URL(this.backdrop_address);
                this.backgroundImage = this.getImage((URL)object);
                this.showImage = true;
            }
            catch (Exception exception) {
                System.out.println("Phind could not load " + this.backdrop_address);
                this.showImage = false;
            }
        }
        this.showBorder = this.parameterValue("border", "on").equals("off");
        this.vertical = !this.parameterValue("orientation", "vertical").toLowerCase().startsWith("hori");
        this.depth = this.parameterValue("depth", 3);
        object = this.parameterValue("textorientation", "ltr");
        this.righttoleft = ((String)object).equals("rtl");
        String string = this.parameterValue("resultorder", "standard");
        if (!string.equals("standard")) {
            int n;
            ResultItem.sortMessage = n = 20;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ',') {
                    --n;
                    continue;
                }
                if (string.charAt(i) == 'L') {
                    ResultItem.sortLinkItem = n;
                    continue;
                }
                if (string.charAt(i) == 'l') {
                    ResultItem.sortMoreLinks = n;
                    continue;
                }
                if (string.charAt(i) == 'E') {
                    ResultItem.sortPhraseItem = n;
                    continue;
                }
                if (string.charAt(i) == 'e') {
                    ResultItem.sortMorePhrases = n;
                    continue;
                }
                if (string.charAt(i) == 'D') {
                    ResultItem.sortDocumentItem = n;
                    continue;
                }
                if (string.charAt(i) != 'd') continue;
                ResultItem.sortMoreDocuments = n;
            }
            System.out.println("link: " + ResultItem.sortLinkItem);
            System.out.println("exps: " + ResultItem.sortPhraseItem);
            System.out.println("docs: " + ResultItem.sortDocumentItem);
        }
        this.phraseBlockSize = this.parameterValue("blocksize", 10);
        this.fontSize = this.parameterValue("fontsize", 10);
        this.fontName = this.parameterValue("fontname", "Helvetica");
        this.column_1_width = this.parameterValue("first_column_width", 6);
        this.column_2_width = this.parameterValue("second_column_width", this.column_1_width);
        this.searchWindowName = this.parameterValue("search_window", "phindsearch");
        this.documentWindowName = this.parameterValue("document_window", "phinddoc");
        this.panel_fg = this.parameterValue("panel_fg", Color.black);
        this.panel_bg = this.parameterValue("panel_bg", Color.white);
        this.highlight_bg = this.parameterValue("highlight_bg", Color.yellow);
        this.expansion_fg = this.parameterValue("expansion_fg", Color.black);
        this.thesaurus_fg = this.parameterValue("thesaurus_fg", new Color(0, 100, 0));
        this.document_fg = this.parameterValue("document_fg", Color.blue);
        this.thesaurus_bar_fg = this.parameterValue("thesaurus_bar_fg", Color.black);
        this.expansion_bar_fg = this.parameterValue("expansion_bar_fg", Color.black);
        this.document_bar_fg = this.parameterValue("document_bar_fg", Color.black);
        this.thesaurus_bar_bg = this.parameterValue("thesaurus_bar_bg", new Color(160, 160, 190));
        this.expansion_bar_bg = this.parameterValue("expansion_bar_bg", new Color(255, 200, 200));
        this.document_bar_bg = this.parameterValue("document_bar_bg", new Color(150, 193, 156));
        this.column_1_fg = this.parameterValue("first_column_fg", Color.black);
        this.column_1_bg = this.parameterValue("first_column_bg", new Color(235, 245, 235));
        this.column_2_fg = this.parameterValue("second_column_fg", Color.black);
        this.column_2_bg = this.parameterValue("second_column_bg", new Color(200, 220, 200));
        this.message_fg = this.parameterValue("message_fg", Color.black);
        this.message_bg = this.parameterValue("message_bg", Color.white);
        this.timeout = this.parameterValue("timeout", 60);
    }

    String parameterValue(String string) {
        try {
            return this.getParameter(string);
        }
        catch (Exception exception) {
            System.err.println("Phind: you must give a parameter for \"" + string + "\".  Stopping.");
            this.stop();
            return "";
        }
    }

    String parameterValue(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        System.out.println("Phind " + string + ": " + string3);
        return string3;
    }

    int parameterValue(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(this.getParameter(string));
        }
        catch (Exception exception) {
            return n;
        }
        System.out.println("Phind " + string + ": " + n2);
        return n2;
    }

    Color parameterValue(String string, Color color) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return color;
        }
        if ((string2 = string2.toLowerCase()).startsWith("#") && string2.length() == 7) {
            string2 = string2.substring(1);
            try {
                int n = Integer.parseInt(string2.substring(0, 2), 16);
                int n2 = Integer.parseInt(string2.substring(2, 4), 16);
                int n3 = Integer.parseInt(string2.substring(4), 16);
                return new Color(n, n2, n3);
            }
            catch (Exception exception) {
                return color;
            }
        }
        if (string2.equals("black")) {
            return Color.black;
        }
        if (string2.equals("blue")) {
            return Color.blue;
        }
        if (string2.equals("cyan")) {
            return Color.cyan;
        }
        if (string2.equals("darkgray")) {
            return Color.darkGray;
        }
        if (string2.equals("gray")) {
            return Color.gray;
        }
        if (string2.equals("green")) {
            return Color.green;
        }
        if (string2.equals("lightgray")) {
            return Color.lightGray;
        }
        if (string2.equals("magenta")) {
            return Color.magenta;
        }
        if (string2.equals("orange")) {
            return Color.orange;
        }
        if (string2.equals("pink")) {
            return Color.pink;
        }
        if (string2.equals("red")) {
            return Color.red;
        }
        if (string2.equals("white")) {
            return Color.white;
        }
        if (string2.equals("yellow")) {
            return Color.yellow;
        }
        return color;
    }

    void initialiseControlPanel() {
        if (this.showControlPanel) {
            Panel panel = new Panel();
            this.add("North", panel);
            panel.setLayout(new FlowLayout(1, 0, 0));
            this.searchButton = new Button("Search");
            this.searchButton.setFont(this.boldFont);
            panel.add(this.searchButton);
            Label label = new Label("  for");
            label.setFont(this.boldFont);
            panel.add(label);
            this.wordField = new TextField(12);
            this.wordField.setFont(this.boldFont);
            panel.add(this.wordField);
            Label label2 = new Label("          ");
            panel.add(label2);
            this.prevButton = new Button("Previous");
            this.prevButton.setFont(this.boldFont);
            this.prevButton.disable();
            panel.add(this.prevButton);
            this.nextButton = new Button("  Next  ");
            this.nextButton.setFont(this.boldFont);
            this.nextButton.disable();
            panel.add(this.nextButton);
        }
    }

    void enableSearchButton() {
        if (this.showControlPanel) {
            this.searchButton.enable();
        }
    }

    void disableSearchButton() {
        if (this.showControlPanel) {
            this.searchButton.disable();
        }
    }

    String getSearchTerm() {
        if (this.showControlPanel) {
            return this.wordField.getText();
        }
        return this.initialSearch;
    }

    void setSearchTerm(String string) {
        if (this.showControlPanel) {
            this.wordField.setText(string);
        }
    }

    void enablePreviousAndNext() {
        if (this.showControlPanel) {
            Component component = this.firstDisplay.current;
            if (component.getClass().getName().endsWith("ResultBox")) {
                if (((ResultBox)component).prevBoxExists()) {
                    this.prevButton.enable();
                } else {
                    this.prevButton.disable();
                }
            }
            if ((component = this.lastDisplay.current).getClass().getName().endsWith("ResultBox")) {
                if (((ResultBox)component).nextBoxExists()) {
                    this.nextButton.enable();
                } else {
                    this.nextButton.disable();
                }
            }
        }
    }

    void shiftPrevious() {
        ResultBox resultBox;
        Component component = this.firstDisplay.current;
        if (component.getClass().getName().endsWith("ResultBox") && (resultBox = (ResultBox)component).prevBoxExists()) {
            resultBox = resultBox.prev;
            this.firstDisplay.emptyContents();
            for (int i = 1; i <= this.depth && resultBox != null; ++i) {
                this.lastDisplay.display(resultBox);
                resultBox.resize(resultBox.display.size());
                resultBox.paintAll(resultBox.getGraphics());
                resultBox = resultBox.next;
            }
        }
        this.enablePreviousAndNext();
    }

    void shiftNext() {
        ResultBox resultBox;
        Component component = this.lastDisplay.current;
        if (component.getClass().getName().endsWith("ResultBox") && (resultBox = (ResultBox)component).nextBoxExists()) {
            component = this.firstDisplay.current;
            resultBox = (ResultBox)component;
            resultBox = resultBox.next;
            this.firstDisplay.emptyContents();
            for (int i = 1; i <= this.depth && resultBox != null; ++i) {
                this.lastDisplay.display(resultBox);
                resultBox.resize(resultBox.display.size());
                resultBox.paintAll(resultBox.getGraphics());
                resultBox = resultBox.next;
            }
        }
        this.enablePreviousAndNext();
    }

    public class SafeReader
    extends Thread {
        private boolean complete = false;
        private byte[] buffer = new byte[this.buffer_max_size];
        private DataInputStream in;
        private int timeout = 60;
        private int buffer_current_size = 0;
        private int buffer_max_size = 16;
        private int bytes_read = 0;

        public SafeReader(DataInputStream dataInputStream) {
            this.in = dataInputStream;
        }

        public SafeReader(DataInputStream dataInputStream, int n) {
            this(dataInputStream);
            this.timeout = n;
        }

        public byte[] getBuffer() {
            byte[] byArray = new byte[this.buffer_current_size];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer_current_size);
            return byArray;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public synchronized boolean isComplete() {
            return this.complete;
        }

        public long poll() {
            long l = this.bytes_read;
            this.bytes_read = 0;
            return l;
        }

        public void run() {
            try {
                int n = 0;
                byte[] byArray = new byte[8];
                while ((n = this.in.read(byArray)) != -1) {
                    if (this.buffer_max_size - (this.buffer_current_size + n) <= 0) {
                        this.buffer_max_size = 2 * this.buffer_max_size;
                        byte[] byArray2 = new byte[this.buffer_max_size];
                        System.arraycopy(this.buffer, 0, byArray2, 0, this.buffer_current_size);
                        this.buffer = byArray2;
                    }
                    System.arraycopy(byArray, 0, this.buffer, this.buffer_current_size, n);
                    this.buffer_current_size += n;
                    this.bytes_read += n;
                }
                this.setComplete(true);
            }
            catch (IOException iOException) {
                System.err.println("SafeReader.run(): Unexpected IOException. Fatal.");
                iOException.printStackTrace();
            }
        }

        private synchronized void setComplete(boolean bl) {
            this.complete = bl;
        }
    }
}

