/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OID;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GS2BrowseAction
extends Action {
    public static final String CLASSIFIER_ARG = "cl";
    static Logger logger = Logger.getLogger((String)GS2BrowseAction.class.getName());

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        Element result = this.doc.createElement("message");
        Element response = this.classifierBrowse(request);
        result.appendChild(response);
        return result;
    }

    protected Element classifierBrowse(Element request) {
        NodeList doc_nodes;
        Element page_response = this.doc.createElement("response");
        Element cgi_paramList = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_paramList, false);
        String service_name = (String)params.get("s");
        String collection = (String)params.get("c");
        if (collection == null || collection.equals("")) {
            logger.error((Object)"classifierBrowse, need to specify a collection!");
            return page_response;
        }
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String to = GSPath.appendLink(collection, service_name);
        Element info_message = this.doc.createElement("message");
        Element info_request = GSXML.createBasicRequest(this.doc, "describe", to, lang, uid);
        info_message.appendChild(info_request);
        Element format_request = GSXML.createBasicRequest(this.doc, "format", to, lang, uid);
        info_message.appendChild(format_request);
        Element info_response = (Element)this.mr.process(info_message);
        NodeList responses = info_response.getElementsByTagName("response");
        Element service_response = (Element)responses.item(0);
        Element format_response = (Element)responses.item(1);
        Element service_description = (Element)GSXML.getChildByTagName(service_response, "service");
        page_response.appendChild(this.doc.importNode(service_description, true));
        String request_type = (String)params.get("rt");
        if (request_type.equals("d")) {
            return page_response;
        }
        String classifier_node = (String)params.get(CLASSIFIER_ARG);
        if (classifier_node == null || classifier_node.equals("")) {
            return page_response;
        }
        String top_id = OID.getTop(classifier_node);
        HashSet<String> doc_meta_names = new HashSet<String>();
        HashSet<String> class_meta_names = new HashSet<String>();
        doc_meta_names.add("Title");
        class_meta_names.add("Title");
        Element format_elem = (Element)GSXML.getChildByTagName(format_response, "format");
        if (format_elem != null) {
            Element this_format = GSXML.getNamedElement(format_elem, "classifier", "name", top_id);
            if (this_format == null) {
                this_format = (Element)GSXML.getChildByTagName(format_elem, "default");
            }
            if (this_format != null) {
                Element new_format = GSXML.duplicateWithNewName(this.doc, this_format, "format", false);
                this.extractMetadataNames(new_format, doc_meta_names, class_meta_names);
                new_format.setAttribute("type", "browse");
                page_response.appendChild(new_format);
            }
        }
        Element class_list = (Element)GSXML.getChildByTagName(service_description, "classifierList");
        Element this_classifier = GSXML.getNamedElement(class_list, "classifier", "name", top_id);
        boolean horizontal_at_top = false;
        if (!this_classifier.getAttribute("horizontalAtTop").equals("")) {
            horizontal_at_top = true;
        }
        if (top_id.equals(classifier_node) && horizontal_at_top) {
            classifier_node = classifier_node + ".1";
        }
        Element classify_message = this.doc.createElement("message");
        Element classify_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        classify_message.appendChild(classify_request);
        Element param_list = this.doc.createElement("paramList");
        classify_request.appendChild(param_list);
        Element param = this.doc.createElement("param");
        param_list.appendChild(param);
        param.setAttribute("name", "structure");
        param.setAttribute("value", "ancestors");
        param = this.doc.createElement("param");
        param_list.appendChild(param);
        param.setAttribute("name", "structure");
        param.setAttribute("value", "children");
        Element classifier_list = this.doc.createElement("classifierNodeList");
        Element classifier = this.doc.createElement("classifierNode");
        classifier.setAttribute("nodeID", classifier_node);
        classifier_list.appendChild(classifier);
        classify_request.appendChild(classifier_list);
        if (horizontal_at_top && !classifier_node.equals(top_id)) {
            classifier = this.doc.createElement("classifierNode");
            classifier.setAttribute("nodeID", top_id);
            classifier_list.appendChild(classifier);
        }
        Element classify_response = (Element)this.mr.process(classify_message);
        String path = GSPath.appendLink("response", "classifierNodeList");
        Element class_node_list = (Element)GSXML.getNodeByPath(classify_response, path);
        path = GSPath.appendLink("classifierNode", "nodeStructure");
        Element cl_structure = (Element)GSXML.getNodeByPath(class_node_list, path = GSPath.appendLink(path, "classifierNode"));
        if (cl_structure == null) {
            logger.error((Object)"classifier structure request returned no structure");
            return page_response;
        }
        Element page_classifier = null;
        if (horizontal_at_top && !classifier_node.equals(top_id)) {
            Element top_node = GSXML.getNamedElement(class_node_list, "classifierNode", "nodeID", top_id);
            if (top_node != null) {
                path = GSPath.appendLink("nodeStructure", "classifierNode");
                Element top_structure = (Element)GSXML.getNodeByPath(top_node, path);
                page_classifier = GSXML.duplicateWithNewName(this.doc, top_structure, "classifier", true);
                page_response.appendChild(page_classifier);
                Element new_classifier = (Element)GSXML.getChildByTagName(cl_structure, "classifierNode");
                String replace_name = new_classifier.getAttribute("nodeID");
                Element old_classifier = GSXML.getNamedElement(page_classifier, "classifierNode", "nodeID", replace_name);
                page_classifier.replaceChild(this.doc.importNode(new_classifier, true), old_classifier);
                page_classifier.setAttribute("name", top_id);
            } else {
                page_classifier = GSXML.duplicateWithNewName(this.doc, cl_structure, "classifier", true);
                page_response.appendChild(page_classifier);
                page_classifier.setAttribute("name", top_id);
            }
        } else {
            page_classifier = GSXML.duplicateWithNewName(this.doc, cl_structure, "classifier", true);
            page_response.appendChild(page_classifier);
            page_classifier.setAttribute("name", top_id);
        }
        Element metadata_message = this.doc.createElement("message");
        boolean did_classifier = false;
        boolean did_documents = false;
        NodeList cl_nodes = page_classifier.getElementsByTagName("classifierNode");
        if (cl_nodes.getLength() > 0) {
            did_classifier = true;
            Element cl_meta_request = GSXML.createBasicRequest(this.doc, "process", to + "MetadataRetrieve", lang, uid);
            metadata_message.appendChild(cl_meta_request);
            Element new_cl_nodes_list = this.doc.createElement("classifierNodeList");
            cl_meta_request.appendChild(new_cl_nodes_list);
            for (int c = 0; c < cl_nodes.getLength(); ++c) {
                Element cl = this.doc.createElement("classifierNode");
                cl.setAttribute("nodeID", ((Element)cl_nodes.item(c)).getAttribute("nodeID"));
                new_cl_nodes_list.appendChild(cl);
            }
            Element cl_param_list = this.createMetadataParamList(class_meta_names);
            cl_meta_request.appendChild(cl_param_list);
        }
        if ((doc_nodes = page_classifier.getElementsByTagName("documentNode")).getLength() > 0) {
            did_documents = true;
            Element doc_meta_request = GSXML.createBasicRequest(this.doc, "process", GSPath.appendLink(collection, "DocumentMetadataRetrieve"), lang, uid);
            metadata_message.appendChild(doc_meta_request);
            Element doc_list = this.doc.createElement("documentNodeList");
            doc_meta_request.appendChild(doc_list);
            for (int c = 0; c < doc_nodes.getLength(); ++c) {
                Element d = this.doc.createElement("documentNode");
                d.setAttribute("nodeID", ((Element)doc_nodes.item(c)).getAttribute("nodeID"));
                doc_list.appendChild(d);
            }
            Element doc_param_list = this.createMetadataParamList(doc_meta_names);
            doc_meta_request.appendChild(doc_param_list);
        }
        Element metadata_response = (Element)this.mr.process(metadata_message);
        if (did_classifier) {
            path = GSPath.appendLink("response", "classifierNodeList");
            Node pathNode = GSXML.getNodeByPath(metadata_response, path);
            if (pathNode == null) {
                return page_response;
            }
            NodeList meta_response_cls = pathNode.getChildNodes();
            for (int i = 0; i < cl_nodes.getLength(); ++i) {
                GSXML.mergeMetadataLists(cl_nodes.item(i), meta_response_cls.item(i));
            }
        }
        if (did_documents) {
            NodeList meta_response_docs = null;
            if (!did_classifier) {
                path = GSPath.appendLink("response", "documentNodeList");
                Node pathNode = GSXML.getNodeByPath(metadata_response, path);
                if (pathNode == null) {
                    return page_response;
                }
                meta_response_docs = pathNode.getChildNodes();
            } else {
                Node nodes = GSXML.getChildByTagName(metadata_response.getElementsByTagName("response").item(1), "documentNodeList");
                if (nodes == null) {
                    return page_response;
                }
                meta_response_docs = nodes.getChildNodes();
            }
            for (int i = 0; i < doc_nodes.getLength(); ++i) {
                GSXML.mergeMetadataLists(doc_nodes.item(i), meta_response_docs.item(i));
            }
        }
        logger.debug((Object)("(GS2BrowseAction) Page:\n" + XMLConverter.getPrettyString(page_response)));
        return page_response;
    }

    protected void extractMetadataNames(Element new_format, HashSet doc_meta_names, HashSet class_meta_names) {
        NodeList templates = new_format.getElementsByTagName("gsf:template");
        for (int i = 0; i < templates.getLength(); ++i) {
            Element template = (Element)templates.item(i);
            String match = template.getAttribute("match");
            if (match.equals("documentNode")) {
                this.extractMetadataNames(template, doc_meta_names);
                continue;
            }
            if (!match.equals("classifierNode")) continue;
            this.extractMetadataNames(template, class_meta_names);
        }
    }
}

