/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.build;

import java.applet.Applet;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.io.DataInputStream;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.greenstone.gsdl3.util.GSStatus;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class StatusDisplay
extends Applet
implements Runnable {
    protected TextArea display;
    protected int delay = 3000;
    protected Thread updator_thread;
    protected URL status_cgi = null;
    protected boolean completed = false;

    public void init() {
        this.display = new TextArea();
        this.display.setEditable(false);
        this.display.setBackground(Color.white);
        this.setLayout(new GridLayout(1, 0));
        this.add(this.display);
        this.validate();
        String initial_text = this.parameterValue("initial_text");
        this.addItem(initial_text);
        this.completed = GSStatus.isCompleted(Integer.parseInt(this.parameterValue("initial_code")));
        String library = this.parameterValue("library");
        library = this.tidy_URL(library);
        try {
            this.status_cgi = new URL(library);
        }
        catch (Exception e) {
            System.out.println("Error creating URL for " + library + ": " + e.getMessage());
        }
    }

    public void start() {
        if (!this.completed) {
            if (this.updator_thread == null) {
                this.updator_thread = new Thread(this);
            }
            this.updator_thread.start();
        }
    }

    public void stop() {
        this.updator_thread = null;
    }

    public void run() {
        if (this.completed) {
            return;
        }
        Thread.currentThread().setPriority(1);
        Thread current_thread = Thread.currentThread();
        while (current_thread == this.updator_thread && !this.completed) {
            this.queryServer();
            this.display.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    void addItem(String new_text) {
        String t = this.display.getText() + "\n" + new_text;
        this.display.setText(t);
        this.display.setCaretPosition(t.length());
        this.repaint();
    }

    void queryServer() {
        System.out.println("sending query: " + this.status_cgi);
        try {
            DataInputStream in = new DataInputStream(this.status_cgi.openStream());
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(in));
            Document data_doc = parser.getDocument();
            Element data_elem = data_doc.getDocumentElement();
            Element status_elem = (Element)GSXML.getChildByTagName(data_elem, "status");
            if (status_elem != null) {
                String status = status_elem.getAttribute("code");
                System.out.println("received status " + status);
                this.completed = GSStatus.isCompleted(Integer.parseInt(status));
                this.addItem(GSXML.getNodeText(status_elem));
            } else {
                System.out.println("Error - no status receieved");
                this.completed = true;
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error sending query (" + this.status_cgi + "): " + e);
        }
    }

    String parameterValue(String name) {
        try {
            return this.getParameter(name);
        }
        catch (Exception e) {
            System.err.println("StatusDisplay: you must give a parameter for \"" + name + "\".  Stopping.");
            this.stop();
            return "";
        }
    }

    String tidy_URL(String address) {
        if (!address.startsWith("http")) {
            if (address.startsWith("/")) {
                URL document = this.getDocumentBase();
                String port = "";
                if (document.getPort() != -1) {
                    port = ":" + document.getPort();
                }
                address = "http://" + document.getHost() + port + address;
            } else {
                URL document = this.getDocumentBase();
                String directory = document.getFile();
                int end = directory.lastIndexOf(47);
                String port = "";
                if (document.getPort() != -1) {
                    port = ":" + document.getPort();
                }
                directory = directory.substring(0, end + 1);
                address = "http://" + document.getHost() + port + directory + address;
            }
        }
        return address;
    }
}

