/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.collection;

import java.io.File;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.collection.ServiceCluster;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Collection
extends ServiceCluster {
    static Logger logger = Logger.getLogger((String)Collection.class.getName());
    protected boolean useBook = false;
    protected boolean is_public = true;
    protected boolean has_oai = true;
    protected long lastmodified = 0L;
    protected Element service_rack_list = null;
    protected XMLTransformer transformer = null;

    public void setCollectionName(String name) {
        this.setClusterName(name);
    }

    public Collection() {
        this.description = this.doc.createElement("collection");
    }

    public boolean configure() {
        if (this.site_home == null || this.cluster_name == null) {
            logger.error((Object)"Collection: site_home and collection_name must be set before configure called!");
            return false;
        }
        Element coll_config_xml = this.loadCollConfigFile();
        Element build_config_xml = this.loadBuildConfigFile();
        if (coll_config_xml == null || build_config_xml == null) {
            return false;
        }
        Element search = (Element)GSXML.getChildByTagName(coll_config_xml, "search");
        if (search != null) {
            this.col_type = search.getAttribute("type");
        }
        this.findAndLoadInfo(coll_config_xml, build_config_xml);
        Element service_list = (Element)GSXML.getChildByTagName(build_config_xml, "serviceRackList");
        this.configureServiceRack(service_list, coll_config_xml);
        this.service_rack_list = service_list;
        return true;
    }

    public boolean useBook() {
        return this.useBook;
    }

    public boolean isPublic() {
        return this.is_public;
    }

    public long getLastmodified() {
        return this.lastmodified;
    }

    public boolean hasOAI() {
        if (this.service_rack_list == null) {
            return false;
        }
        Element oai_service_rack = GSXML.getNamedElement(this.service_rack_list, "serviceRack", "name", "OAIPMH");
        if (oai_service_rack == null) {
            logger.info((Object)("No oai for collection: " + this.cluster_name));
            return false;
        }
        return true;
    }

    protected Element loadCollConfigFile() {
        File coll_config_file = new File(GSFile.collectionConfigFile(this.site_home, this.cluster_name));
        if (!coll_config_file.exists()) {
            logger.error((Object)("Collection: couldn't configure collection: " + this.cluster_name + ", " + coll_config_file + " does not exist"));
            return null;
        }
        Document coll_config_doc = this.converter.getDOM(coll_config_file, "utf-8");
        Element coll_config_elem = null;
        if (coll_config_doc != null) {
            coll_config_elem = coll_config_doc.getDocumentElement();
        }
        return coll_config_elem;
    }

    protected Element loadBuildConfigFile() {
        File build_config_file = new File(GSFile.collectionBuildConfigFile(this.site_home, this.cluster_name));
        if (!build_config_file.exists()) {
            logger.error((Object)("Collection: couldn't configure collection: " + this.cluster_name + ", " + build_config_file + " does not exist"));
            return null;
        }
        Document build_config_doc = this.converter.getDOM(build_config_file, "utf-8");
        Element build_config_elem = null;
        if (build_config_doc != null) {
            build_config_elem = build_config_doc.getDocumentElement();
        }
        this.lastmodified = build_config_file.lastModified();
        return build_config_elem;
    }

    protected boolean findAndLoadInfo(Element coll_config_xml, Element build_config_xml) {
        String value;
        Element meta_elem;
        Element import_list;
        Element meta_list = (Element)GSXML.getChildByTagName(coll_config_xml, "metadataList");
        this.addMetadata(meta_list);
        meta_list = (Element)GSXML.getChildByTagName(build_config_xml, "metadataList");
        this.addMetadata(meta_list);
        meta_list = this.doc.createElement("metadataList");
        GSXML.addMetadata(this.doc, meta_list, "httpPath", this.site_http_address + "/collect/" + this.cluster_name);
        this.addMetadata(meta_list);
        Element display_list = (Element)GSXML.getChildByTagName(coll_config_xml, "displayItemList");
        if (display_list != null) {
            this.resolveMacros(display_list);
            this.addDisplayItems(display_list);
        }
        if ((import_list = (Element)GSXML.getChildByTagName(coll_config_xml, "import")) != null) {
            Element option_elem;
            Element plugin_elem;
            Element plugin_list = (Element)GSXML.getChildByTagName(import_list, "pluginList");
            this.addPlugins(plugin_list);
            if (plugin_list != null && (plugin_elem = GSXML.getNamedElement(plugin_list, "plugin", "name", "HTMLPlug")) != null && (option_elem = GSXML.getNamedElement(plugin_elem, "option", "name", "-tidy_html")) != null) {
                this.useBook = true;
            }
        }
        meta_list = this.doc.createElement("metadataList");
        if (this.useBook) {
            GSXML.addMetadata(this.doc, meta_list, "tidyoption", "tidy");
        } else {
            GSXML.addMetadata(this.doc, meta_list, "tidyoption", "untidy");
        }
        this.addMetadata(meta_list);
        if (meta_list != null && (meta_elem = GSXML.getNamedElement(this.metadata_list, "metadata", "name", "public")) != null && (value = GSXML.getValue(meta_elem).toLowerCase().trim()).equals("false")) {
            this.is_public = false;
        }
        return true;
    }

    protected boolean resolveMacros(Element display_list) {
        if (display_list == null) {
            return false;
        }
        NodeList displaynodes = display_list.getElementsByTagName("displayItem");
        if (displaynodes.getLength() > 0) {
            String http_site = this.site_http_address;
            String http_collection = this.site_http_address + "/collect/" + this.cluster_name;
            for (int k = 0; k < displaynodes.getLength(); ++k) {
                Element d = (Element)displaynodes.item(k);
                String text = GSXML.getNodeText(d);
                text = text.replaceAll("_httpsite_", http_site);
                text = text.replaceAll("_httpcollection_", http_collection);
                GSXML.setNodeText(d, text);
            }
        }
        return true;
    }

    protected boolean configureSubset(String subset) {
        Element coll_config_elem = this.loadCollConfigFile();
        Element build_config_elem = this.loadBuildConfigFile();
        if (coll_config_elem == null || build_config_elem == null) {
            return false;
        }
        if (subset.equals("serviceList")) {
            Element service_rack_list = (Element)GSXML.getChildByTagName(build_config_elem, "serviceRackList");
            return this.configureServiceRack(service_rack_list, coll_config_elem);
        }
        if (subset.equals("metadataList") || subset.equals("displayItemList") || subset.equals("pluginList")) {
            return this.findAndLoadInfo(coll_config_elem, build_config_elem);
        }
        logger.error((Object)("Collection: cant process system request, configure " + subset));
        return false;
    }
}

