/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.comms;

import java.net.URL;
import java.util.Vector;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.comms.Communicator;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPCommunicator
extends Communicator {
    static Logger logger = Logger.getLogger((String)SOAPCommunicator.class.getName());
    protected String remote_site_address_ = null;
    private Call call_ = null;

    public boolean configure(Element site_elem) {
        String type = site_elem.getAttribute("type");
        if (!type.equals("soap")) {
            logger.error((Object)"wrong type of site");
            return false;
        }
        this.remote_site_name_ = site_elem.getAttribute("name");
        if (this.remote_site_name_.equals("")) {
            logger.error((Object)"must have name attribute in site element");
            return false;
        }
        this.remote_site_address_ = site_elem.getAttribute("address");
        String local_site_name = site_elem.getAttribute("localSite");
        if (this.remote_site_address_.equals("") && local_site_name.equals("")) {
            logger.error((Object)"must have address or localSite attributes in site element");
            return false;
        }
        if (this.remote_site_address_.equals("")) {
            this.remote_site_address_ = GlobalProperties.getGSDL3WebAddress() + "/services/" + local_site_name;
        }
        try {
            Service service = new Service();
            this.call_ = (Call)service.createCall();
            this.call_.setTargetEndpointAddress(new URL(this.remote_site_address_));
        }
        catch (Exception e) {
            logger.error((Object)("SOAPCommunicator.configure() Error: Exception occurred " + e));
            return false;
        }
        return true;
    }

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        NodeList requests = message.getElementsByTagName("request");
        if (requests.getLength() == 0) {
            return null;
        }
        if (this.local_site_name_ != null) {
            for (int i = 0; i < requests.getLength(); ++i) {
                Element e = (Element)requests.item(i);
                String to = e.getAttribute("to");
                to = GSPath.removeFirstLink(to);
                e.setAttribute("to", to);
                String from = e.getAttribute("from");
                from = GSPath.appendLink(from, this.local_site_name_);
                e.setAttribute("from", from);
            }
        }
        Element message_to_send = message;
        if (message.getNamespaceURI() == null) {
            message_to_send = GSXML.duplicateWithNewNameNS(message.getOwnerDocument(), message, "gs3:" + message.getTagName(), "urn:foo", true);
        }
        Element result = null;
        try {
            Object[] input = new SOAPBodyElement[]{new SOAPBodyElement(message_to_send)};
            Vector output = (Vector)this.call_.invoke(input);
            SOAPBodyElement elem = (SOAPBodyElement)output.get(0);
            result = elem.getAsDOM();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (this.local_site_name_ != null) {
            NodeList responses = result.getElementsByTagName("response");
            for (int i = 0; i < responses.getLength(); ++i) {
                Element e = (Element)responses.item(i);
                String from = e.getAttribute("from");
                from = GSPath.prependLink(from, this.remote_site_name_);
                e.setAttribute("from", from);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        SOAPCommunicator comm = new SOAPCommunicator();
        XMLConverter converter = new XMLConverter();
        String message = "<site name=\"localsite\" address=\"http://kanuka.cs.waikato.ac.nz:7070/axis/services/localsite\" type=\"soap\"/>";
        Element site_elem = converter.getDOM(message).getDocumentElement();
        comm.configure(site_elem);
        message = "<message><request type=\"describe\" to=\"\" lang=\"en\"/></message>";
        Element request_elem = converter.getDOM(message).getDocumentElement();
        Node response = comm.process(request_elem);
        logger.error((Object)("response was " + XMLConverter.getPrettyString(response)));
    }
}

