/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.core;

import java.io.File;
import java.util.HashMap;
import org.greenstone.gsdl3.core.Receptionist;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Page {
    private Element page;
    private Element pageRequest;
    private Element pageResponse;
    private Document siteUi;
    private Document collectUi;
    private Document siteMetadata;
    private Document collectMetadata;
    private Receptionist receptionist;

    public Page(Element page, Receptionist receptionist) {
        try {
            this.page = page;
            this.receptionist = receptionist;
            this.pageRequest = (Element)GSXML.getChildByTagName(page, "pageRequest");
            this.pageResponse = (Element)GSXML.getChildByTagName(page, "pageResponse");
            String siteHome = GSFile.siteHome(GlobalProperties.getGSDL3Home(), this.getSite());
            String collection = this.getCollection();
            File siteUiFile = new File(siteHome + File.separatorChar + "ui" + File.separatorChar + "ui.xml");
            this.siteUi = receptionist.converter.getDOM(siteUiFile, "utf-8");
            if (this.siteUi == null) {
                System.out.println(" could not parse site level ui file: " + siteUiFile.getPath());
            }
            File siteMetadataFile = new File(siteHome + File.separatorChar + "metadata.xml");
            this.siteMetadata = receptionist.converter.getDOM(siteMetadataFile, "utf-8");
            if (this.siteMetadata == null) {
                System.out.println(" could not parse site level metadata file: " + siteMetadataFile.getPath());
            }
            if (!collection.equals("")) {
                File collectUiFile = new File(GSFile.collectionBaseDir(siteHome, collection) + File.separatorChar + "ui" + File.separatorChar + "ui.xml");
                this.collectUi = receptionist.converter.getDOM(collectUiFile, "utf-8");
                if (this.collectUi == null) {
                    System.out.println(" could not parse collect level ui file: " + collectUiFile.getPath());
                }
                File collectMetadataFile = new File(GSFile.collectionBaseDir(siteHome, collection) + File.separatorChar + "metadata.xml");
                this.collectMetadata = receptionist.converter.getDOM(collectMetadataFile, "utf-8");
                if (this.collectMetadata == null) {
                    System.out.println(" could not parse collect level metadata file: " + collectMetadataFile.getPath());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Element getPage() {
        return this.page;
    }

    public Element getPageRequest() {
        return this.pageRequest;
    }

    public Element getPageResponse() {
        return this.pageResponse;
    }

    public String getAction() {
        return this.pageRequest.getAttribute("action");
    }

    public String getSubaction() {
        return this.pageRequest.getAttribute("subaction");
    }

    public String getSiteHome() {
        return GSFile.siteHome(GlobalProperties.getGSDL3Home(), this.getSite());
    }

    public String getCollectionHome() {
        String collection = this.getCollection();
        if (!collection.equals("")) {
            return GSFile.collectionBaseDir(this.getSiteHome(), collection);
        }
        return null;
    }

    public Document getSiteUi() {
        return this.siteUi;
    }

    public Document getCollectUi() {
        return this.collectUi;
    }

    public Document getSiteMetadata() {
        return this.siteMetadata;
    }

    public Document getCollectMetadata() {
        return this.collectMetadata;
    }

    public String getLanguage() {
        String lang = this.pageRequest.getAttribute("lang");
        return lang;
    }

    public String getSite() {
        return (String)this.receptionist.config_params.get("site_name");
    }

    public String getCollection() {
        HashMap params;
        String collection = "";
        Element request = (Element)GSXML.getChildByTagName(this.page, "pageRequest");
        Element cgi_param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (cgi_param_list != null && (collection = (String)(params = GSXML.extractParams(cgi_param_list, false)).get("c")) == null) {
            collection = "";
        }
        return collection;
    }
}

