/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.build.GS2PerlConstructor;
import org.greenstone.gsdl3.build.GS2PerlListener;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSStatus;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GS2Construct
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)GS2Construct.class.getName());
    private static final String NEW_SERVICE = "NewCollection";
    private static final String ADD_DOC_SERVICE = "AddDocument";
    private static final String IMPORT_SERVICE = "ImportCollection";
    private static final String BUILD_SERVICE = "BuildCollection";
    private static final String ACTIVATE_SERVICE = "ActivateCollection";
    private static final String DELETE_SERVICE = "DeleteCollection";
    private static final String RELOAD_SERVICE = "ReloadCollection";
    private static final String COL_PARAM = "collection";
    private static final String NEW_COL_TITLE_PARAM = "collTitle";
    private static final String NEW_COL_ABOUT_PARAM = "collAbout";
    private static final String CREATOR_PARAM = "creator";
    private static final String NEW_FILE_PARAM = "newfile";
    private static final String PROCESS_ID_PARAM = "pid";
    private static final String BUILDTYPE_PARAM = "buildType";
    private static final String BUILDTYPE_MG = "mg";
    private static final String BUILDTYPE_MGPP = "mgpp";
    private String[] collection_list = null;
    protected Map listeners = Collections.synchronizedMap(new HashMap());
    private int current_id = 0;

    protected Element getServiceDescription(String service, String lang, String subset) {
        Element description = this.doc.createElement("service");
        description.setAttribute("type", "process");
        description.setAttribute("name", service);
        if (subset == null || subset.equals("displayItemList")) {
            description.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getTextString(service + ".name", lang)));
            description.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getTextString(service + ".description", lang)));
            description.appendChild(GSXML.createDisplayTextElement(this.doc, "submit", this.getTextString(service + ".submit", lang)));
        }
        if (subset == null || subset.equals("paramList")) {
            Element param_list = this.doc.createElement("paramList");
            description.appendChild(param_list);
            if (service.equals(NEW_SERVICE)) {
                Element param = GSXML.createParameterDescription(this.doc, NEW_COL_TITLE_PARAM, this.getTextString("param.collTitle", lang), "string", null, null, null);
                param_list.appendChild(param);
                param = GSXML.createParameterDescription(this.doc, CREATOR_PARAM, this.getTextString("param.creator", lang), "string", null, null, null);
                param_list.appendChild(param);
                param = GSXML.createParameterDescription(this.doc, NEW_COL_ABOUT_PARAM, this.getTextString("param.collAbout", lang), "text", null, null, null);
                param_list.appendChild(param);
                String[] types = new String[]{BUILDTYPE_MGPP, BUILDTYPE_MG};
                String[] type_texts = new String[]{this.getTextString("param.buildType.mgpp", lang), this.getTextString("param.buildType.mg", lang)};
                param = GSXML.createParameterDescription(this.doc, BUILDTYPE_PARAM, this.getTextString("param.buildType", lang), "enum_single", BUILDTYPE_MGPP, types, type_texts);
                param_list.appendChild(param);
            } else if (service.equals(ACTIVATE_SERVICE) || service.equals(IMPORT_SERVICE) || service.equals(BUILD_SERVICE) || service.equals(RELOAD_SERVICE) || service.equals(DELETE_SERVICE)) {
                this.collection_list = this.getCollectionList();
                Element param = GSXML.createParameterDescription(this.doc, COL_PARAM, this.getTextString("param.collection", lang), "enum_single", null, this.collection_list, this.collection_list);
                param_list.appendChild(param);
            } else {
                return null;
            }
        }
        return description;
    }

    protected Element processNewCollection(Element request) {
        return this.runCommand(request, 0);
    }

    protected Element processAddDocument(Element request) {
        String name = GSPath.getFirstLink(request.getAttribute("to"));
        Element response = this.doc.createElement("response");
        response.setAttribute("from", name);
        Element status = this.doc.createElement("status");
        response.appendChild(status);
        Text t = this.doc.createTextNode("AddDocument: not implemented yet");
        status.appendChild(t);
        status.setAttribute("code", Integer.toString(3));
        return response;
    }

    protected Element processImportCollection(Element request) {
        return this.runCommand(request, 1);
    }

    protected Element processBuildCollection(Element request) {
        return this.runCommand(request, 2);
    }

    protected Element processActivateCollection(Element request) {
        Element response = this.runCommand(request, 3);
        Element status = (Element)GSXML.getChildByTagName(response, "status");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(param_list, false);
        String coll_name = (String)params.get(COL_PARAM);
        String lang = request.getAttribute("lang");
        int status_code = Integer.parseInt(status.getAttribute("code"));
        if (GSStatus.isCompleted(status_code) && GSStatus.isError(status_code)) {
            return response;
        }
        String id = status.getAttribute(PROCESS_ID_PARAM);
        GS2PerlListener listener = (GS2PerlListener)this.listeners.get(id);
        if (listener == null) {
            logger.error((Object)"somethings gone wrong, couldn't find the listener");
            status.setAttribute("code", Integer.toString(3));
            return response;
        }
        while (!GSStatus.isCompleted(status_code)) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            status_code = listener.getStatus();
        }
        Text t = this.doc.createTextNode("\n" + listener.getUpdate());
        status.appendChild(t);
        status.setAttribute("code", Integer.toString(listener.getStatus()));
        if (GSStatus.isError(status_code)) {
            return response;
        }
        t = this.doc.createTextNode("\n");
        status.appendChild(t);
        this.systemRequest("reload", coll_name, status, lang);
        return response;
    }

    protected Element processDeleteCollection(Element request) {
        String name = GSPath.getFirstLink(request.getAttribute("to"));
        Element response = this.doc.createElement("response");
        response.setAttribute("from", name);
        Element status = this.doc.createElement("status");
        response.appendChild(status);
        Text t = null;
        String lang = request.getAttribute("lang");
        String request_type = request.getAttribute("type");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(param_list, false);
        boolean get_status_only = false;
        if (request_type.equals("status")) {
            get_status_only = true;
        }
        if (get_status_only) {
            logger.error((Object)"had a status request for delete - this shouldn't happen!!");
            status.setAttribute("code", Integer.toString(3));
            return response;
        }
        String coll_name = (String)params.get(COL_PARAM);
        String[] args = new String[]{coll_name};
        File coll_dir = new File(GSFile.collectionBaseDir(this.site_home, coll_name));
        if (!coll_dir.exists()) {
            t = this.doc.createTextNode(this.getTextString("delete.exists_error", lang, args));
            status.appendChild(t);
            status.setAttribute("code", Integer.toString(3));
            return response;
        }
        if (!GSFile.deleteFile(coll_dir)) {
            t = this.doc.createTextNode(this.getTextString("delete.delete_error", lang, args));
            status.setAttribute("code", Integer.toString(3));
            status.appendChild(t);
            return response;
        }
        this.systemRequest("delete", coll_name, status, lang);
        return response;
    }

    protected Element processReloadCollection(Element request) {
        String name = GSPath.getFirstLink(request.getAttribute("to"));
        Element response = this.doc.createElement("response");
        response.setAttribute("from", name);
        Element status = this.doc.createElement("status");
        response.appendChild(status);
        Object t = null;
        String lang = request.getAttribute("lang");
        String request_type = request.getAttribute("type");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(param_list, false);
        boolean get_status_only = false;
        if (request_type.equals("status")) {
            get_status_only = true;
        }
        if (get_status_only) {
            logger.error((Object)"had a status request for reload - this shouldn't happen!!");
            status.setAttribute("code", Integer.toString(3));
            return response;
        }
        String coll_name = (String)params.get(COL_PARAM);
        this.systemRequest("reload", coll_name, status, lang);
        return response;
    }

    protected void systemRequest(String action_name, String coll_name, Element status, String lang) {
        Element message = this.doc.createElement("message");
        Element request = GSXML.createBasicRequest(this.doc, "system", "", lang, "");
        message.appendChild(request);
        Element command = this.doc.createElement("system");
        request.appendChild(command);
        command.setAttribute("moduleType", COL_PARAM);
        command.setAttribute("moduleName", coll_name);
        if (action_name.equals("delete")) {
            command.setAttribute("type", "deactivate");
        } else if (action_name.equals("reload")) {
            command.setAttribute("type", "activate");
        } else {
            logger.error((Object)("invalid action name passed to systemRequest:" + action_name));
            return;
        }
        request.appendChild(command);
        Node response = this.router.process(message);
        String[] args = new String[]{coll_name};
        if (response == null) {
            Text t = this.doc.createTextNode(this.getTextString(action_name + ".configure_error", lang, args));
            status.setAttribute("code", Integer.toString(3));
            status.appendChild(t);
            return;
        }
        Text t = this.doc.createTextNode(this.getTextString(action_name + ".success", lang, args));
        status.setAttribute("code", Integer.toString(1));
        status.appendChild(t);
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"configuring GS2Construct");
        Element e = null;
        e = this.doc.createElement("service");
        e.setAttribute("type", "process");
        e.setAttribute("name", NEW_SERVICE);
        this.short_service_info.appendChild(e);
        e = this.doc.createElement("service");
        e.setAttribute("type", "process");
        e.setAttribute("name", IMPORT_SERVICE);
        this.short_service_info.appendChild(e);
        e = this.doc.createElement("service");
        e.setAttribute("type", "process");
        e.setAttribute("name", BUILD_SERVICE);
        this.short_service_info.appendChild(e);
        e = this.doc.createElement("service");
        e.setAttribute("type", "process");
        e.setAttribute("name", ACTIVATE_SERVICE);
        this.short_service_info.appendChild(e);
        e = this.doc.createElement("service");
        e.setAttribute("type", "process");
        e.setAttribute("name", DELETE_SERVICE);
        this.short_service_info.appendChild(e);
        e = this.doc.createElement("service");
        e.setAttribute("type", "process");
        e.setAttribute("name", RELOAD_SERVICE);
        this.short_service_info.appendChild(e);
        return true;
    }

    protected Element runCommand(Element request, int type) {
        String name = GSPath.getFirstLink(request.getAttribute("to"));
        Element response = this.doc.createElement("response");
        response.setAttribute("from", name);
        Element status = this.doc.createElement("status");
        response.appendChild(status);
        String lang = request.getAttribute("lang");
        String request_type = request.getAttribute("type");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(param_list, false);
        boolean get_status_only = false;
        if (request_type.equals("status")) {
            get_status_only = true;
        }
        if (get_status_only) {
            String id = (String)params.get(PROCESS_ID_PARAM);
            status.setAttribute(PROCESS_ID_PARAM, id);
            GS2PerlListener listener = (GS2PerlListener)this.listeners.get(id);
            if (listener == null) {
                Text t = this.doc.createTextNode(this.getTextString("general.process_id_error", lang));
                status.appendChild(t);
                status.setAttribute("code", Integer.toString(3));
            } else {
                Text t = this.doc.createTextNode(listener.getUpdate());
                status.appendChild(t);
                status.setAttribute("code", Integer.toString(listener.getStatus()));
                if (listener.isFinished()) {
                    this.listeners.remove(id);
                }
            }
            return response;
        }
        String coll_name = null;
        if (type == 0) {
            String coll_title = (String)params.get(NEW_COL_TITLE_PARAM);
            coll_name = this.createNewCollName(coll_title);
        } else {
            coll_name = (String)params.get(COL_PARAM);
        }
        logger.error((Object)("Coll name = " + coll_name));
        Element other_params = this.extractOtherParams(params, type);
        GS2PerlConstructor constructor = new GS2PerlConstructor("perl_build");
        if (!constructor.configure()) {
            Text t = this.doc.createTextNode(this.getTextString("general.configure_constructor_error", lang));
            status.appendChild(t);
            status.setAttribute("code", Integer.toString(3));
            return response;
        }
        constructor.setSiteHome(this.site_home);
        constructor.setCollectionName(coll_name);
        constructor.setActionType(type);
        constructor.setProcessParams(other_params);
        GS2PerlListener listener = new GS2PerlListener();
        constructor.addListener(listener);
        constructor.start();
        String id = this.newID();
        this.listeners.put(id, listener);
        status.setAttribute(PROCESS_ID_PARAM, id);
        status.setAttribute("code", Integer.toString(2));
        Text t = this.doc.createTextNode(this.getTextString("general.process_start", lang));
        status.appendChild(t);
        return response;
    }

    protected String[] getCollectionList() {
        File collectDir = new File(GSFile.collectDir(this.site_home));
        if (!collectDir.exists()) {
            logger.error((Object)("couldn't find collect dir: " + collectDir.toString()));
            return null;
        }
        logger.info((Object)("GS2Construct: reading thru directory " + collectDir.getPath() + " to find collections."));
        File[] contents = collectDir.listFiles();
        int num_colls = 0;
        for (int i = 0; i < contents.length; ++i) {
            if (!contents[i].isDirectory() || contents[i].getName().startsWith("CVS")) continue;
            ++num_colls;
        }
        String[] names = new String[num_colls];
        int j = 0;
        for (int i = 0; i < contents.length; ++i) {
            String colName;
            if (!contents[i].isDirectory() || (colName = contents[i].getName()).startsWith("CVS")) continue;
            names[j] = colName;
            ++j;
        }
        return names;
    }

    private String newID() {
        ++this.current_id;
        return Integer.toString(this.current_id);
    }

    protected String createNewCollName(String coll_title) {
        String base_name = null;
        base_name = coll_title.length() < 6 ? coll_title : coll_title.substring(0, 6);
        File coll_dir = new File(GSFile.collectionBaseDir(this.site_home, base_name));
        if (!coll_dir.exists()) {
            return base_name;
        }
        int i = 0;
        while (coll_dir.exists()) {
            coll_dir = new File(GSFile.collectionBaseDir(this.site_home, base_name + Integer.toString(++i)));
        }
        return base_name + Integer.toString(i);
    }

    protected Element extractOtherParams(HashMap params, int type) {
        Element param_list = this.doc.createElement("paramList");
        if (type == 0) {
            Element param = this.doc.createElement("param");
            param.setAttribute("name", CREATOR_PARAM);
            param.setAttribute("value", (String)params.get(CREATOR_PARAM));
            param_list.appendChild(param);
            param = this.doc.createElement("param");
            param.setAttribute("name", "about");
            param.setAttribute("value", (String)params.get(NEW_COL_ABOUT_PARAM));
            param_list.appendChild(param);
            param = this.doc.createElement("param");
            param.setAttribute("name", "title");
            param.setAttribute("value", (String)params.get(NEW_COL_TITLE_PARAM));
            param_list.appendChild(param);
            param = this.doc.createElement("param");
            param.setAttribute("name", "buildtype");
            param.setAttribute("value", (String)params.get(BUILDTYPE_PARAM));
            param_list.appendChild(param);
            return param_list;
        }
        return null;
    }
}

