/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IViaProxy
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)IViaProxy.class.getName());
    protected static final String TEXT_QUERY_SERVICE = "TextQuery";
    protected static final String DOC_CONTENT_SERVICE = "DocumentContentRetrieve";
    protected static final String DOC_META_SERVICE = "DocumentMetadataRetrieve";
    protected static final String QUERY_PARAM = "query";
    protected static final String FIELD_PARAM = "fields";
    protected static final String GS_HITS_PARAM = "hitsPerPage";
    protected static final String IM_HITS_PARAM = "no_of_records_per_page";
    protected static final String GS_START_PAGE_PARAM = "startPage";
    protected static final String IM_START_PAGE_PARAM = "start_page_no";
    protected String ivia_server_url = null;

    public boolean configure(Element info, Element extra_info) {
        Element display_format;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        Element server_elem = (Element)GSXML.getChildByTagName(info, "iViaServer");
        if (server_elem == null) {
            logger.error((Object)"no iViaServer element found");
            return false;
        }
        this.ivia_server_url = server_elem.getAttribute("url");
        if (this.ivia_server_url.equals("")) {
            logger.error((Object)"no url for the iViaServer element");
            return false;
        }
        Element tq_service = this.doc.createElement("service");
        tq_service.setAttribute("type", QUERY_PARAM);
        tq_service.setAttribute("name", TEXT_QUERY_SERVICE);
        this.short_service_info.appendChild(tq_service);
        Element dc_service = this.doc.createElement("service");
        dc_service.setAttribute("type", "retrieve");
        dc_service.setAttribute("name", DOC_CONTENT_SERVICE);
        this.short_service_info.appendChild(dc_service);
        Element dm_service = this.doc.createElement("service");
        dm_service.setAttribute("type", "retrieve");
        dm_service.setAttribute("name", DOC_META_SERVICE);
        this.short_service_info.appendChild(dm_service);
        String path = GSPath.appendLink("search", "format");
        Element format = (Element)GSXML.getNodeByPath(extra_info, path);
        if (format != null) {
            this.format_info_map.put(TEXT_QUERY_SERVICE, this.doc.importNode(format, true));
        }
        if ((display_format = (Element)GSXML.getNodeByPath(extra_info, path = GSPath.appendLink("display", "format"))) != null) {
            this.format_info_map.put(DOC_CONTENT_SERVICE, this.doc.importNode(display_format, true));
        }
        return true;
    }

    protected Element getServiceDescription(String service, String lang, String subset) {
        if (service.equals(TEXT_QUERY_SERVICE)) {
            Element tq_service = this.doc.createElement("service");
            tq_service.setAttribute("type", QUERY_PARAM);
            tq_service.setAttribute("name", TEXT_QUERY_SERVICE);
            if (subset == null || subset.equals("displayItemList")) {
                tq_service.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getTextString("TextQuery.name", lang)));
                tq_service.appendChild(GSXML.createDisplayTextElement(this.doc, "submit", this.getTextString("TextQuery.submit", lang)));
                tq_service.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getTextString("TextQuery.description", lang)));
            }
            if (subset == null || subset.equals("paramList")) {
                Element param_list = this.doc.createElement("paramList");
                tq_service.appendChild(param_list);
                Element param = GSXML.createParameterDescription(this.doc, QUERY_PARAM, this.getTextString("param.query", lang), "string", null, null, null);
                param_list.appendChild(param);
                String[] field_ids = new String[]{"kw", "au", "su", "ti", "de", "fu"};
                String[] field_names = new String[]{this.getTextString("param.fields.kw", lang), this.getTextString("param.fields.au", lang), this.getTextString("param.fields.su", lang), this.getTextString("param.fields.ti", lang), this.getTextString("param.fields.de", lang), this.getTextString("param.fields.fu", lang)};
                param = GSXML.createParameterDescription(this.doc, FIELD_PARAM, this.getTextString("param.fields", lang), "enum_multi", "kw,au,su,ti,de,fu", field_ids, field_names);
                param_list.appendChild(param);
                String[] hits_options = new String[]{"10", "30", "50"};
                param = GSXML.createParameterDescription(this.doc, GS_HITS_PARAM, this.getTextString("param.hitsPerPage", lang), "enum_single", "10", hits_options, hits_options);
                param_list.appendChild(param);
                param = GSXML.createParameterDescription(this.doc, GS_START_PAGE_PARAM, "", "invisible", "1", null, null);
                param_list.appendChild(param);
            }
            return tq_service;
        }
        if (service.equals(DOC_META_SERVICE)) {
            Element dm_service = this.doc.createElement("service");
            dm_service.setAttribute("type", "retrieve");
            dm_service.setAttribute("name", DOC_META_SERVICE);
            return dm_service;
        }
        if (service.equals(DOC_CONTENT_SERVICE)) {
            Element dc_service = this.doc.createElement("service");
            dc_service.setAttribute("type", "retrieve");
            dc_service.setAttribute("name", DOC_CONTENT_SERVICE);
            return dc_service;
        }
        return null;
    }

    protected Element processTextQuery(Element request) {
        String start_page;
        String hits_per_page;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", TEXT_QUERY_SERVICE);
        result.setAttribute("type", "process");
        Element doc_node_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_node_list);
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"TextQuery request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String query = (String)params.get(QUERY_PARAM);
        if (query == null || query.equals("")) {
            return result;
        }
        query = query.replaceAll("\\s+", "+");
        String url_string = this.ivia_server_url + "/cgi-bin/canned_search?theme=gsdl3&query=" + query;
        String fields = (String)params.get(FIELD_PARAM);
        if (fields != null && !fields.equals("")) {
            url_string = url_string + "&fields=" + fields;
        }
        if ((hits_per_page = (String)params.get(GS_HITS_PARAM)) != null && !hits_per_page.equals("")) {
            url_string = url_string + "&no_of_records_per_page=" + hits_per_page;
        }
        if ((start_page = (String)params.get(GS_START_PAGE_PARAM)) != null && !start_page.equals("")) {
            url_string = url_string + "&start_page_no=" + start_page;
        }
        String results_num = null;
        String doc_ids = null;
        try {
            logger.debug((Object)("IViaProxy, sending " + url_string));
            BufferedReader reader = this.makeConnection(url_string);
            results_num = reader.readLine();
            doc_ids = reader.readLine();
        }
        catch (Exception e) {
            logger.error((Object)"exception happened during query");
            e.printStackTrace();
            return result;
        }
        if (!results_num.startsWith("Resources: ")) {
            logger.error((Object)("badly formatted results line: " + results_num));
            return result;
        }
        results_num = results_num.substring(11);
        if (!doc_ids.startsWith("Ids: ")) {
            logger.error((Object)("badly formatted docs line: " + doc_ids));
            return result;
        }
        doc_ids = doc_ids.substring(5).trim();
        Element metadata_list = this.doc.createElement("metadataList");
        result.appendChild(metadata_list);
        long numdocs = Long.parseLong(results_num);
        GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "" + numdocs);
        String[] ids = doc_ids.split(" ");
        for (int d = 0; d < ids.length; ++d) {
            Element doc_node = this.doc.createElement("documentNode");
            doc_node.setAttribute("nodeID", ids[d]);
            doc_node_list.appendChild(doc_node);
        }
        logger.debug((Object)"IViaProxy result:");
        logger.debug((Object)XMLConverter.getString(result));
        return result;
    }

    protected Element processDocumentMetadataRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", DOC_META_SERVICE);
        result.setAttribute("type", "process");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"missing paramList.\n");
            return result;
        }
        StringBuffer field_list = new StringBuffer();
        for (Element param = GSXML.getFirstElementChild(param_list); param != null; param = (Element)param.getNextSibling()) {
            String metadata;
            if (!param.getAttribute("name").equals("metadata") || !this.isAcceptableMetadata(metadata = GSXML.getValue(param))) continue;
            field_list.append(metadata);
            field_list.append(",");
        }
        if (field_list.length() == 0) {
            logger.error((Object)"no metadata specified.\n");
            return result;
        }
        Element request_node_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (request_node_list == null) {
            logger.error((Object)"DocumentMetadataRetrieve request had no documentNodeList.\n");
            return result;
        }
        StringBuffer record_id_list = new StringBuffer();
        NodeList request_nodes = request_node_list.getChildNodes();
        for (int i = 0; i < request_nodes.getLength(); ++i) {
            Element request_node = (Element)request_nodes.item(i);
            String node_id = request_node.getAttribute("nodeID");
            record_id_list.append(node_id);
            record_id_list.append(",");
        }
        String url_string = this.ivia_server_url + "/cgi-bin/view_record_set?theme=gsdl3&record_id_list=" + record_id_list.toString() + "&field_list=" + field_list.toString();
        Element node_list = this.doc.createElement("documentNodeList");
        result.appendChild(node_list);
        try {
            String line;
            BufferedReader reader = this.makeConnection(url_string);
            while ((line = reader.readLine()) != null) {
                int col_pos;
                if (!line.startsWith("Record:")) continue;
                line = line.substring(8);
                Element doc_node = this.doc.createElement("documentNode");
                doc_node.setAttribute("nodeID", line);
                Element meta_list = this.doc.createElement("metadataList");
                doc_node.appendChild(meta_list);
                while ((line = reader.readLine()) != null && (col_pos = line.indexOf(58)) != -1) {
                    String name = line.substring(0, col_pos);
                    String value = line.substring(col_pos + 2);
                    GSXML.addMetadata(this.doc, meta_list, name, value);
                }
                node_list.appendChild(doc_node);
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception happened");
            e.printStackTrace();
        }
        logger.debug((Object)"IViaProxy: returning result: ");
        logger.debug((Object)XMLConverter.getPrettyString(result));
        return result;
    }

    protected Element processDocumentContentRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", DOC_CONTENT_SERVICE);
        result.setAttribute("type", "process");
        Element query_doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (query_doc_list == null) {
            logger.error((Object)"DocumentContentRetrieve request specified no doc nodes.\n");
            return result;
        }
        Element doc_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_list);
        String[] doc_ids = GSXML.getAttributeValuesFromList(query_doc_list, "nodeID");
        for (int i = 0; i < doc_ids.length; ++i) {
            String doc_id = doc_ids[i];
            Element doc_node = this.getDocument(doc_id);
            doc_list.appendChild(doc_node);
        }
        return result;
    }

    protected Element getDocument(String doc_id) {
        String url_string = this.ivia_server_url + "/cgi-bin/view_record?theme=gsdl3&record_id=" + doc_id;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            BufferedReader reader = this.makeConnection(url_string);
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception happened");
            e.printStackTrace();
        }
        String node_content = buffer.toString();
        String escaped_content = GSXML.xmlSafe(node_content);
        StringBuffer processed_content = new StringBuffer(escaped_content.length());
        processed_content.append("<nodeContent>");
        int pos = 0;
        int lastpos = 0;
        while ((pos = escaped_content.indexOf("&lt;a ", lastpos)) != -1) {
            processed_content.append(escaped_content.substring(lastpos, pos));
            int endpos = escaped_content.indexOf("&lt;/a&gt;", pos);
            if (endpos == -1) break;
            String link = escaped_content.substring(pos, endpos + 10);
            link = this.convertLink(link);
            processed_content.append(link);
            lastpos = endpos + 10;
        }
        processed_content.append(escaped_content.substring(lastpos));
        processed_content.append("</nodeContent>");
        Element doc_node = this.doc.createElement("documentNode");
        doc_node.setAttribute("nodeID", doc_id);
        Document content_doc = this.converter.getDOM(processed_content.toString());
        if (content_doc != null) {
            Element content_element = content_doc.getDocumentElement();
            doc_node.appendChild(this.doc.importNode(content_element, true));
        } else {
            logger.error((Object)"Couldn't parse the node content");
        }
        return doc_node;
    }

    protected String convertLink(String aref) {
        if (aref.indexOf("href=&quot;http") != -1) {
            return aref;
        }
        String type = "other";
        if (aref.indexOf("/cgi-bin/canned_search") != -1) {
            type = QUERY_PARAM;
        } else if (aref.indexOf("/cgi-bin/click_through") != -1) {
            type = "external";
        } else if (aref.indexOf("/cgi-bin/view_record") != -1) {
            type = "document";
        }
        int href_start = aref.indexOf("href=&quot;") + 11;
        int href_end = aref.indexOf("&gt;", href_start);
        String href = aref.substring(href_start, href_end);
        String link_content = aref.substring(href_end + 4, aref.length() - 10);
        if (type.equals("external")) {
            String address = href.substring(href.lastIndexOf("http"));
            address = address.replaceAll("%3[aA]", ":");
            address = address.replaceAll("%2[fF]", "/");
            return "&lt;a href=\"" + address + "\"&gt;" + link_content + "&lt;/a&gt;";
        }
        if (type.equals("other")) {
            return "other type of link (" + link_content + ")";
        }
        StringBuffer result = new StringBuffer();
        result.append("<link type='");
        result.append(type);
        result.append("'");
        if (type.equals(QUERY_PARAM)) {
            result.append(" service='TextQuery'");
        }
        result.append(">");
        href = href.substring(href.indexOf("?") + 1);
        String[] params = href.split("&amp;");
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            int eq_pos = param.indexOf("=");
            if (eq_pos == -1) continue;
            result.append("<param name='" + param.substring(0, eq_pos) + "' value='" + param.substring(eq_pos + 1) + "'/>");
        }
        result.append(link_content);
        result.append("</link>");
        return result.toString();
    }

    protected boolean isAcceptableMetadata(String meta) {
        String valid_metadata = ",title,url,ivia_description,keywords,subjects,";
        return valid_metadata.indexOf("," + meta + ",") != -1;
    }

    protected BufferedReader makeConnection(String url_string) {
        BufferedReader reader = null;
        try {
            URL url = new URL(url_string);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream input = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(input));
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Malformed URL: " + url_string));
        }
        catch (IOException e) {
            logger.error((Object)("An error occurred during IO to url " + url_string));
        }
        return reader;
    }
}

