/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapRetrieve
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)MapRetrieve.class.getName());
    protected static final String DOCUMENT_STRUCTURE_RETRIEVE_SERVICE = "DocumentStructureRetrieve";
    protected static final String DOCUMENT_METADATA_RETRIEVE_SERVICE = "DocumentMetadataRetrieve";
    protected static final String DOCUMENT_CONTENT_RETRIEVE_SERVICE = "DocumentContentRetrieve";
    protected static final int DOCUMENT = 1;
    protected ArrayList index_name_list = null;
    protected ArrayList index_display_list = null;
    protected String files_home_dir = null;
    protected String temp_files_dir = null;
    protected final String jpg_ext = ".jpg";
    protected String http_image_dir = null;
    protected String http_temp_image_dir = null;
    private LinkedList namesInList = new LinkedList();
    private DefaultMutableTreeNode tree;

    public boolean configure(Element info, Element extra_info) {
        String path;
        Element display_format;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring MapRetrieve...");
        this.config_info = info;
        Element dmr_service = this.doc.createElement("service");
        dmr_service.setAttribute("type", "retrieve");
        dmr_service.setAttribute("name", DOCUMENT_METADATA_RETRIEVE_SERVICE);
        this.short_service_info.appendChild(dmr_service);
        Element dcr_service = this.doc.createElement("service");
        dcr_service.setAttribute("type", "retrieve");
        dcr_service.setAttribute("name", DOCUMENT_CONTENT_RETRIEVE_SERVICE);
        this.short_service_info.appendChild(dcr_service);
        Element dsr_service = this.doc.createElement("service");
        dsr_service.setAttribute("type", "retrieve");
        dsr_service.setAttribute("name", DOCUMENT_STRUCTURE_RETRIEVE_SERVICE);
        this.short_service_info.appendChild(dsr_service);
        this.files_home_dir = GSFile.collectionIndexDir(this.site_home, this.cluster_name) + File.separator + "assoc" + File.separator;
        this.temp_files_dir = GSFile.collectionBaseDir(this.site_home, this.cluster_name) + File.separator + "temp" + File.separator;
        this.http_image_dir = this.site_http_address + "/collect/" + this.cluster_name + "/index/assoc/maps/";
        this.http_temp_image_dir = this.site_http_address + "/collect/" + this.cluster_name + "/temp/";
        this.index_name_list = new ArrayList();
        this.index_display_list = new ArrayList();
        Element index_list = (Element)GSXML.getChildByTagName(this.config_info, "indexList");
        Element display_index_list = (Element)GSXML.getChildByTagName(extra_info, "search");
        if (index_list != null && display_index_list != null) {
            NodeList indexes = index_list.getElementsByTagName("index");
            for (int i = 0; i < indexes.getLength(); ++i) {
                String display;
                Element disp;
                String name = ((Element)indexes.item(i)).getAttribute("name");
                this.index_name_list.add(name);
                Element this_index = GSXML.getNamedElement(display_index_list, "index", "name", name);
                if (this_index != null && (disp = GSXML.getNamedElement(this_index, "displayItem", "name", "name")) != null && !(display = GSXML.getNodeText(disp)).equals("")) {
                    this.index_display_list.add(display);
                    continue;
                }
                this.index_display_list.add(name);
            }
        }
        if ((display_format = (Element)GSXML.getNodeByPath(extra_info, path = GSPath.appendLink("display", "format"))) != null) {
            this.format_info_map.put(DOCUMENT_CONTENT_RETRIEVE_SERVICE, this.doc.importNode(display_format, true));
        }
        try {
            ObjectInputStream objectin = new ObjectInputStream(new FileInputStream(this.files_home_dir + "nametree.dat"));
            this.tree = (DefaultMutableTreeNode)objectin.readObject();
            objectin.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return true;
    }

    protected Element getServiceDescription(String service, String lang, String subset) {
        if (service.equals(DOCUMENT_STRUCTURE_RETRIEVE_SERVICE)) {
            Element tq_service = this.doc.createElement("service");
            tq_service.setAttribute("type", "query");
            tq_service.setAttribute("name", DOCUMENT_STRUCTURE_RETRIEVE_SERVICE);
            return tq_service;
        }
        if (service.equals(DOCUMENT_METADATA_RETRIEVE_SERVICE)) {
            Element tq_service = this.doc.createElement("service");
            tq_service.setAttribute("type", "query");
            tq_service.setAttribute("name", DOCUMENT_METADATA_RETRIEVE_SERVICE);
            return tq_service;
        }
        if (service.equals(DOCUMENT_CONTENT_RETRIEVE_SERVICE)) {
            Element tq_service = this.doc.createElement("service");
            tq_service.setAttribute("type", "query");
            tq_service.setAttribute("name", DOCUMENT_CONTENT_RETRIEVE_SERVICE);
            return tq_service;
        }
        return null;
    }

    protected Element processDocumentStructureRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        return result;
    }

    protected Element processDocumentMetadataRetrieve(Element request) {
        try {
            Element result = this.doc.createElement("response");
            String uid = request.getAttribute("uid");
            if (uid.equals("")) {
                logger.info((Object)("in metadata retrieve, uid = ''\n" + XMLConverter.getPrettyString(request)));
            }
            result.setAttribute("from", DOCUMENT_METADATA_RETRIEVE_SERVICE);
            result.setAttribute("type", "process");
            Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
            if (param_list == null) {
                logger.error((Object)"missing paramList.\n");
                return result;
            }
            Vector<String> metadata_list = new Vector<String>();
            boolean all_metadata = false;
            for (Element param = GSXML.getFirstElementChild(param_list); param != null; param = (Element)param.getNextSibling()) {
                if (!param.getAttribute("name").equals("metadata")) continue;
                String metadata = GSXML.getValue(param);
                if (metadata.equals("all")) {
                    all_metadata = true;
                    break;
                }
                metadata_list.add(metadata);
            }
            Element node_list = this.doc.createElement("documentNodeList");
            result.appendChild(node_list);
            Element request_node_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
            if (request_node_list == null) {
                logger.error((Object)" DocumentMetadataRetrieve request had no documentNodeList");
                return result;
            }
            NodeList request_nodes = request_node_list.getChildNodes();
            try {
                BufferedWriter outfile = new BufferedWriter(new FileWriter(this.temp_files_dir + "emptynothingness"));
                for (int i = 0; i < request_nodes.getLength(); ++i) {
                    Element request_node = (Element)request_nodes.item(i);
                    String node_id = request_node.getAttribute("nodeID");
                    String place_data = "";
                    String year = "";
                    String coOrdinates = "";
                    String thumb = "";
                    String link = "";
                    int mapFreq = 0;
                    LinkedList<String> place_data_list = new LinkedList<String>();
                    LinkedList<String> coOrdinates_list = new LinkedList<String>();
                    if (node_id.indexOf("```") != -1 && node_id.indexOf("imageChooser") == -1) {
                        mapFreq = Integer.parseInt(node_id.substring(node_id.lastIndexOf(96, node_id.indexOf("```") - 1) + 1, node_id.indexOf("```")));
                        place_data = node_id.substring(node_id.indexOf("```") + 3, node_id.length());
                        node_id = node_id.substring(0, node_id.indexOf(96, node_id.indexOf("```")));
                        try {
                            for (int r = 0; r < mapFreq; ++r) {
                                String title = place_data.substring(0, place_data.indexOf(96));
                                String type = place_data.substring(place_data.indexOf(96) + 1, place_data.indexOf(96, place_data.indexOf(96) + 1));
                                String location = place_data.substring(place_data.indexOf(96, place_data.indexOf(96) + 1) + 1, place_data.indexOf(96, place_data.indexOf(96, place_data.indexOf(96) + 1) + 1));
                                link = place_data.indexOf("```") != -1 ? place_data.substring(0, place_data.indexOf("```")) : place_data;
                                type = this.getType(type);
                                location = this.getLocation(location);
                                if (place_data.indexOf("```") != -1) {
                                    place_data = place_data.substring(place_data.indexOf("```") + 3, place_data.length());
                                }
                                coOrdinates_list.add("`" + link.substring(link.lastIndexOf(96) + 1, link.length()) + "`" + link.substring(link.lastIndexOf(96, link.lastIndexOf(96) - 1) + 2, link.lastIndexOf(96)));
                                place_data_list.add(title + ", " + type + ", " + location + ";");
                            }
                        }
                        catch (StringIndexOutOfBoundsException sioobe) {
                            sioobe.printStackTrace();
                        }
                    }
                    Element new_node = (Element)this.doc.importNode(request_node, false);
                    node_list.appendChild(new_node);
                    Element node_meta_list = this.doc.createElement("metadataList");
                    new_node.appendChild(node_meta_list);
                    for (int m = 0; m < metadata_list.size(); ++m) {
                        String metadata = (String)metadata_list.get(m);
                        thumb = "";
                        String value = "";
                        if (node_id.indexOf(46) != -1) {
                            thumb = node_id.substring(0, node_id.indexOf(46));
                        }
                        if (node_id.indexOf(96) != -1) {
                            value = node_id.substring(node_id.lastIndexOf(96, node_id.lastIndexOf(96) - 1) + 1, node_id.lastIndexOf(96, node_id.lastIndexOf(96) - 1) + 5);
                        }
                        year = value;
                        place_data = "";
                        if (place_data_list.size() != 0) {
                            for (int q = 0; q < mapFreq; ++q) {
                                link = (String)place_data_list.get(q);
                                if (q != 0) {
                                    place_data = place_data + "<br>" + link;
                                } else {
                                    place_data = link;
                                    coOrdinates = "``";
                                }
                                coOrdinates = coOrdinates + (String)coOrdinates_list.get(q);
                            }
                        }
                        link = "<a href=\"?a=d&c=" + this.cluster_name + "&d=" + node_id + coOrdinates + "&dt=map\">";
                        thumb = "<img src=\"" + this.http_image_dir + thumb + "thumb.jpg\" border=0>";
                        value = "<table><tr><td>" + link + "<p>" + place_data + "<br>" + value + "</a></td><td>" + link + thumb + "</a></td></tr></table>";
                        if (metadata.equals("Title")) {
                            if (!place_data.equals("") && place_data.indexOf(", , ;") == -1 && node_id.indexOf("```") == -1) {
                                GSXML.addMetadata(this.doc, node_meta_list, "Title", value);
                            } else {
                                GSXML.addMetadata(this.doc, node_meta_list, metadata, "");
                            }
                        }
                        if (place_data.indexOf(", , ;") != -1) continue;
                        if (i == 0 && mapFreq != 0) {
                            outfile = new BufferedWriter(new FileWriter(this.temp_files_dir + "links" + uid));
                            outfile.write("<table align=\"center\"><tr>");
                        }
                        if (mapFreq != 0) {
                            if (i % 7 == 0) {
                                outfile.write("</tr><tr>");
                            }
                            outfile.write("<td align=\"center\">" + link + thumb + "</a><br>" + link + year + "</a></td>");
                        }
                        if (i != request_nodes.getLength() - 1) continue;
                        outfile.write("</tr></table><p>");
                        outfile.flush();
                        outfile.close();
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return result;
        }
        catch (Exception excep) {
            excep.printStackTrace();
            return null;
        }
    }

    protected Element processDocumentContentRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", DOCUMENT_CONTENT_RETRIEVE_SERVICE);
        result.setAttribute("type", "process");
        String uid = request.getAttribute("uid");
        String temp_image_file = this.temp_files_dir + "temp_" + uid + ".jpg";
        String temp_image_file2 = this.temp_files_dir + "temp_" + uid + "_2.jpg";
        Element query_doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (query_doc_list == null) {
            logger.error((Object)"DocumentContentRetrieve request specified no doc nodes.\n");
            return result;
        }
        String legend_file = this.temp_files_dir + "legend_" + uid + ".jpg";
        String blank_file = this.files_home_dir + "blank.jpg";
        Element doc_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_list);
        String[] doc_ids = GSXML.getAttributeValuesFromList(query_doc_list, "nodeID");
        for (int i = 0; i < doc_ids.length; ++i) {
            Process proc;
            String doc_id = doc_ids[i];
            String img_num = doc_id.substring(0, doc_id.indexOf(46));
            String img_left = "<img border=0 src=\"" + this.http_temp_image_dir;
            String doc_content = "";
            String co_ordinates = "";
            String img_size = "";
            int height = 0;
            int width = 0;
            int leg_num = 0;
            double ratio = 0.0;
            if (doc_id.indexOf("imageChooser") == 0) {
                try {
                    doc_id = doc_id.substring(doc_id.indexOf(96) + 1, doc_id.length());
                    img_num = doc_id.substring(0, doc_id.indexOf(46));
                    String[] get_size = new String[]{"identify", "-size", "10000", temp_image_file};
                    proc = Runtime.getRuntime().exec(get_size);
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    img_size = br.readLine();
                    proc.waitFor();
                    img_size = img_size.substring(img_size.indexOf("JPEG") + 5, img_size.indexOf(" ", img_size.indexOf("JPEG") + 5));
                    width = Integer.parseInt(img_size.substring(0, img_size.indexOf("x")));
                    height = Integer.parseInt(img_size.substring(img_size.indexOf("x") + 1, img_size.length()));
                    ratio = Double.parseDouble(doc_id.substring(doc_id.lastIndexOf(96, doc_id.indexOf("```") - 1) + 1, doc_id.indexOf("```")));
                    width = (int)((double)width * ratio);
                    height = (int)((double)height * ratio);
                    int xclick = Integer.parseInt(doc_id.substring(doc_id.indexOf("```") + 3, doc_id.lastIndexOf(96)));
                    int yclick = Integer.parseInt(doc_id.substring(doc_id.lastIndexOf(96) + 1, doc_id.length()));
                    doc_id = doc_id.substring(doc_id.indexOf(96) + 1, doc_id.indexOf("```"));
                    double xpercent = (double)xclick * 1.0 / (double)width;
                    double ypercent = (double)yclick * 1.0 / (double)height;
                    double ytop = Double.parseDouble(doc_id.substring(0, doc_id.indexOf(96))) * -1.0;
                    doc_id = doc_id.substring(doc_id.indexOf(96) + 1, doc_id.length());
                    double xleft = Double.parseDouble(doc_id.substring(0, doc_id.indexOf(96)));
                    doc_id = doc_id.substring(doc_id.indexOf(96) + 1, doc_id.length());
                    double ybot = Double.parseDouble(doc_id.substring(0, doc_id.indexOf(96))) * -1.0;
                    doc_id = doc_id.substring(doc_id.indexOf(96) + 1, doc_id.length());
                    double xright = Double.parseDouble(doc_id.substring(0, doc_id.indexOf(96)));
                    doc_id = doc_id.substring(doc_id.indexOf(96) + 1, doc_id.length());
                    xpercent = (xright - xleft) * xpercent + xleft;
                    ypercent = (ybot - ytop) * ypercent + ytop;
                    this.namesInList.clear();
                    this.findName(xpercent, ypercent, 0.1, 0.1, this.tree, true);
                    int namesInArraySize = this.namesInList.size();
                    Object[] returnNames = new String[namesInArraySize];
                    int ri = 0;
                    while (this.namesInList.size() > 0) {
                        returnNames[ri] = (String)this.namesInList.getFirst();
                        returnNames[ri] = ((String)returnNames[ri]).substring(0, ((String)returnNames[ri]).indexOf(96));
                        this.namesInList.removeFirst();
                        ++ri;
                    }
                    Arrays.sort(returnNames);
                    doc_content = "\n<script>\nfunction openIt(loc){\n\topener.location=loc;\n\tself.close();\n}\n</script>";
                    for (int nameIndex = 0; nameIndex < namesInArraySize; ++nameIndex) {
                        Object tempName = returnNames[nameIndex];
                        if (((String)returnNames[nameIndex]).indexOf(32) != -1) {
                            returnNames[nameIndex] = ((String)returnNames[nameIndex]).replaceAll(" ", "+");
                            returnNames[nameIndex] = "%22" + (String)returnNames[nameIndex] + "%22";
                        }
                        doc_content = doc_content + "<a href=\"\" onClick=openIt('?a=q&sa=&rt=r&s=MapQuery&c=" + this.cluster_name + "&startPage=1&s1.index=none&s1.maxDocs=10&s1.query=" + (String)returnNames[nameIndex] + "')>" + (String)tempName + "</a><br>";
                    }
                }
                catch (Exception ioexception) {
                    ioexception.printStackTrace();
                }
            } else {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(this.temp_files_dir + "add_x_" + uid));
                    if (doc_id.indexOf("```") != -1) {
                        proc = Runtime.getRuntime().exec("cp " + this.files_home_dir + "maps" + File.separator + img_num + ".jpg " + temp_image_file);
                        proc.waitFor();
                    }
                    String[] get_size = new String[]{"identify", "-size", "10000", temp_image_file};
                    proc = Runtime.getRuntime().exec(get_size);
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    img_size = br.readLine();
                    proc.waitFor();
                    img_size = img_size.substring(img_size.indexOf("JPEG") + 5, img_size.indexOf(" ", img_size.indexOf("JPEG") + 5));
                    if (img_size.indexOf("+") != -1) {
                        img_size = img_size.substring(0, img_size.indexOf("+"));
                    }
                    width = Integer.parseInt(img_size.substring(0, img_size.indexOf("x")));
                    height = Integer.parseInt(img_size.substring(img_size.indexOf("x") + 1, img_size.length()));
                    if (doc_id.indexOf("```") != -1) {
                        co_ordinates = doc_id.substring(doc_id.indexOf("```") + 2, doc_id.length());
                        int x_number = Integer.parseInt(doc_id.substring(doc_id.lastIndexOf(96, doc_id.indexOf("```") - 1) + 1, doc_id.indexOf("```")));
                        bw.write("convert -font helvetica -fill red -pointsize 48 ");
                        for (int xi = 0; xi < x_number; ++xi) {
                            double xco = Double.parseDouble(co_ordinates.substring(co_ordinates.lastIndexOf(96, co_ordinates.lastIndexOf(96) - 1) + 1, co_ordinates.lastIndexOf(96, co_ordinates.lastIndexOf(96) - 1) + 7));
                            double yco = Double.parseDouble(co_ordinates.substring(co_ordinates.lastIndexOf(96) + 1, co_ordinates.length()));
                            if (xi != x_number - 1) {
                                co_ordinates = co_ordinates.substring(0, co_ordinates.lastIndexOf(96, co_ordinates.lastIndexOf(96) - 1));
                            }
                            int index = 0;
                            index = doc_id.indexOf(96) + 2;
                            ratio = 0.4;
                            double tly = Double.parseDouble(doc_id.substring(index, index + 5));
                            index = doc_id.indexOf(96, index) + 1;
                            double tlx = Double.parseDouble(doc_id.substring(index, index + 6));
                            index = doc_id.indexOf(96, index) + 2;
                            double bry = Double.parseDouble(doc_id.substring(index, index + 5));
                            index = doc_id.indexOf(96, index) + 1;
                            double brx = Double.parseDouble(doc_id.substring(index, index + 6));
                            index = doc_id.indexOf(96, index) + 1;
                            double orient = Double.parseDouble(doc_id.substring(index, doc_id.indexOf(96, index)));
                            double xcent = (brx - tlx) / 2.0 + tlx;
                            double ycent = (bry - tly) / 2.0 + tly;
                            orient = Math.toRadians(orient);
                            double oldx = xco -= xcent;
                            xco = xco * Math.cos(orient) - (yco -= ycent) * Math.sin(orient);
                            yco = oldx * Math.sin(orient) + yco * Math.cos(orient);
                            xco += xcent;
                            yco += ycent;
                            xco = (xco - tlx) / (brx - tlx);
                            yco = (yco - tly) / (bry - tly);
                            width = (int)(xco * (double)width) - 5;
                            height = (int)(yco * (double)height) - 5;
                            bw.write("-draw 'text " + width + "," + height + " \"x\"' ");
                            bw.flush();
                            width = Integer.parseInt(img_size.substring(0, img_size.indexOf("x")));
                            height = Integer.parseInt(img_size.substring(img_size.indexOf("x") + 1, img_size.length()));
                        }
                        doc_id = doc_id.substring(0, doc_id.lastIndexOf(96, doc_id.indexOf("```") - 1));
                        bw.write(temp_image_file + " " + temp_image_file + ";convert -scale " + (int)(ratio * (double)width) + "x" + (int)(ratio * (double)height) + " " + temp_image_file + " " + temp_image_file2 + ";cp " + blank_file + " " + legend_file);
                        leg_num = 0;
                    } else if (doc_id.substring(doc_id.lastIndexOf(96), doc_id.length()).indexOf(46) != -1) {
                        ratio = Double.parseDouble(doc_id.substring(doc_id.lastIndexOf(96) + 1, doc_id.length()));
                        bw.write("convert -scale " + (int)(ratio * (double)width) + "x" + (int)(ratio * (double)height) + " " + temp_image_file + " " + temp_image_file2);
                        doc_id = doc_id.substring(0, doc_id.lastIndexOf(96));
                    } else {
                        String restricter = doc_id.substring(doc_id.lastIndexOf(96) + 1, doc_id.length());
                        doc_id = doc_id.substring(0, doc_id.lastIndexOf(96));
                        leg_num = Integer.parseInt(doc_id.substring(doc_id.lastIndexOf(96) + 1, doc_id.length()));
                        doc_id = doc_id.substring(0, doc_id.lastIndexOf(96));
                        BufferedReader inType = new BufferedReader(new FileReader(this.files_home_dir + "place_types" + File.separator + restricter + ".txt"));
                        boolean add_place_type = false;
                        int index = 0;
                        index = doc_id.indexOf(96) + 2;
                        ratio = Double.parseDouble(doc_id.substring(doc_id.lastIndexOf(96) + 1, doc_id.length()));
                        double tly = Double.parseDouble(doc_id.substring(index, index + 5));
                        index = doc_id.indexOf(96, index) + 1;
                        double tlx = Double.parseDouble(doc_id.substring(index, index + 6));
                        index = doc_id.indexOf(96, index) + 2;
                        double bry = Double.parseDouble(doc_id.substring(index, index + 5));
                        index = doc_id.indexOf(96, index) + 1;
                        double brx = Double.parseDouble(doc_id.substring(index, index + 6));
                        index = doc_id.indexOf(96, index) + 1;
                        double orient = Double.parseDouble(doc_id.substring(index, doc_id.indexOf(96, index)));
                        double xcent = (brx - tlx) / 2.0 + tlx;
                        double ycent = (bry - tly) / 2.0 + tly;
                        orient = Math.toRadians(orient);
                        String type_point = "";
                        double xco = 0.0;
                        double yco = 0.0;
                        while (inType.ready()) {
                            type_point = inType.readLine();
                            xco = Double.parseDouble(type_point.substring(type_point.lastIndexOf(96) + 1, type_point.length()));
                            yco = Double.parseDouble(type_point.substring(type_point.lastIndexOf(96, type_point.lastIndexOf(96) - 1) + 2, type_point.lastIndexOf(96)));
                            if (!(xco >= tlx) || !(xco < brx) || !(yco >= tly) || !(yco < bry)) continue;
                            double oldx = xco -= xcent;
                            xco = xco * Math.cos(orient) - (yco -= ycent) * Math.sin(orient);
                            yco = oldx * Math.sin(orient) + yco * Math.cos(orient);
                            xco += xcent;
                            yco += ycent;
                            xco = (xco - tlx) / (brx - tlx);
                            yco = (yco - tly) / (bry - tly);
                            width = (int)(xco * (double)width) - 5;
                            height = (int)(yco * (double)height) - 5;
                            if (!add_place_type) {
                                bw.write("convert -font helvetica -fill red -pointsize 36 ");
                                add_place_type = true;
                            }
                            bw.write("-draw 'text " + width + "," + height + " \"" + leg_num + "\"' ");
                            bw.flush();
                            width = Integer.parseInt(img_size.substring(0, img_size.indexOf("x")));
                            height = Integer.parseInt(img_size.substring(img_size.indexOf("x") + 1, img_size.length()));
                        }
                        if (add_place_type) {
                            bw.write(temp_image_file + " " + temp_image_file + ";convert -scale " + (int)(ratio * (double)width) + "x" + (int)(ratio * (double)height) + " " + temp_image_file + " " + temp_image_file2);
                            BufferedWriter buf = new BufferedWriter(new FileWriter(this.temp_files_dir + "add_l_" + uid));
                            if (leg_num == 1) {
                                buf.write("cp " + blank_file + " " + legend_file + ";");
                            }
                            buf.write("convert -font helvetica -fill red -pointsize 12 -draw 'text 15," + (leg_num * 15 + 20) + " \"" + leg_num + " " + this.getType(restricter) + "\"' " + legend_file + " " + legend_file);
                            buf.flush();
                            buf.close();
                            proc = Runtime.getRuntime().exec("sh " + this.temp_files_dir + "add_l_" + uid);
                            proc.waitFor();
                        }
                        inType.close();
                    }
                    bw.flush();
                    bw.close();
                    proc = Runtime.getRuntime().exec("sh " + this.temp_files_dir + "add_x_" + uid);
                    proc.waitFor();
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
                String doc_content_head = "?a=d&c=" + this.cluster_name + "&dt=map&d=";
                doc_content = "<td valign=\"top\"><script>document.write('" + img_left + "legend_" + uid + ".jpg" + "?'+new Date().getTime())</script>\"></td>";
                doc_content = doc_content + "<td><script>document.write('" + img_left + "temp_" + uid + "_2.jpg?'+new Date().getTime())</script>\" onclick=\"imgClickHandler(event, this, '" + img_num + "')\"></td>";
                doc_content = "<table><tr>" + doc_content + "</tr></table>";
                String javascript = this.getJavascript(ratio, doc_id, leg_num);
                doc_content = "<center>You are currently viewing the map at " + (int)(ratio * 100.0) + "%<br>Select a radio button for a new zoom level.</center>" + javascript + doc_content;
                doc_content = doc_content.replaceAll("zoomhead", doc_content_head);
                doc_content = doc_content.replaceAll("placeChooserImage", doc_content_head + "imageChooser`" + doc_id + "`" + ratio);
                try {
                    BufferedReader infile = new BufferedReader(new FileReader(this.temp_files_dir + "links" + uid));
                    doc_content = doc_content + infile.readLine();
                    infile.close();
                }
                catch (Exception ioexc) {
                    ioexc.printStackTrace();
                }
            }
            Element text_doc = this.doc.createElement("documentNode");
            text_doc.setAttribute("nodeID", doc_id);
            GSXML.addDocText(this.doc, text_doc, doc_content);
            doc_list.appendChild(text_doc);
        }
        return result;
    }

    private String getLocation(String location) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.files_home_dir + "files" + File.separator + "landdist.txt"));
            in.readLine();
            while (in.ready()) {
                String read = in.readLine();
                if (!read.substring(0, 2).equals(location)) continue;
                in.close();
                return read.substring(3, read.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private String getType(String type) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.files_home_dir + "files" + File.separator + "pointdes.txt"));
            in.readLine();
            while (in.ready()) {
                String read = in.readLine();
                if (!read.substring(0, read.indexOf(96)).toLowerCase().equals(type.toLowerCase())) continue;
                in.close();
                return read.substring(read.indexOf(96) + 1, read.indexOf(58));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void findName(double x, double y, double xoff, double yoff, DefaultMutableTreeNode d, boolean xcomp) {
        if (d.isLeaf()) {
            return;
        }
        double xco = Double.parseDouble(((String)d.getUserObject()).substring(((String)d.getUserObject()).length() - 6, ((String)d.getUserObject()).length()));
        double yco = Double.parseDouble(((String)d.getUserObject()).substring(((String)d.getUserObject()).length() - 12, ((String)d.getUserObject()).length() - 7));
        if (x - xoff < xco && x + xoff > xco && y - yoff < yco && y + yoff > yco) {
            this.namesInList.addFirst((String)d.getUserObject());
        }
        if (xcomp) {
            if (x - xoff < xco) {
                this.findName(x, y, xoff, yoff, (DefaultMutableTreeNode)d.getChildAt(0), !xcomp);
            }
            if (x + xoff > xco) {
                this.findName(x, y, xoff, yoff, (DefaultMutableTreeNode)d.getChildAt(1), !xcomp);
            }
        } else {
            if (y - yoff < yco) {
                this.findName(x, y, xoff, yoff, (DefaultMutableTreeNode)d.getChildAt(0), !xcomp);
            }
            if (y + yoff > yco) {
                this.findName(x, y, xoff, yoff, (DefaultMutableTreeNode)d.getChildAt(1), !xcomp);
            }
        }
    }

    private String getJavascript(double ratio, String doc_id, int leg_num) {
        String javascript = "\n<script>\nfunction imgClickHandler (evt, img, num) {\n\tif (window.event){\n\t\tvar chooserString = 'placeChooserImage' + '```' + window.event.offsetX + '`' + window.event.offsetY\n\t\tmywindow = window.open(chooserString,'Choose','width=600, height=500, scrollbars=yes, resizable=yes, toolbar=no, location=no, status=yes, menubar=no');\n\t\t//alert(window.event.offsetX + ':' + window.event.offsetY + ':' + num);\n\t}\n\telse if (evt.target) {\n\t\tvar coords = {x: 0, y: 0 };\n\t\tvar el = evt.target;\n\t\tdo {\n\t\t\tcoords.x += el.offsetLeft;\n\t\t\tcoords.y += el.offsetTop;\n\t\t}\n\t\twhile ((el = el.offsetParent));\n\t\tvar offsetX = evt.clientX - coords.x;\n\t\tvar offsetY = evt.clientY - coords.y;\n\t\talert(offsetX + ':' + offsetY + ':' + num);\n\t}\n}\nfunction leapTo (link)\n{\n\tvar new_url=link;\n\tif (  (new_url != \"\")  &&  (new_url != null)  ) \n\t\twindow.location=new_url;\n\telse \n\t\talert(\"You must make a selection.\");\n}\nfunction jumpTo (front,link,back)\n{\n\tvar new_url=front+link+back;\n\tif (  (new_url != \"\")  &&  (new_url != null)  ) \n\t\twindow.location=new_url;\n\telse \n\t\talert(\"You must make a selection.\");\n}// Deactivate Cloaking -->\n</script>";
        String radioButtons = "\n<center><FORM>";
        if (ratio != 0.4) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`0.4')\">40%";
        }
        if (ratio != 0.5) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`0.5')\">50%";
        }
        if (ratio != 0.6) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`0.6')\">60%";
        }
        if (ratio != 0.7) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`0.7')\">70%";
        }
        if (ratio != 0.8) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`0.8')\">80%";
        }
        if (ratio != 0.9) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`0.9')\">90%";
        }
        if (ratio != 1.0) {
            radioButtons = radioButtons + "\n\t<INPUT TYPE=\"radio\" NAME=\"buttons1\" onClick=\"leapTo('zoomhead" + doc_id + "`1.0')\">100%";
        }
        radioButtons = radioButtons + "\n</FORM></center>";
        String doc_link = "?a=d&c=" + this.cluster_name + "&dt=map&d=" + doc_id + "`" + ratio + "`" + ++leg_num + "`";
        StringBuffer dropDownBox = new StringBuffer();
        dropDownBox.append("Add Locations Of Type: <form name=\"myForm\"><select name=\"s1index\" onChange=\"jumpTo('");
        dropDownBox.append(doc_link);
        dropDownBox.append("',document.myForm.s1index.options[document.myForm.s1index.selectedIndex].value,'')\">\n");
        for (int i = 0; i < this.index_name_list.size(); ++i) {
            String name = (String)this.index_name_list.get(i);
            dropDownBox.append("<option value=\"");
            dropDownBox.append(name);
            dropDownBox.append("\">");
            String display = (String)this.index_display_list.get(i);
            dropDownBox.append(display);
            dropDownBox.append("\n");
        }
        dropDownBox.append("</select></form>\n");
        return javascript + radioButtons + dropDownBox;
    }
}

