/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.mgpp.MGPPDocInfo;
import org.greenstone.mgpp.MGPPQueryResult;
import org.greenstone.mgpp.MGPPRetrieveWrapper;
import org.greenstone.mgpp.MGPPSearchWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PhindPhraseBrowse
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)PhindPhraseBrowse.class.getName());
    private static final String PHIND_SERVICE = "PhindApplet";
    private static MGPPRetrieveWrapper mgpp_retrieve_src = null;
    private static MGPPSearchWrapper mgpp_search_src = null;
    private String basepath = null;
    private Element applet_description = null;

    public PhindPhraseBrowse() {
        if (mgpp_retrieve_src == null) {
            mgpp_retrieve_src = new MGPPRetrieveWrapper();
        }
        if (mgpp_search_src == null) {
            mgpp_search_src = new MGPPSearchWrapper();
        }
        mgpp_search_src.setQueryLevel("Document");
        mgpp_search_src.setReturnLevel("Document");
        mgpp_search_src.setMaxDocs(5);
        mgpp_search_src.setStem(false);
        mgpp_search_src.setCase(true);
    }

    public void cleanUp() {
        super.cleanUp();
        mgpp_search_src.unloadIndexData();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"configuring PhindPhraseBrowse");
        Element e = this.doc.createElement("service");
        e.setAttribute("type", "applet");
        e.setAttribute("name", PHIND_SERVICE);
        this.short_service_info.appendChild(e);
        this.applet_description = this.doc.createElement("service");
        this.applet_description.setAttribute("type", "applet");
        this.applet_description.setAttribute("name", PHIND_SERVICE);
        String app_info = "<applet CODEBASE='applet' CODE='org.greenstone.applet.phind.Phind.class' ARCHIVE='phind.jar, xercesImpl.jar, xml-apis.jar' WIDTH='500' HEIGHT='400'><PARAM NAME='library' VALUE=''/> <PARAM NAME='phindcgi' VALUE='?";
        app_info = app_info + "a=a&amp;rt=r&amp;s=PhindApplet&amp;o=xml&amp;ro=1'/>";
        app_info = app_info + "<PARAM NAME='collection'   VALUE='";
        app_info = app_info + this.cluster_name;
        app_info = app_info + "'/> <PARAM NAME='classifier' VALUE='1'/>  <PARAM NAME='orientation'  VALUE='vertical'/> <PARAM NAME='depth' VALUE='2'/> <PARAM NAME='resultorder' VALUE='L,l,E,e,D,d'/> <PARAM NAME='backdrop' VALUE='interfaces/default/images/phindbg1.jpg'/><PARAM NAME='fontsize' VALUE='10'/> <PARAM NAME='blocksize'    VALUE='10'/>The Phind java applet.</applet>";
        Document dom = this.converter.getDOM(app_info);
        if (dom == null) {
            logger.error((Object)"Couldn't parse applet info");
            return false;
        }
        Element app_elem = dom.getDocumentElement();
        this.applet_description.appendChild(this.doc.importNode(app_elem, true));
        return true;
    }

    protected Element getServiceDescription(String service, String lang, String subset) {
        if (!service.equals(PHIND_SERVICE)) {
            return null;
        }
        Element describe = (Element)this.applet_description.cloneNode(true);
        describe.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getTextString("PhindApplet.name", lang)));
        describe.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getTextString("PhindApplet.description", lang)));
        return describe;
    }

    protected Element processPhindApplet(Element request) {
        Element param_elem = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(param_elem, false);
        long first_e = Long.parseLong((String)params.get("pfe"));
        long last_e = Long.parseLong((String)params.get("ple"));
        long first_l = Long.parseLong((String)params.get("pfl"));
        long last_l = Long.parseLong((String)params.get("pll"));
        long first_d = Long.parseLong((String)params.get("pfd"));
        long last_d = Long.parseLong((String)params.get("pld"));
        String phrase_str = (String)params.get("ppnum");
        long phrase = phrase_str == null || phrase_str.equals("") ? 0L : Long.parseLong(phrase_str);
        String word = (String)params.get("pptext");
        String phind_index = (String)params.get("pc");
        this.basepath = GSFile.phindBaseDir(this.site_home, this.cluster_name, phind_index);
        Element result = this.doc.createElement("response");
        result.setAttribute("from", PHIND_SERVICE);
        result.setAttribute("type", "process");
        Element applet_data = this.doc.createElement("appletData");
        result.appendChild(applet_data);
        Element phind_data = this.doc.createElement("phindData");
        applet_data.appendChild(phind_data);
        if (phrase == 0L) {
            if (word == null || word.equals("")) {
                Element error = this.phindError("no word or phrase");
                phind_data.appendChild(error);
                return result;
            }
            phrase = this.findPhraseNumberFromWord(word);
        }
        if (phrase == 0L) {
            Element error = this.phindError("the term " + word + " is not in the collection");
            phind_data.appendChild(error);
            return result;
        }
        this.getPhraseData(phind_data, phrase, first_l, last_l, first_e, last_e, first_d, last_d);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long findPhraseNumberFromWord(String word) {
        MGPPSearchWrapper mGPPSearchWrapper = mgpp_search_src;
        synchronized (mGPPSearchWrapper) {
            mgpp_search_src.loadIndexData(this.basepath + File.separatorChar + "pword");
            mgpp_search_src.runQuery(word);
            MGPPQueryResult res = mgpp_search_src.getQueryResult();
            Vector docs = res.getDocs();
            if (docs.size() == 0) {
                return 0L;
            }
            MGPPDocInfo doc = (MGPPDocInfo)docs.firstElement();
            return doc.num_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPhraseData(Element phind_data, long phrase, long first_l, long last_l, long first_e, long last_e, long first_d, long last_d) {
        MGPPRetrieveWrapper mGPPRetrieveWrapper = mgpp_retrieve_src;
        synchronized (mGPPRetrieveWrapper) {
            String record = mgpp_retrieve_src.getDocument(this.basepath + File.separatorChar + "pdata", "Document", phrase);
            if (record.equals("")) {
                Element error = this.phindError("somethings gone wrong - we haven't got a record for phrase number " + phrase);
                phind_data.appendChild(error);
                return false;
            }
            record = record.substring(record.indexOf(58) + 1);
            String[] fields = record.split(":");
            String word = fields[0];
            String tf = fields[1];
            String ef = fields[2];
            String df = fields[3];
            String expansions = fields[4];
            String documents = fields[5];
            String lf = "0";
            String linklist = "";
            if (fields.length > 7) {
                lf = fields[6];
                linklist = fields[7];
            }
            phind_data.setAttribute("id", Long.toString(phrase));
            phind_data.setAttribute("df", df);
            phind_data.setAttribute("ef", ef);
            phind_data.setAttribute("lf", lf);
            phind_data.setAttribute("tf", tf);
            GSXML.createTextElement(this.doc, "phrase", word);
            this.addExpansionList(phind_data, expansions, word, ef, first_e, last_e);
            this.addDocumentList(phind_data, documents, word, df, first_d, last_d);
            if (!lf.equals("0")) {
                this.addThesaurusList(phind_data, linklist, word, lf, first_l, last_l);
            }
            return true;
        }
    }

    protected boolean addExpansionList(Element phind_data, String record, String word, String freq, long first, long last) {
        Element expansion_list = this.doc.createElement("expansionList");
        phind_data.appendChild(expansion_list);
        expansion_list.setAttribute("length", freq);
        expansion_list.setAttribute("start", Long.toString(first));
        expansion_list.setAttribute("end", Long.toString(last));
        String[] expansions = record.split(",");
        int length = expansions.length;
        if ((long)length < last) {
            last = length;
        }
        for (long i = first; i < last; ++i) {
            long num = Long.parseLong(expansions[(int)i]);
            Element expansion = this.getExpansion(num, word);
            expansion.setAttribute("num", Long.toString(i));
            expansion_list.appendChild(expansion);
        }
        return true;
    }

    protected Element getExpansion(long phrase_num, String orig_phrase) {
        String record = mgpp_retrieve_src.getDocument(this.basepath + File.separatorChar + "pdata", "Document", phrase_num);
        if (record == null || record.equals("")) {
            return null;
        }
        record = record.substring(record.indexOf(58) + 1);
        String[] fields = record.split(":");
        String phrase = fields[0];
        String tf = fields[1];
        String df = fields[3];
        Element expansion = this.doc.createElement("expansion");
        expansion.setAttribute("tf", tf);
        expansion.setAttribute("df", df);
        expansion.setAttribute("id", Long.toString(phrase_num));
        String[] ends = this.splitPhraseOnWord(phrase, orig_phrase);
        if (!ends[0].equals("")) {
            expansion.appendChild(GSXML.createTextElement(this.doc, "prefix", ends[0]));
        }
        if (!ends[1].equals("")) {
            expansion.appendChild(GSXML.createTextElement(this.doc, "suffix", ends[1]));
        }
        return expansion;
    }

    protected boolean addDocumentList(Element phind_data, String record, String word, String freq, long first, long last) {
        Element document_list = this.doc.createElement("documentList");
        phind_data.appendChild(document_list);
        document_list.setAttribute("length", freq);
        document_list.setAttribute("start", Long.toString(first));
        document_list.setAttribute("end", Long.toString(last));
        String[] doc_freqs = record.split(";");
        int length = doc_freqs.length;
        if ((long)length < last) {
            last = length;
        }
        for (long i = first; i < last; ++i) {
            String doc_freq;
            long doc_num;
            String doc_elem = doc_freqs[(int)i];
            int p = doc_elem.indexOf(44);
            if (p == -1) {
                doc_num = Long.parseLong(doc_elem);
                doc_freq = "1";
            } else {
                doc_num = Long.parseLong(doc_elem.substring(0, p));
                doc_freq = doc_elem.substring(p + 1);
            }
            Element document = this.getDocument(doc_num);
            document.setAttribute("freq", doc_freq);
            document.setAttribute("num", Long.toString(i));
            document_list.appendChild(document);
        }
        return true;
    }

    protected Element getDocument(long doc_num) {
        String record = mgpp_retrieve_src.getDocument(this.basepath + File.separatorChar + "docs", "Document", doc_num);
        if (record == null || record.equals("")) {
            return null;
        }
        record = record.substring(record.indexOf(9) + 1);
        String[] fields = record.split("\t");
        String hash = fields[0];
        String title = fields[1];
        Element d = this.doc.createElement("document");
        d.setAttribute("hash", hash);
        d.appendChild(GSXML.createTextElement(this.doc, "title", title));
        return d;
    }

    protected boolean addThesaurusList(Element phind_data, String record, String word, String freq, long first, long last) {
        Element thesaurus_list = this.doc.createElement("thesaurusList");
        phind_data.appendChild(thesaurus_list);
        thesaurus_list.setAttribute("length", freq);
        thesaurus_list.setAttribute("start", Long.toString(first));
        thesaurus_list.setAttribute("end", Long.toString(last));
        String[] links = record.split(";");
        int length = links.length;
        long index = 0L;
        for (int i = 0; i < length; ++i) {
            String link_info = links[i];
            String[] items = link_info.split(",");
            String type = items[0];
            int j = 1;
            while (j < items.length) {
                if (index >= first && index < last) {
                    long phrase = Long.parseLong(items[j]);
                    Element t = this.getThesaurus(phrase);
                    t.setAttribute("type", type);
                    thesaurus_list.appendChild(t);
                }
                ++j;
                ++index;
            }
        }
        return true;
    }

    protected Element getThesaurus(long phrase_num) {
        String record = mgpp_retrieve_src.getDocument(this.basepath + File.separatorChar + "pdata", "Document", phrase_num);
        if (record == null || record.equals("")) {
            return null;
        }
        record = record.substring(record.indexOf(58) + 1);
        String[] fields = record.split(":");
        String phrase = fields[0];
        String tf = fields[1];
        String df = fields[3];
        Element thesaurus = this.doc.createElement("thesaurus");
        thesaurus.setAttribute("tf", tf);
        thesaurus.setAttribute("df", df);
        thesaurus.setAttribute("id", Long.toString(phrase_num));
        thesaurus.appendChild(GSXML.createTextElement(this.doc, "phrase", phrase));
        return thesaurus;
    }

    protected String[] splitPhraseOnWord(String phrase, String word) {
        if (word.equals("")) {
            String[] res = new String[]{phrase, ""};
            return res;
        }
        String[] result = phrase.split(word, 2);
        return result;
    }

    protected Element phindError(String message) {
        Element e = this.doc.createElement("phindError");
        Text t = this.doc.createTextNode(message);
        e.appendChild(t);
        return e;
    }
}

