/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.sql.derby;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.sql.MetadataDBWrapper;
import org.greenstone.gsdl3.sql.SQLServer;
import org.greenstone.gsdl3.sql.SQLStatements;
import org.greenstone.gsdl3.util.DBInfo;

public class DerbyDBWrapper
implements MetadataDBWrapper {
    protected SQLServer sqlServer = null;
    protected SQLStatements sqlState = null;
    protected Connection connection = null;
    protected Statement statement = null;
    protected static Logger logger = Logger.getLogger((String)DerbyDBWrapper.class.getName());

    public DBInfo getInfo(String id) {
        if (this.sqlState == null) {
            return null;
        }
        String dbInfoState = this.sqlState.getDBInfoStatement(id);
        ArrayList result = this.executeQuery(dbInfoState);
        if (result.size() == 0) {
            return null;
        }
        DBInfo info = new DBInfo();
        for (int i = 0; i < result.size(); ++i) {
            HashMap arow = (HashMap)result.get(i);
            for (String key : arow.keySet()) {
                Object value = arow.get(key);
                if (value == null || value.equals("")) continue;
                info.addInfo(key.toLowerCase(), this.sqlState.undoDBSafe(value));
            }
        }
        return info;
    }

    public void setSQLServer(SQLServer server) {
        this.sqlServer = server;
    }

    public void setSQLStatements(SQLStatements state) {
        this.sqlState = state;
    }

    public boolean openConnection(String databasepath) {
        this.connection = this.sqlServer.connect(databasepath);
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.setAutoCommit(false);
            this.statement = this.connection.createStatement();
        }
        catch (SQLException sqle) {
            logger.debug((Object)"Database Error occured when creating a statement object", (Throwable)sqle);
            return false;
        }
        return true;
    }

    public boolean openAndCreateConnection(String databasepath) {
        this.connection = this.sqlServer.connectAndCreate(databasepath);
        if (this.connection == null) {
            logger.error((Object)("sql connection is null. database path=" + databasepath));
            return false;
        }
        try {
            this.connection.setAutoCommit(true);
            this.statement = this.connection.createStatement(1004, 1008);
            if (this.statement == null) {
                logger.error((Object)"statement is null");
                return false;
            }
        }
        catch (SQLException sqle) {
            logger.debug((Object)"Database Error occured when creating a statement object", (Throwable)sqle);
            return false;
        }
        return true;
    }

    public synchronized ArrayList executeQuery(String query_statement) {
        ArrayList results = new ArrayList();
        try {
            if (this.statement == null) {
                logger.info((Object)"the database hasn't been correct yet");
                return new ArrayList();
            }
            ResultSet rs = this.statement.executeQuery(query_statement);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> arow = new HashMap<String, Object>();
                for (int i = 1; i <= numOfColumns; ++i) {
                    arow.put(rsmd.getColumnName(i).toLowerCase(), rs.getObject(i));
                }
                results.add(arow);
            }
        }
        catch (SQLException sqle) {
            logger.debug((Object)("Database Error occured when executeQuery " + query_statement), (Throwable)sqle);
            return results;
        }
        catch (Exception e) {
            logger.debug((Object)e);
            return null;
        }
        return results;
    }

    public synchronized ResultSet queryResultSet(String stat) {
        ResultSet rs = null;
        try {
            if (this.statement == null) {
                logger.info((Object)"Null sql statement provided.");
                return null;
            }
            logger.debug((Object)stat);
            rs = this.statement.executeQuery(stat);
            logger.info((Object)("sql stat=" + stat + " result=" + rs));
        }
        catch (SQLException sqle) {
            logger.info((Object)("Database Error occured when execute query " + stat), (Throwable)sqle);
            return null;
        }
        catch (Exception e) {
            logger.info((Object)("Exception=" + e));
            return null;
        }
        logger.debug((Object)(" result=" + rs));
        return rs;
    }

    public synchronized boolean execute(String stat) {
        boolean rs;
        try {
            if (this.statement == null) {
                logger.info((Object)"statement is null.");
                return false;
            }
            rs = this.statement.execute(stat);
        }
        catch (SQLException sqle) {
            logger.debug((Object)("Database Error occured when execute query " + stat), (Throwable)sqle);
            return false;
        }
        catch (Exception e) {
            logger.debug((Object)e);
            return false;
        }
        return rs;
    }

    public synchronized boolean executeUpdate(String stat) {
        int rs;
        try {
            if (this.statement == null) {
                logger.info((Object)"statement is null.");
                return false;
            }
            rs = this.statement.executeUpdate(stat);
            logger.info((Object)("sql stat=" + stat + " result=" + rs));
        }
        catch (SQLException sqle) {
            logger.info((Object)("Database Error occured when execute query " + stat), (Throwable)sqle);
            return false;
        }
        catch (Exception e) {
            logger.info((Object)("Exception=" + e));
            return false;
        }
        logger.info((Object)(" result=" + rs));
        return rs != -1;
    }

    public void check4Table(String stat) throws SQLException {
        this.statement.executeQuery(stat);
    }

    public void closeConnection(String databasepath) {
        this.sqlServer.disconnect(databasepath);
    }
}

