/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.TableModelAdapter;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.TableModelFilterEvent;
import de.qfs.lib.gui.TableModelFilterListener;
import de.qfs.lib.gui.TableModelSorter;
import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import de.qfs.lib.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class FilteredAndSortedTableModel
extends TableModelAdapter
implements TableModelSorterListener,
TableModelFilterListener {
    private static Logger logger = new Logger(class$de$qfs$lib$gui$FilteredAndSortedTableModel == null ? (class$de$qfs$lib$gui$FilteredAndSortedTableModel = FilteredAndSortedTableModel.class$("de.qfs.lib.gui.FilteredAndSortedTableModel")) : class$de$qfs$lib$gui$FilteredAndSortedTableModel);
    protected TableModelFilter filter;
    protected TableModelSorter sorter;
    protected SorterCompare sorterCompare = new SorterCompare();
    public List indexMap;
    protected boolean mustSort;
    public int[] reverseMap;
    public int reverseExtra;
    private List addedRows = new ArrayList();
    private ListSelectionModel savedSelectionModel;
    private List savedRows = new ArrayList();
    private int savedLead = -1;
    private int savedAnchor = -1;
    private boolean selectionSaved;
    private double criticalSizeFactor = 0.3;
    static /* synthetic */ Class class$de$qfs$lib$gui$FilteredAndSortedTableModel;

    public FilteredAndSortedTableModel(TableModel tableModel) {
        super(tableModel);
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "FilteredAndSortedTableModel(TableModel)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "model: " + tableModel);
        }
    }

    public FilteredAndSortedTableModel(TableModel tableModel, TableModelFilter tableModelFilter, TableModelSorter tableModelSorter) {
        super(tableModel);
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "FilteredAndSortedTableModel(TableModel,TableModelFilter,TableModelSorter)", "model: " + tableModel + ", " + "filter: " + tableModelFilter + ", " + "sorter: " + tableModelSorter);
        }
        this.filter = tableModelFilter;
        if (tableModelFilter != null) {
            tableModelFilter.addTableModelFilterListener(this);
        }
        this.sorter = tableModelSorter;
        if (tableModelSorter != null) {
            tableModelSorter.addTableModelSorterListener(this);
        }
        this.mustSort = true;
    }

    public final TableModelFilter getFilter() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "getFilter()", "");
        }
        return this.filter;
    }

    public void setFilter(TableModelFilter tableModelFilter) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "setFilter(TableModelFilter)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "filter: " + tableModelFilter);
        }
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
        }
        this.saveSelection();
        this.filter = tableModelFilter;
        if (tableModelFilter != null) {
            tableModelFilter.addTableModelFilterListener(this);
        }
        this.indexMap = null;
        this.mustSort = this.sorter != null;
        this.invalidateMap();
    }

    public void sortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "sortOrderChanged(TableModelSorterEvent)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "e: " + tableModelSorterEvent);
        }
        this.saveSelection();
        this.mustSort = true;
        this.invalidateMap();
    }

    public final TableModelSorter getSorter() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "getSorter()", "");
        }
        return this.sorter;
    }

    public void setSorter(TableModelSorter tableModelSorter) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "setSorter(TableModelSorter)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "sorter: " + tableModelSorter);
        }
        this.saveSelection();
        if (this.sorter != null) {
            this.sorter.removeTableModelSorterListener(this);
            if (tableModelSorter == null) {
                this.indexMap = null;
            }
        }
        this.sorter = tableModelSorter;
        if (tableModelSorter != null) {
            tableModelSorter.addTableModelSorterListener(this);
            this.mustSort = true;
        } else {
            this.mustSort = false;
        }
        this.invalidateMap();
    }

    public void filterChanged(TableModelFilterEvent tableModelFilterEvent) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "filterChanged(TableModelFilterEvent)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "event: " + tableModelFilterEvent);
        }
        if (this.filter == tableModelFilterEvent.getSource()) {
            this.saveSelection();
            this.indexMap = null;
            this.mustSort = this.sorter != null;
            this.invalidateMap();
        }
    }

    public Object getValueAt(int n, int n2) {
        this.validateMap();
        if (n >= this.indexMap.size()) {
            logger.log(1, "getValueAt(int,int)", "Illegal row: " + n + ", current size: " + this.indexMap.size());
            logger.dumpStack(1, "getValueAt(int,int)", "StackTrace");
            return null;
        }
        return this.model.getValueAt((Integer)this.indexMap.get(n), n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.validateMap();
        if (n >= this.indexMap.size()) {
            logger.log(1, "setValueAt(Object,int,int)", "Illegal row: " + n + ", current size: " + this.indexMap.size());
            logger.dumpStack(1, "setValueAt(Object,int,int)", "StackTrace");
            return;
        }
        this.model.setValueAt(object, (Integer)this.indexMap.get(n), n2);
    }

    public int getRowCount() {
        if (this.filter == null) {
            return this.model.getRowCount();
        }
        this.validateMap();
        return this.indexMap.size();
    }

    public boolean isCellEditable(int n, int n2) {
        this.validateMap();
        if (n >= this.indexMap.size()) {
            return false;
        }
        return this.model.isCellEditable((Integer)this.indexMap.get(n), n2);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "tableChanged(TableModelEvent)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "e: " + tableModelEvent + ", start: " + n + ", end: " + n2);
        }
        if (n == -1) {
            this.indexMap = null;
            this.addedRows.clear();
            this.reverseMap = null;
            this.mustSort = this.sorter != null;
            this.selectionSaved = false;
            super.tableChanged(new TableModelEvent(this, -1));
            return;
        }
        if (n == 0 && n2 >= this.model.getRowCount() && tableModelEvent.getType() == 0) {
            this.indexMap = null;
            this.addedRows.clear();
            this.reverseMap = null;
            this.mustSort = this.sorter != null;
            this.selectionSaved = false;
            this.invalidateMap();
            return;
        }
        this.saveSelection();
        switch (tableModelEvent.getType()) {
            case 0: {
                this.rowsUpdated(n, n2, tableModelEvent);
                break;
            }
            case 1: {
                this.rowsAdded(n, n2, tableModelEvent);
                break;
            }
            case -1: {
                this.rowsRemoved(n, n2, tableModelEvent);
            }
        }
        this.reverseMap = null;
        if (FilteredAndSortedTableModel.logger.level >= 9) {
            logger.log(9, "tableChanged(TableModelEvent)", "savedSelectionModel: " + this.savedSelectionModel + ", selectionSaved: " + this.selectionSaved);
        }
        if (this.savedSelectionModel != null && this.selectionSaved) {
            this.validateMap();
            this.restoreSavedSelection();
        }
    }

    private void fireAdded(int n, int n2) {
        int n3;
        int n4 = n2 - n + 1;
        boolean bl = false;
        ListIterator<Integer> listIterator = this.addedRows.listIterator();
        while (listIterator.hasNext()) {
            n3 = (Integer)listIterator.next();
            if (n3 < n) continue;
            listIterator.previous();
            int n5 = n;
            while (n5 <= n2) {
                listIterator.add(new Integer(n5));
                ++n5;
            }
            while (listIterator.hasNext()) {
                n3 = (Integer)listIterator.next();
                listIterator.set(new Integer(n3 + n4));
            }
            bl = true;
            break;
        }
        if (!bl) {
            n3 = n;
            while (n3 <= n2) {
                this.addedRows.add(new Integer(n3));
                ++n3;
            }
        }
        super.tableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    private void fireRemoved(int n, int n2) {
        int n3 = n2 - n + 1;
        ListIterator<Integer> listIterator = this.addedRows.listIterator();
        while (listIterator.hasNext()) {
            int n4 = (Integer)listIterator.next();
            if (n4 < n) continue;
            if (n4 <= n2) {
                listIterator.remove();
                continue;
            }
            listIterator.set(new Integer(n4 - n3));
            while (listIterator.hasNext()) {
                n4 = (Integer)listIterator.next();
                listIterator.set(new Integer(n4 - n3));
            }
            break block0;
        }
        super.tableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public int getMappedRow(int n) {
        this.validateMap();
        if (n >= 0 && n < this.indexMap.size()) {
            return (Integer)this.indexMap.get(n);
        }
        return -1;
    }

    public int[] getAddedRows() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "getAddedRows()", "");
        }
        int[] nArray = new int[this.addedRows.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)this.addedRows.get(n);
            ++n;
        }
        return nArray;
    }

    public void clearAddedRows() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "clearAddedRows()", "");
        }
        this.addedRows.clear();
    }

    public void setSavedSelectionModel(ListSelectionModel listSelectionModel) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "setSavedSelectionModel(ListSelectionModel)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "model: " + listSelectionModel);
        }
        this.savedSelectionModel = listSelectionModel;
    }

    private void saveSelection() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "saveSelection()", "this: " + this);
        }
        if (this.selectionSaved) {
            return;
        }
        if (this.savedSelectionModel != null) {
            if (this.indexMap == null || this.mustSort) {
                this.savedLead = -1;
                this.savedAnchor = -1;
                this.savedRows.clear();
            } else {
                this.savedLead = this.savedSelectionModel.getLeadSelectionIndex();
                this.savedAnchor = this.savedSelectionModel.getAnchorSelectionIndex();
                this.savedRows.clear();
                int n = this.savedSelectionModel.getMinSelectionIndex();
                int n2 = this.savedSelectionModel.getMaxSelectionIndex();
                if (n >= 0) {
                    int n3 = n;
                    while (n3 <= n2) {
                        if (n3 != this.savedLead && this.savedSelectionModel.isSelectedIndex(n3) && n3 < this.indexMap.size()) {
                            this.savedRows.add(this.indexMap.get(n3));
                            if (FilteredAndSortedTableModel.logger.level >= 9) {
                                logger.log(9, "saveSelection()", "selected row " + n3 + " maps to " + this.indexMap.get(n3));
                            }
                        }
                        ++n3;
                    }
                }
                this.savedLead = this.savedLead >= 0 && this.savedSelectionModel.isSelectedIndex(this.savedLead) && this.savedLead < this.indexMap.size() ? (Integer)this.indexMap.get(this.savedLead) : -1;
                this.savedAnchor = this.savedAnchor >= 0 && this.savedAnchor < this.indexMap.size() ? (Integer)this.indexMap.get(this.savedAnchor) : -1;
                if (FilteredAndSortedTableModel.logger.level >= 9) {
                    logger.log(9, "saveSelection()", "savedLead: " + this.savedLead + ", savedAnchor: " + this.savedAnchor);
                }
            }
            this.selectionSaved = true;
        }
    }

    private void restoreSavedSelection() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "restoreSavedSelection()", "");
        }
        if (this.savedSelectionModel != null && this.selectionSaved) {
            this.buildReverseMap(0);
            this.savedSelectionModel.clearSelection();
            this.savedSelectionModel.setValueIsAdjusting(true);
            ListIterator listIterator = this.savedRows.listIterator();
            while (listIterator.hasNext()) {
                int n = (Integer)listIterator.next();
                if (this.reverseMap[n] >= 0) {
                    this.savedSelectionModel.addSelectionInterval(this.reverseMap[n], this.reverseMap[n]);
                    if (FilteredAndSortedTableModel.logger.level < 9) continue;
                    logger.log(9, "restoreSavedSelection()", "saved index " + n + " maps to " + this.reverseMap[n]);
                    continue;
                }
                if (FilteredAndSortedTableModel.logger.level < 9) continue;
                logger.log(9, "restoreSavedSelection()", "saved index " + n + " is unmapped");
            }
            if (this.savedLead >= 0 && this.reverseMap[this.savedLead] >= 0) {
                this.savedSelectionModel.addSelectionInterval(this.reverseMap[this.savedLead], this.reverseMap[this.savedLead]);
                if (FilteredAndSortedTableModel.logger.level >= 9) {
                    logger.log(9, "restoreSavedSelection()", "savedLead maps to " + this.reverseMap[this.savedLead]);
                }
            }
            this.savedSelectionModel.setValueIsAdjusting(false);
            if (this.savedAnchor >= 0 && this.reverseMap[this.savedAnchor] >= 0) {
                this.savedSelectionModel.setAnchorSelectionIndex(this.reverseMap[this.savedAnchor]);
                if (FilteredAndSortedTableModel.logger.level >= 9) {
                    logger.log(9, "restoreSavedSelection()", "savedAnchor maps to " + this.reverseMap[this.savedAnchor]);
                }
            }
            this.savedRows.clear();
            this.selectionSaved = false;
        }
    }

    private void buildMap() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "buildMap()", "");
        }
        int n = this.model.getRowCount();
        this.indexMap = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            if (this.filter == null || this.filter.filter(this.model, n2)) {
                this.indexMap.add(new Integer(n2));
            }
            ++n2;
        }
    }

    private void validateMap() {
        if (this.indexMap == null) {
            this.buildMap();
            this.reverseMap = null;
        }
        if (this.sorter != null && this.mustSort) {
            if (FilteredAndSortedTableModel.logger.level >= 9) {
                logger.log(9, "validateMap()", "Sorting");
            }
            Collections.sort(this.indexMap, this.sorterCompare);
            this.mustSort = false;
            this.reverseMap = null;
        }
    }

    private void invalidateMap() {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "invalidateMap()", "");
        }
        this.reverseMap = null;
        this.addedRows.clear();
        super.tableChanged(new TableModelEvent(this));
        if (this.savedSelectionModel != null && this.selectionSaved) {
            this.validateMap();
            this.restoreSavedSelection();
        }
    }

    private void rowsAdded(int n, int n2, TableModelEvent tableModelEvent) {
        Object object;
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "rowsAdded(int,int,TableModelEvent)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "start: " + n + ", " + "end: " + n2 + ", " + "e: " + tableModelEvent);
        }
        int n3 = n2 - n + 1;
        if (this.savedSelectionModel != null) {
            object = this.savedRows.listIterator();
            while (object.hasNext()) {
                int n4 = (Integer)object.next();
                if (n4 < n) continue;
                object.set(new Integer(n4 + n3));
            }
            if (this.savedLead >= n) {
                this.savedLead += n3;
            }
            if (this.savedAnchor >= n) {
                this.savedAnchor += n3;
            }
        }
        if (this.indexMap == null || this.mustSort) {
            this.indexMap = null;
            this.mustSort = this.sorter != null;
            this.invalidateMap();
            return;
        }
        this.moveIndices(n, n3);
        object = this.getFilteredAndSortedPart(n, n2);
        if (FilteredAndSortedTableModel.logger.level >= 9) {
            logger.log(9, "rowsAdded(int,int,TableModelEvent)", "Rows added: " + n + "-" + n2);
        }
        this.insertRows((List)object);
    }

    private void rowsRemoved(int n, int n2, TableModelEvent tableModelEvent) {
        Object object;
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "rowsRemoved(int,int,TableModelEvent)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "start: " + n + ", " + "end: " + n2 + ", " + "e: " + tableModelEvent);
        }
        int n3 = n2 - n + 1;
        if (this.savedSelectionModel != null) {
            object = this.savedRows.listIterator();
            while (object.hasNext()) {
                int n4 = (Integer)object.next();
                if (n4 < n) continue;
                if (n4 <= n2) {
                    object.remove();
                    continue;
                }
                object.set(new Integer(n4 - n3));
            }
            if (this.savedLead >= n) {
                this.savedLead = this.savedLead <= n2 ? -1 : (this.savedLead -= n3);
            }
            if (this.savedAnchor >= n) {
                this.savedAnchor = this.savedLead <= n2 ? -1 : (this.savedAnchor -= n3);
            }
        }
        if (this.indexMap == null || this.mustSort || (double)n3 > (double)this.model.getRowCount() * this.criticalSizeFactor) {
            this.indexMap = null;
            this.mustSort = this.sorter != null;
            this.invalidateMap();
            return;
        }
        this.buildReverseMap(n2 - n + 1);
        object = this.findFilteredAndSortedPart(n, n2);
        if (FilteredAndSortedTableModel.logger.level >= 9) {
            logger.log(9, "rowsRemoved(int,int,TableModelEvent)", "Rows removed: " + n + "-" + n2);
        }
        this.deleteRows((List)object);
        this.moveIndices(n2 + 1, -n3);
    }

    private void rowsUpdated(int n, int n2, TableModelEvent tableModelEvent) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "rowsUpdated(int,int,TableModelEvent)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "start: " + n + ", " + "end: " + n2 + ", " + "e: " + tableModelEvent);
        }
        if (this.indexMap == null || this.mustSort || (double)(n2 - n) >= (double)this.model.getRowCount() * this.criticalSizeFactor) {
            this.indexMap = null;
            this.mustSort = this.sorter != null;
            this.invalidateMap();
            return;
        }
        this.buildReverseMap(0);
        List list = this.findFilteredAndSortedPart(n, n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n3 = n;
        while (n3 <= n2) {
            boolean bl = this.filter != null && !this.filter.filter(this.model, n3);
            Integer n4 = (Integer)list.get(n3 - n);
            if (n4 == -1) {
                if (!bl) {
                    arrayList.add(new Integer(n3));
                }
            } else if (bl) {
                arrayList2.add(n4);
            } else if (this.sorter != null) {
                arrayList2.add(n4);
                arrayList.add(new Integer(n3));
            }
            ++n3;
        }
        Collections.sort(arrayList2, new IntegerCompare());
        this.deleteRows(arrayList2);
        Collections.sort(arrayList, new IntegerCompare());
        this.insertRows(arrayList);
    }

    private int addRow(Integer n) {
        int n2 = this.sorter == null ? Collections.binarySearch(this.indexMap, n, new IntegerCompare()) : Collections.binarySearch(this.indexMap, n, this.sorterCompare);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        this.indexMap.add(n2, n);
        return n2;
    }

    private void insertRows(List list) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "insertRows(List)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "added: " + list.size() + " rows");
        }
        int n = -2;
        int n2 = -2;
        int n3 = 0;
        while (n3 < list.size()) {
            Integer n4 = (Integer)list.get(n3);
            int n5 = this.addRow(n4);
            if (n5 != n2 + 1) {
                if (n >= 0) {
                    this.fireAdded(n, n2);
                    if (FilteredAndSortedTableModel.logger.level >= 9) {
                        logger.log(9, "insertRows(List)", "changed: " + n + "-" + n2);
                    }
                }
                n = n5;
                n2 = n5;
            } else {
                ++n2;
            }
            ++n3;
        }
        if (n >= 0) {
            this.fireAdded(n, n2);
            if (FilteredAndSortedTableModel.logger.level >= 9) {
                logger.log(9, "insertRows(List)", "changed: " + n + "-" + n2);
            }
        }
    }

    private void deleteRows(List list) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "deleteRows(List)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "removed: " + list);
        }
        int n = -2;
        int n2 = -2;
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            int n4 = (Integer)list.get(n3);
            if (n4 >= 0) {
                this.indexMap.remove(n4);
                if (n4 != n - 1) {
                    if (n >= 0) {
                        this.fireRemoved(n, n2);
                        if (FilteredAndSortedTableModel.logger.level >= 9) {
                            logger.log(9, "deleteRows(List)", "changed: " + n + "-" + n2);
                        }
                    }
                    n = n4;
                    n2 = n4;
                } else {
                    --n;
                }
            }
            --n3;
        }
        if (n >= 0) {
            this.fireRemoved(n, n2);
            if (FilteredAndSortedTableModel.logger.level >= 9) {
                logger.log(9, "deleteRows(List)", "changed: " + n + "-" + n2);
            }
        }
    }

    private void moveIndices(int n, int n2) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "moveIndices(int,int)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "start: " + n + ", " + "num: " + n2);
        }
        if (this.indexMap != null) {
            ListIterator<Integer> listIterator = this.indexMap.listIterator();
            while (listIterator.hasNext()) {
                int n3 = (Integer)listIterator.next();
                if (n3 < n) continue;
                listIterator.set(new Integer(n3 + n2));
            }
        }
    }

    private List getFilteredAndSortedPart(int n, int n2) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "getFilteredAndSortedPart(int,int)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "start: " + n + ", " + "end: " + n2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = n;
        while (n3 <= n2) {
            if (this.filter == null || this.filter.filter(this.model, n3)) {
                arrayList.add(new Integer(n3));
            }
            ++n3;
        }
        if (this.sorter != null) {
            Collections.sort(arrayList, this.sorterCompare);
        }
        return arrayList;
    }

    private List findFilteredAndSortedPart(int n, int n2) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "findFilteredAndSortedPart(int,int)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "start: " + n + ", " + "end: " + n2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = n;
        while (n3 <= n2) {
            int n4 = this.reverseMap[n3];
            arrayList.add(new Integer(n4));
            ++n3;
        }
        Collections.sort(arrayList, new IntegerCompare());
        return arrayList;
    }

    private void buildReverseMap(int n) {
        if (FilteredAndSortedTableModel.logger.level >= 7) {
            logger.log(7, "buildReverseMap(int)", FilteredAndSortedTableModel.logger.level < 8 ? "" : "extra: " + n);
        }
        if (this.reverseMap == null || n > this.reverseExtra) {
            if (FilteredAndSortedTableModel.logger.level >= 9) {
                logger.log(9, "buildReverseMap(int)", "rebuilding");
            }
            this.reverseMap = new int[this.model.getRowCount() + n];
            int n2 = 0;
            while (n2 < this.reverseMap.length) {
                this.reverseMap[n2] = -1;
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.indexMap.size()) {
                this.reverseMap[((Integer)this.indexMap.get((int)n3)).intValue()] = n3;
                ++n3;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IntegerCompare
    implements Comparator {
        private IntegerCompare() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = (Integer)object;
            return n2 == (n = ((Integer)object2).intValue()) ? 0 : (n2 < n ? -1 : 1);
        }
    }

    private class SorterCompare
    implements Comparator {
        private SorterCompare() {
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            return FilteredAndSortedTableModel.this.sorter.compare(FilteredAndSortedTableModel.this.model, n, n2);
        }
    }
}

