/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2005 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer.gui;


import java.awt.*;
import javax.swing.*;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;


public class ModalProgressPopup
    extends ModalDialog
{
    /** The size of the popup */
    final static private Dimension SIZE = new Dimension(300, 75);

    private String message = null;


    public ModalProgressPopup(String title, String message)
    {
	super(Gatherer.g_man, title);
	this.message = message;
        this.setComponentOrientation(Dictionary.getOrientation());
    }


    /** Method to close the popup. */
    public void close()
    {
	Gatherer.invokeInEDT_replacesProceedInCurrThread(
	 "ModalProgressPopup() - closing progress_popup",
	 Gatherer.SYNC,
	 //Gatherer.BYPASS_WHEN_NOT_TESTING,
	 new Runnable() {
	     public void run() {
		 setVisible(false);
	     }
	 });
	Gatherer.g_man.wait(false);
    }


    /** Method to display the popup on screen. */
    public void display()
    {
     Gatherer.invokeInEDT_replacesProceedInCurrThread(
      "ModalProgressPopup() - displaying progress_popup",
      Gatherer.SYNC,
      //Gatherer.BYPASS_WHEN_NOT_TESTING,
      new Runnable() {
       public void run() {
		 
	setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
	setSize(SIZE);

	// Create
	JProgressBar progress_bar = new JProgressBar();
        progress_bar.setComponentOrientation(Dictionary.getOrientation());
	progress_bar.setIndeterminate(true);

	// Layout
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.setLayout(new BorderLayout());
        
        JLabel tmp = new JLabel(message);
        tmp.setComponentOrientation(Dictionary.getOrientation());
	
        content_pane.add(tmp, BorderLayout.NORTH);
	content_pane.add(progress_bar, BorderLayout.CENTER);

	Dimension screen_size = Configuration.screen_size;
	setLocation((screen_size.width - SIZE.width) / 2, (screen_size.height - SIZE.height) / 2);

	// Need names set on components before displaying, so GUI tester assertj swing
	// can find the components by name when they display
	TestingPreparation.setNamesRecursively(ModalProgressPopup.this);
	setVisible(true);
       } // end run
      }); // end invokeInEDT();	

     // Lock the rest of the GLI interface until close() is called
     Gatherer.g_man.wait(true);
    }
}
