/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import org.webswing.toolkit.api.WebswingUtil;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.greenstone.LocalLibraryServer;
import org.greenstone.gatherer.greenstone3.ServletConfiguration;
import org.greenstone.gatherer.util.StaticStrings;


public class PreviewButton 
    extends GLIButton {


    static final public int HOME_PAGE = 1;
    static final public int SEARCH_PAGE = 2;
    static final public int CLASSIFIER_PAGE = 3;
    static final public int DOCUMENT_PAGE = 4;

    private String preview_address;
    private int page_type = HOME_PAGE;
    private boolean variable_preview = false;
    
    private PreviewButtonOwner owner = null;
    public PreviewButton() {
	super();
	PreviewButtonListener pbl = new PreviewButtonListener();
	addActionListener(pbl);
    }
    public PreviewButton(String text, String tooltip) {
	super(text, tooltip);
	PreviewButtonListener pbl = new PreviewButtonListener();
	addActionListener(pbl);
    }
    
    // used by GLI automated testing, to open preview URL in selenium driven browser
    public String getPreviewURL() {
	return preview_address;
    }
    
    public void setOwner(PreviewButtonOwner o) {
	owner = o;
    }
    public void setVariablePreview(boolean vp) {
	variable_preview = vp;
    }
    protected void configureHomeURL() {
	// we could be working with standalone collections or collection groups
	// so getting a collection-name may have a collection group prefix
	// This means CollectionManager.getLoadedCollectionName() needs to (and does) return (colgroup/)subcolname
	String collGroupWithName = CollectionManager.getLoadedCollectionName(true);

	// set up the home page for the current collection
	if (Gatherer.GS3) { // GLI for GS3 case
          if(Configuration.library_url == null) {// && !Configuration.fedora_info.isActive()) {
          	Gatherer.missingEXEC(null);
          } 
	    // if we now finally have a library URL, then continue with previewing
	    if(Configuration.library_url != null) {
		// don't do anything fancy here
		preview_address = Configuration.library_url.toString() + Configuration.getServletPath() 
		    + "?a=p&sa=about&c=" + collGroupWithName + "&l=" + Configuration.getLanguage();
	    }
	    return;
	}

	if(Gatherer.isLocalLibrary) {
	    // check that the local library server is still running  - doesn't do anything if it's not supposed to be running
	    // !! Don't like this here
	    LocalLibraryServer.checkServerRunning();
	    if(LocalLibraryServer.isURLPending()) {
		// Remind the user to press Enter Library, and return from this method
		JOptionPane.showMessageDialog(Gatherer.g_man,
					      Dictionary.get("General.LLS_Not_Started"), 
					      Dictionary.get("General.LLS_Not_Started_Title"),
					      JOptionPane.INFORMATION_MESSAGE);
		preview_address = null;
		return;	  
	    } 
	}
	// FLI or GLI for GS2 case (no library_url)
	if(Configuration.fedora_info.isActive()) {
	    preview_address = Configuration.library_url.toString() + "?pid=true&title=true&terms=&query=pid~greenstone:"+collGroupWithName+"*&maxResults=20";
	    //+ "&l=" + Configuration.getLanguage();
	} else {
	    preview_address = Configuration.library_url.toString() + "?c=" + collGroupWithName + "&l=" + Configuration.getLanguage();
	}

	String main_args = "&a=p&p=about";
	/* this code is for switching the preview page depending on what 
	    is currently active. but it is not complete yet
	String main_args = null;
	String params = null;
	if (!variable_preview || owner == null) {
	    main_args = "&a=p&p=about";
	} else {
	    page_type = owner.getPageType();
	    params = owner.getPageParams();
	    
	    switch (page_type) {
	    case SEARCH_PAGE:
		main_args = "&a=q&q="+params;
		break;
	    case CLASSIFIER_PAGE:
		main_args = "&a=d&cl="+params;
		break;
	    case DOCUMENT_PAGE:
		  main_args = "&a=d&d="+params;
		break;
	    case HOME_PAGE:
	    default:
		main_args = "&a=p&p=about";
		
		
	    }
	    

	}
	*/
	preview_address += main_args+StaticStrings.TIMESTAMP_ARGUMENT + System.currentTimeMillis();
	
    }
    private class PreviewButtonListener
	implements ActionListener {

	public void actionPerformed(ActionEvent event) {
	    Gatherer.c_man.saveCollection();
	    
	    configureHomeURL();
	    
	    if (Gatherer.GS3) {
		// we need to rerun the convert in case the format stuff has changed
		//for gs3, we don't need this anymore: Gatherer.c_man.convertToGS3Collection();
		Gatherer.configGS3Server(Configuration.site_name, ServletConfiguration.ADD_COMMAND + Gatherer.c_man.getLoadedCollectionName());
	    }

	    if(preview_address != null) {
		if (Gatherer.isWebswing) {
		    WebswingUtil.getWebswingApi().sendActionEvent("previewURL", preview_address, null);
		} else if(TestingPreparation.TEST_MODE) {
		    // don't open browser window, we just want the preview URL
		    System.err.println("*** TEST_MODE: not opening preview URL in regular browser");
		}
		else {
		    Gatherer.spawnBrowser(preview_address);
		}
	    }


	    
	}

    }

}
