# this file must be UTF-8 encoded
######################################################################
#
# Traditional Chinese Language text and icon macros 
# -- this file contains text that is of less importance
# -- to translate when creating a new interface language
######################################################################



######################################################################
# 'home' page
package home
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_documents_ [l=zh-tr] {文件。}
_lastupdate_ [l=zh-tr] {最後更新}
_ago_ [l=zh-tr] {天前。}
_colnotbuilt_ [l=zh-tr] {欲建立的資料庫。}

### taken from here

_textpoem_ [l=zh-tr] {<br><h2>Kia papapounamu te moana</h2>

<p>kia hora te marino,  
<br>kia tere te karohirohi, 
<br>kia papapounamu te moana 

<p>may peace and calmness surround you,  
<br>may you reside in the warmth of a summer's haze,  
<br>may the ocean of your travels be as smooth as the polished greenstone. 
}

_textgreenstone_ [l=zh-tr] {<p>Greenstone 是一種產於紐西蘭的綠寶石﹝如這套軟件的名稱﹞。在傳統的毛利人社會裏，Greenstone 是所有物質的精髓，亦是最珍貴和罕有的。Greenstone 既可以吸收和持有靈氣/生命力<i>wairua</i>，而且賦有傳統美德的特性。因此，Greenstone 是公共領域數碼圖書館計劃 (public-domain digital library project) 的象徽。Greenstone 的光彩代表慈愛；它的通透代表誠實；它的堅硬代表勇氣；而它所能承受的利刃代表正義。Greenstone 數碼圖書館軟件的標誌是一個雕刻 <i>patu</i> ﹝或打擊棒﹞，亦是這個數碼圖書館計劃中某成員的傳家之寶。在徒手戰役中，Greenstone 的傳遞表現是快速、準確和完整的。我們希望這套軟件擁有傳統 Greenstone 的特性，而鋒利的<i>patu</i>則象徵這套軟件走向科技的前端。</p>
}  

_textaboutgreenstone_ [l=zh-tr] {<p> Greenstone是建立和傳佈數位圖書館典藏的軟體程式，它
提供了一個整編資訊且發表於網路或CD-ROM的新方法。Greenstone是<b>Waikato
大學</b>與<b>紐西蘭數位圖書館計畫小組</b>建構，同時和<b>UNESCO</b>和<b>Human Info NGO</b>所合作發展和傳佈。它是open-source的軟體，在<a herf="http://greenstone.org">http://greenstone.org</a> 下鍵入條件
GNU General Public License， 即可獲得來自http://greenstone.org under the terms of 
the GNU一般性公開授權。 


<p>此軟體的目的是要讓使用者，尤其是在大學、 圖書館、和其他公共服務機構裡
的使用者，去建構屬於他們自己的數位圖書館，數位圖書館正被徹底地改良如
何讓世界各地尤其是開發中國家和與UNESCO合作的教科文領域的社區與機構
散播及索求資訊，我們冀望此軟體能激勵數位圖書館有效的開發，以分享資訊並
將其放置在公共網域。 


<p>此軟體是由以下三方面於2000年8月國際共同合作開發的: 

<table border="0">
<tr valign="top">
<td>
<a href="http://nzdl.org"><b>New Zealand Digital Library Project at the University of Waikato</b></a>
<br>
<p> Greenstone軟體經由此計畫誕生,並由unesco紐西蘭國家委員會網路子委員會背書，做為紐西蘭對UNESCO計劃的貢獻。

</td>
<td></td>
</tr>
<tr valign="top">
<td>
<a href="http://www.unesco.org"><b>United Nations Educational, Scientific and Cultural Organization</b></a>
<br>
全球教科文資訊的傳播，尤其是對開發中國家的助益， 是UNESCO在各
政府間追求的中心目標。而在此議題上,適切可得的傳播科技工具亦是同等
重要。 
</td>
<td><a href="http://www.unesco.org"><img alt="UNESCO logo" src="_httpimg_/unesco.gif"
border="0"></a></td>
</tr>
<tr valign="top">
<td>
<a href="http://humaninfo.org"><b>The Human Info NGO, based in Antwerp, Belgium</b></a>
<br>
此計劃和聯合國機構和其他非政府組織合作，在數位化人類發展議題文件上
建立了世界聲譽，不但將全人類的福祉發展加以數位化記錄，資料可廣泛
地取得，同時開發中國家不用花一分錢，而其他的國家也節省了經費。 
</td>
<td><a href="http://humaninfo.org"><img alt="Human Info logo" src="_httpimg_/ghproj2.jpg" border="0"></a></td>
</tr>
</table>
}


_textdescrselcol_ [l=zh-tr] {選擇典藏資料庫}


######################################################################
# home help page
package homehelp
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_text4buts_ [l=zh-tr] {在首頁有四個下一步按鈕}

_textnocollections_ [l=zh-tr] {<p>目前在Greenstone內無任何典藏資料庫，欲加入典藏資料庫可用下列任一方法： 
<ul><li>•	使用<a href="_httppagecollector_">資料庫典藏介面</a>來建立新的典藏。
<li>•	如果您有Greenston cd-rom，可從 cd-rom來安裝典藏。</ul> 
}

_text1coll_ [l=zh-tr] {Greenston安裝包含一項典藏}

_textmorecolls_ [l=zh-tr] {Greenston安裝包含一項典藏}

######################################################################
# external link package
package extlink
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textextlink_ [l=zh-tr] {外部連結}
_textlinknotfound_ [l=zh-tr] {未發現內部連結}  

_textextlinkcontent_ [l=zh-tr] {你所選擇的均為目前所選典藏資料庫的外部連結。
如果你仍然希望顯示此連結而且你的瀏覽器以進入此網
站，你可以”前進”到此頁面 ； 
否則使用瀏覽器的<a href="_nexturl_">”回上頁”</a>鍵，回到先前的頁面
}

_textlinknotfoundcontent_ [l=zh-tr] {由於超過可控制範圍之故，你所選擇的內部連結並不
存在，這可能是由於來源文件的錯誤，你可使用瀏覽器的”回上頁”鍵，回到先
前的頁面。}

# should have arguments of collection, collectionname and link
_foundintcontent_ [l=zh-tr] {<h3> 連結至 "_2_" 典藏資料庫 </h3>

<p> 您所選擇的連結為 "_collectionname_" 典藏資料庫的外部連結 (連結至 "_2_" 典藏資料庫)。如慾檢視於 "_2_" 典藏資料庫內的連結，您可以按一下<a href="_httpdoc_&c=_1_&cl=_cgiargclUrlsafe_&d=_3_"> 這裏的連結</a>，以前往該頁；或者，按一下瀏覽器的「回到上一頁」鍵，以回到前一頁。}  


######################################################################
# authentication page
package authen
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textGSDLtitle_ [l=zh-tr] {Greenstone 數位圖書館}

_textusername_ [l=zh-tr] {使用者名稱}
_textpassword_ [l=zh-tr] {密碼}

_textmustbelongtogroup_ [l=zh-tr] {注意！你必須屬於 "_cgiargugHtmlsafe_" 這個群組才能看到此頁}

_textmessageinvalid_ [l=zh-tr] {你所請求進入的頁面需要登入：<br>
_If_(_cgiargug_,[請注意你必須屬於 "_cgiargugHtmlsafe_" 群組才能進入此網頁] <br>)
請輸入你的 Greenstone 使用者名稱及密碼：}

_textmessagefailed_ [l=zh-tr] {使用者名稱或密碼錯誤：}

_textmessagedisabled_ [l=zh-tr] {抱歉，你的帳號無效！請與本站的網站管理員連絡。}

_textmessagepermissiondenied_ [l=zh-tr] {抱歉，你沒有權限進入此網頁！}

_textmessagestalekey_ [l=zh-tr] {連結失效，請輸入你的密碼以進入此網頁}


######################################################################
# 'docs' page 
package docs
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textnodocumentation_ [l=zh-tr] {<p>Greenstone安裝沒有包含任何文件之可能原因為： 
<ol>
<li>1.	使用Greenstone CD-ROM 的簡易安裝。
<li>2.	從internet使用Greenstone 下載安裝。
</ol>
以下兩種方式可以獲得文件：從 Greenstone CD-ROM的<i>docs</i>目錄或到 
 <a href="http://www.greenstone.org">http://www.greenstone.org</a>
}

_textuserguide_ [l=zh-tr] {使用者手冊}
_textinstallerguide_ [l=zh-tr] {安裝者手冊}
_textdeveloperguide_ [l=zh-tr] {開發者手冊}
_textpaperguide_ [l=zh-tr] {從紙本到典藏}
_textorganizerguide_ [l=zh-tr] {使用Organizer}

_textgsdocstitle_ [l=zh-tr] {Greenstone 系統文件　}

######################################################################
# collectoraction
package wizard

_textbild_ [l=zh-tr] {建立典藏資料庫}  
_textbildsuc_ [l=zh-tr] {典藏資料庫已成功地建立。}  
_textviewbildsummary_ [l=zh-tr] {有關這個典藏資料庫的進一步資料，您可以使用<a href="_httppagex_(bsummary)" target=_top>這個連結</a>，以檢視已建立的典藏資料庫之過程紀錄。}  
_textview_ [l=zh-tr] {檢視典藏資料庫}  

_textbild1_ [l=zh-tr] {典藏資料庫正在建立中，需時進行。執行狀態顯示於下方。}  

_textbild2_ [l=zh-tr] {按一下這裏，以終止建立過程。
<br>工作中的典藏資料庫將不受影響。}  

_textstopbuild_ [l=zh-tr] {終止建立過程}  

_textbild3_ [l=zh-tr] {如要離開這頁 (並未按鍵終止建立過程)，典藏資料庫將會繼續進行建立和安裝過程，直至整個程序完成為止。}  

_textbuildcancelled_ [l=zh-tr] {建立過程已被取消}  

_textbildcancel1_ [l=zh-tr] {典藏資料庫建立過程已被取消。按一下以下的黃色鍵，以更改典藏資料庫或重新啟動建立過程。}  

_textbsupdate1_ [l=zh-tr] {建立狀態將於 1 秒內更新}  
_textbsupdate2_ [l=zh-tr] {建立狀態更新日期為}  
_textseconds_ [l=zh-tr] {秒}  

_textfailmsg11_ [l=zh-tr] {由於典藏資料庫並未儲存資料，典藏資料庫因此不能建立。請確定至少有一個目錄或檔案是出現於<i>原始數據</i>的網頁上，而同時是 Greenstone 能夠執行的一種檔案。 }  

_textfailmsg21_ [l=zh-tr] {典藏資料庫不能建立 (滙入 import.pl 失敗)。}  
_textfailmsg31_ [l=zh-tr] {典藏資料庫不能建立 (建立 buildcol.pl 失敗).}  
_textfailmsg41_ [l=zh-tr] {典藏資料庫經已成功建立，但不能安裝。}  
_textfailmsg71_ [l=zh-tr] {嚐試建立典藏資料庫的時候，錯誤出現。}  


_textblcont_ [l=zh-tr] {建立日誌包括以下的資訊：}  

######################################################################
# collectoraction
package collector
######################################################################



#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultstructure_ [l=zh-tr] {預設架構}
_textmore_ [l=zh-tr] {更多}
_textinfo_ [l=zh-tr] {典藏資料庫資訊}
_textsrce_ [l=zh-tr] {來源文件資料}
_textconf_ [l=zh-tr] {設定典藏資料庫}
_textdel_ [l=zh-tr] {刪除典藏資料庫}  
_textexpt_ [l=zh-tr] {匯出典藏資料庫}

_textdownloadingfiles_ [l=zh-tr] {下載檔案…}
_textimportingcollection_ [l=zh-tr] {匯入典藏資料庫…}
_textbuildingcollection_ [l=zh-tr] {建立典藏資料庫…}
_textcreatingcollection_ [l=zh-tr] {建立典藏資料庫…}

_textcollectorblurb_ [l=zh-tr] {<i>筆鋒於劍！
<br>建立及傳送文件典藏附帶著你必須在一開始前即須深思的責任，存在於複製的
法律問題: 可以取用文件並不表示你一定可以傳送給他人，存在於社會上的爭議: 
所有的文件必須尊重它來源處的地方風俗，同時也存在道德的問題 : 有些事不應
輕易地讓別人可以利用，
<br>對資訊的影響力必須敏銳，同時有智慧地使用它。
</i>
}

_textcb1_ [l=zh-tr] {資料庫典藏介面可協助你建立新的典藏資料庫，更新及增加現存的典藏資料庫，或刪除典藏資料庫，要做到前述的功能，可依循網頁資訊的指引。
}

_textcb2_ [l=zh-tr] {首先, 你必須決定是否}
_textcnc_ [l=zh-tr] {建立新的典藏資料庫}
_textwec_ [l=zh-tr] {於已存在的典藏資料庫中新增或刪除資料}

_textcb3_ [l=zh-tr] {你必須簽署以便建立
或更新數位圖書館典藏，此舉可以保護你來自其它地方登入你的電腦並改變資
訊的行為。注意：基於安全理由，每30分鐘時限過後，你將被自動登出，如果
發生此狀況，別擔心， 請再登入，同時可以從先前離開之處繼續執行。
}

_textcb4_ [l=zh-tr] {請輸入你在Greenston 的使用者名稱和密碼並點選按鍵使登入。}

_textfsc_ [l=zh-tr] {首先選擇執行先前選過的典藏資料庫 (防止寫入的典藏資料庫不會顯示在此目錄上) }

_textwtc_ [l=zh-tr] {於你已選擇的典藏資料庫中，你可以
}
_textamd_ [l=zh-tr] {增加更多文件及重建典藏資料庫}
_textetc_ [l=zh-tr] {編輯典藏資料庫結構檔案並重建資料庫}
_textdtc_ [l=zh-tr] {完全刪除典藏資料庫}
_textetcfcd_ [l=zh-tr] {匯出典藏資料庫，寫入到self-installing Windows CD-ROM}
_textcaec_ [l=zh-tr] {更改已存在的典藏資料庫}
_textnwec_ [l=zh-tr] {沒有可寫入的資料庫典藏可拿來修改}
_textcianc_ [l=zh-tr] {建立新的典藏資料庫}
_texttsosn_ [l=zh-tr] {建立新的數位圖書館
典藏資料庫所需的步驟順序：}
_textsin_ [l=zh-tr] {指定名稱 (及相關資訊)}
_textswts_ [l=zh-tr] {指定來源資料文的件路徑或網址}
_textatco_ [l=zh-tr] {調整資料庫設定檔 (進階使用者)}
_textbtc_ [l=zh-tr] {"建立"典藏資料庫 (如
下)}
_textpvyh_ [l=zh-tr] {檢視成果}

_texttfsiw_ [l=zh-tr] {第四個步驟是透過電腦執行所有工作，在 "建立資料庫"的過程中，電腦建立所有文件的索引並收集任何建立時所需要的資訊將。但首先你必須明確指出文件資訊。
}

_textadab_ [l=zh-tr] {再建立的過程中下方的圖示列出現將協助你追蹤
目前的所在位置，你必須點選綠色的鍵以繼續.，完成時，此鍵會變成黃色，點
選圖示中相應的黃色鍵你可以回到上一頁。
}

_textwyar_ [l=zh-tr] {當準備完成後，點選”典藏資料庫資訊”按鈕可以開始建立你的新數位圖書館典藏資料庫! }

_textcnmbs_ [l=zh-tr] {確立典藏資料庫名稱}
_texteambs_ [l=zh-tr] {確立電子郵件地址}
_textpsea_ [l=zh-tr] {請確立此表中電子郵件地址：使用者名稱@網域 }
_textdocmbs_ [l=zh-tr] {確立典藏資料庫的描述}

_textwcanc_ [l=zh-tr] {當建立一新的典藏資料庫你需要輸入一些有關來源資料的先決資訊，此步驟是由一系列網頁建構成的，由收藏者監看頁面下方的橫列顯示所需完成頁數的順序。
}

_texttfc_ [l=zh-tr] {典藏資料庫名稱:}

_texttctiasp_ [l=zh-tr] {典藏典藏資料庫名稱是一簡短片語，在數位圖書館中用來分辨典藏內容的，
例如”電腦技術報告”和”人類發展圖書館”
}

_textcea_ [l=zh-tr] {電子郵件聯絡地址： }

_textteas_ [l=zh-tr] {此電子郵件地址為的第一道聯絡窗口：若Greenstone軟體若偵測到
問題，診斷報告會送到此地址，輸入完整的電子郵件地址:<tt>名稱@網域</tt>. 
}

_textatc_ [l=zh-tr] {關於這個典藏資料庫:}

_texttiasd_ [l=zh-tr] {為描述此典藏資料庫的宗旨，當進入典藏資料庫時，它是第一個被顯示出來的畫面。 
}

_textypits_ [l=zh-tr] {下方的箭頭表示你所在的順序--在目前的情況下是”典藏資料庫資訊”階段，按綠色的”來源資料”鍵即可繼續.. 
}

_srcebadsources_ [l=zh-tr] {<p>一個或多個輸入之來源資料文件無法被參考到 (標示 _iconcross_ 如下) :

<p>可能造成的原因 
<ul>
<li>•	檔案路徑, FTP站或網址不存在。
<li>•	確認電腦網路通訊是否正常。
<li>•	你要求參照的網路文件需透過帳號密碼才能夠存取。
</ul>

<p>雖然該網址上的文件可以在你的瀏覽器上看到，但它有可能只是你電腦內的暫存檔，很不幸的本地端暫存檔將無法在資料庫建立的過程中被參照到，在這種情況下我們建議先將該文件下載到本地端儲存後，再進行資料庫的建立。
}

_textymbyco_ [l=zh-tr] {<p>你的典藏資料庫可以建立在以下任一種基礎上 
<ul>
<li>•	原始架構 
<dl><dd>新的典藏可包含 html檔 (.htm, .html)，純文字檔 (.txt, .text)，MS Word 檔 
(.doc)， PDF 檔 (.pdf) 或 "m-box" 格式電子郵件檔 (.mbx)。<dd><dl>
<li>•	已存在的典藏 
<dl><dd>在新收藏內的檔案必須和現有收藏一模一樣。<dd><dl>
</ul>
}  

_textbtco_ [l=zh-tr] {典藏資料庫基礎}
_textand_ [l=zh-tr] {增加新資料}
_textad_ [l=zh-tr] {增加資料：}

_texttftysb_ [l=zh-tr] {增加下列指定檔案於典藏資料庫內，請確認檔案未重覆指定：否則將有兩
份同樣的檔案，請使用完整的路徑名稱來辨識檔案，網頁要用獨一無二的網
址。 
}

_textis_ [l=zh-tr] {輸入資料文件來源：}

_textddd1_ [l=zh-tr] {<p>若你使用 file:// 或 ftp:// 來指定一個檔案，即可下載該檔.

<p>若你使用 http://則取決於URL是否在你的瀏覽器上給你一個正常的網頁或檔案
目錄，若為一網頁,則會下載該網頁–若它(們)連結許多網頁則所有網頁都會被下
載.– 即URL下同一網站內的網頁都會被下載。 

<p>若你使用 file:// 或ftp:// 來指定一檔案夾或目錄,或是http:// URL給了你檔案目
錄，則檔案夾和它之下的子檔案夾都會被包含在典藏資料庫內。
 
<p>點選”更多資料文件來源”鍵可得到更多輸入欄位。 
}

_textddd2_ [l=zh-tr] {<p>點選任一綠鍵，若你是進階使用者你可以調整典藏資料庫結構或者直接到建構階段。記得，只要點選黃鍵就可回到前一階段。
}

_textconf1_ [l=zh-tr] {<p>典藏資料庫的建構和呈現都是由”結構檔”控制，進階使用者可改變其設定。 
<center><p><b>若你不是進階使用者, 請直接到網頁底部..</b></center> 
<p>修改下列資料即可更改結構設定，若輸入錯誤則點選”回復”鍵回到原設定
}

_textreset_ [l=zh-tr] {復原}


_texttryagain_ [l=zh-tr] {請<a href="_httppagecollector_" target=_top>重新啟動典藏資料庫介面</a>並重試
}


_textretcoll_ [l=zh-tr] {回到典藏資料庫介面}

_textdelperm_ [l=zh-tr] {部分或全部 _cgiargbc1dirnameHtmlsafe_ 典藏資料庫無法刪除，可能原因為：
<ul> 
<li>•	Greenstone 無刪除_gsdlhome_/collect/_cgiargbc1dirnameHtmlsafe_ 目錄的許可。 
你需要人工移除_cgiargbc1dirnameHtmlsafe_典藏資料庫。</li>
<li>•	Greenstone 無法執行_gsdlhome_/bin/script/delcol.pl程式，請確定此檔案可
讀寫和執行。</li>
</ul>
}

_textdelinv_ [l=zh-tr] {_cgiargbc1dirnameHtmlsafe_ 典藏資料庫被保護或無效，取消刪除。 
}

_textdelsuc_ [l=zh-tr] {成功刪除_cgiargbc1dirnameHtmlsafe_典藏資料庫。}

_textclonefail_ [l=zh-tr] {無法複製 _cgiargclonecolHtmlsafe_ 典藏資料庫，可能原因為：
<ul>
<li>•	_cgiargclonecolHtmlsafe_ collection 不存在。 
<li>•	_cgiargclonecolHtmlsafe_ collection 沒有 collect.cfg 變數檔。 
<li>•	Greenstone 沒有讀取collect.cfg 變數檔的許可。 
</ul>
}

_textcolerr_ [l=zh-tr] {典藏資料庫介面錯誤}

_texttmpfail_ [l=zh-tr] {存款者不能讀取或抄寫至臨時檔案或名錄。可能出現的原因有：
<ul>
<li>Greenstone 沒有讀取/抄寫至 _gsdlhome_/tmp 名錄的權限
</ul>
}  

_textmkcolfail_ [l=zh-tr] {在新典藏下典藏資料庫介面無法建立目錄結構 (mkcol.pl 失敗)可能原因為：
<ul>
<li>•	Greenstone 沒有寫入 _gsdlhome_/tmp 目錄的許可。
<li>•	mkcol.pl perl描述錯誤。 
</ul>
}

_textnocontent_ [l=zh-tr] {典藏資料庫介面錯誤：新典藏資料庫無名稱，從頭開始重新啟動典藏資料庫介面。}

_textrestart_ [l=zh-tr] {重新啟動典藏資料庫介面}

_textreloaderror_ [l=zh-tr] {建立新典藏資料庫時有誤，這可能是
因為Greenstone已被瀏覽器使用”重新載入”或”返回”鍵混淆(請於建立新典藏資料庫時避免使用此二鍵)，建議你重新啟動典藏資料庫介面。
}

_textexptsuc_ [l=zh-tr] {成功輸出 _cgiargbc1dirnameHtmlsafe_典藏資料庫 至 _gsdlhome_/tmp/exported\__cgiargbc1dirnameHtmlsafe_ 目錄。 
}

_textexptfail_ [l=zh-tr] {<p>無法輸出 _cgiargbc1dirnameHtmlsafe_ 的典藏資料庫。

<p>這可能是因為 Greenstone 沒有安裝支援「輸出至光碟」功能的必要元件。 
<ul>
<li> 倘若你使用光碟安裝 2.70 或之前版本的 Greenstone，除非您在安裝時選擇「進階選項」，否則這些元件不會被安裝。您必須重新安裝 Greenstone，並加入這個必要元件。
<li> 倘若你使用網路安裝，您必須下載和安裝額外套件，方可使用此項功能。詳情請瀏覽網址 <a href="http://www.greenstone.org">http://www.greenstone.org</a> 或 <a href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">加入郵寄清單</a>
</ul>}  

######################################################################
# depositoraction
package depositor
######################################################################


_textdepositorblurb_ [l=zh-tr] {<p> 請說明以下檔案的資料及按 _textintro_ </p>}  

_textcaec_ [l=zh-tr] {加入現存的典藏資料庫}  
_textbild_ [l=zh-tr] {存入項目}  
_textintro_ [l=zh-tr] {選擇檔案}  
_textconfirm_ [l=zh-tr] {確定}  
_textselect_ [l=zh-tr] {選擇典藏資料庫}  
_textmeta_ [l=zh-tr] {說明元數據}  
_textselectoption_ [l=zh-tr] {選擇典藏資料庫}  

_texttryagain_ [l=zh-tr] {請<a href="_httppagedepositor_" target=_top>重新開始存款者</a>然後再嘗試。\}  

_textselectcol_ [l=zh-tr] {選擇一個要增加新文件的典藏資料庫}  
_textfilename_ [l=zh-tr] {檔案名稱}  
_textfilesize_ [l=zh-tr] {檔案大小}  

_textretcoll_ [l=zh-tr] {退回至存款者}  


_texttmpfail_ [l=zh-tr] {存款者不能讀取或抄寫至臨時檔案或名錄。可能出現的原因有：
<ul>
<li> Greenstone 沒有讀取/抄寫至 _gsdlhome_/tmp 名錄的權限
</ul>}  


######################################################################
# 'gsdl' page
package gsdl
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textgreenstone1_ [l=zh-tr] {Greenstone是一套擁有服務數位圖書館典藏和建構典藏能力的軟體，它提供了整合資訊的新方法和用網路或CD-ROM公開資訊。Greenstone 是由Waikato大學的紐西蘭數位圖書館計畫製造，和UNESCO及Human Info NGO合作發行的。它是open-source軟體，
在<i>http://greenstone.org</i> 下鍵入GNU General Public License 可取得。 
}

_textgreenstone2_ [l=zh-tr] {紐西蘭數位圖書館網站 (<a href="http://nzdl.org">http://nzdl.org</a>) 包含了無數用
Greenstone軟體建立可供精讀的收藏範本，它們是各種搜尋和瀏覽選擇的範例,
其中包括了阿拉伯、中國、法國、毛利、西班牙和英國的典藏，還有一些音樂的
典藏。
}

_textplatformtitle_ [l=zh-tr] {平台}
_textgreenstone3_ [l=zh-tr] {Greenstone 可以分別在 Windows、Unix 和 Mac OS X 的作業系統上執行。其分佈包括 Windows、 Linux 和 Mac OS X 所有版本的可執行檔。同時,它也包含了可被 Microsoft C++ 或 gcc 編譯的完整系統原始碼。Greenstone 使用的免費相關軟件為：Apache Webserver 和 PERL;而使用者界面則用網頁瀏覽器：典型的 Mozilla FireFox 或 Internet Explorer。  }  

_textgreenstone4_ [l=zh-tr] {有很多典藏資料庫的文件透過Greenstone軟體光碟片散佈，例如
<i>Humanity Development Library</i>內含1,230份和用水衛生的相關統計文件，
他只需要在硬體等級要求不高地電腦上執行，這些電腦也很容易在開發中國家內取得，
文件可透過全文的關鍵字查詢，或是以不同的方式來瀏覽整個典藏資料庫內的文件
(依主題，依標題，依出版品組織，依 "如何..")，甚至也可瀏覽每一本書的封面。}

_textcustomisationtitle_ [l=zh-tr] {顧客導向}
_textgreenstone5_ [l=zh-tr] {Greenstone 具有高擴充性和以顧客為導向的觀念而設計。新的文件及詮釋資料格式藉由設計 "plugins" (in Perl)來提供。同理，新的以不同詮釋資料瀏覽的架構能夠藉由設計"classifiers" 來執行。用簡單的巨集語言寫”巨集”，可變更使用者介面的呈現方式。Corba協定讓代理人(例如Java)使用和文件典藏資料庫有關的設備，最後， 可用C++和Perl的來修定原始碼。
}

_textdocumentationtitle_ [l=zh-tr] {文件}
_textdocuments_ [l=zh-tr] {Greenstone也提供大量多樣的系統文件。}

#_textthreedocs_ {There are three documents that explain the Greenstone system:}
#_textinstall_ {The Greenstone Digital Library Software Installer's Guide}
#_textuser_ {The Greenstone Digital Library Software User's Guide}
#_textdevelop_ {The Greenstone Digital Library Software Developer's Guide}

_textmailinglisttitle_ [l=zh-tr] {郵寄清單}
_textmailinglist_ [l=zh-tr] {郵寄清單主要是為了討論Greenstone數位圖書館軟體。Greenstone的經常使用
者應考慮加入郵寄清單和加入討論。訂閱請至<a href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">
https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users</a>.

寄送訊息到清單的
地址為<a href="mailto:greenstone-users@list.scms.waikato.ac.nz"
greenstone-users@list.scms.waikato.ac.n</a>z. 
}

_textbugstitle_ [l=zh-tr] {Bugs}
_textreport_ [l=zh-tr] {為確保這軟件運作正常，如您在使用時發現有任何問題，懇請電郵<a href="mailto:greenstone@cs.waikato.ac.nz">greenstone@cs.waikato.ac.nz</a>。}  

_textgs3title_ [l=zh-tr] {在產品中}
_textgs3_ [l=zh-tr] {Greenstone 3 是保留 Greenston 2 (目前版本) 的優點，並重新設計和覆行的版本。Greenstone 3 是個一個能支援多種語言、多個作業平台和擁有高度彈性配置的軟件；Greenstone 3 能向下相容：也就是說，它不需要修改,便可以建構和執行現有的館藏。Greenstone 3 是以 Java 程式編寫，建成使用 XML 溝通之獨立模組的網路：因此,它是以派送的模式來執行,且 在必要時可以擴展到不同的伺服器上。這種模組設計增加了 Greenstone 的彈性和擴充性。Greenstone 3 的相關文件和新版本可於 <a href="http://www.greenstone.org/greenstone3-home">Greenstone 3 home page</a> 下載。 }  

_textcreditstitle_ [l=zh-tr] {讚揚}

_textwhoswho_ [l=zh-tr] {Greenstone 軟件是由許多人通力合作而成的結果。Ian Witten 是這個計劃的主要成員，Rodger McNab 和 Stefan Boddie 分別是這個計劃的設計師和執行者。其他的成員包括 David Bainbridge、 George Buchanan、 Hong Chen、Michael Dewsnip、Katherine Don、Elke Duncker、Carl Gutwin、Geoff Holmes、Dana McKay、 John McPherson、 Craig Nevill-Manning、 Dynal Patel、Gordon Paynter、 Bernhard Pfahringer、 Todd Reed、 Bill Rogers、John Thompson和 Stuart Yeates。至於，紐西蘭數位圖書館 (New Zealand Digital Library) 計劃的成員,包括： Mark Apperley、Sally Jo Cunningham、 Matt Jones、Steve Jones、 Te Taka Keegan、 Michel Loots、 Malika Mahoui、 Gary Marsden、 Dave Nichols 和 Lloyd Smith，均為 Greenstone 的系統設計給予寶貴的建議和靈感。我們亦要感謝所有為此版本作出貢獻的GNU-許可包 (GNU-licensed packages)：MG、GDBM、 PDFTOHTML、PERL、 WGET、WVWARE 和 XLHTML。 }  

_textaboutgslong_ [l=zh-tr] {關於 Greenstone 軟體}

######################################################################
# 'users' page
package userslistusers
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textlocu_ [l=zh-tr] {顯示目前使用者}
_textuser_ [l=zh-tr] {使用者}
_textas_ [l=zh-tr] {目前帳號狀態}
_textgroups_ [l=zh-tr] {群組}
_textcomment_ [l=zh-tr] {註解}
_textadduser_ [l=zh-tr] {加入新使用者}
_textedituser_ [l=zh-tr] {編輯}
_textdeleteuser_ [l=zh-tr] {刪除}


######################################################################
# 'users' page
package usersedituser
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textedituser_ [l=zh-tr] {編輯使用者資訊}
_textadduser_ [l=zh-tr] {增加新使用者}

_textaboutusername_ [l=zh-tr] {使用者名稱須為2~30個字：可包括文數字， '.'， 和 '_'. 
}

_textaboutpassword_ [l=zh-tr] {密碼須為3~8個ASCII字}

_textoldpass_ [l=zh-tr] {若此欄空白，將保留舊密碼。}
_textenabled_ [l=zh-tr] {生效}
_textdisabled_ [l=zh-tr] {無效}

_textaboutgroups_ [l=zh-tr] {群組為一逗號分隔的表單，逗號後不可有空格。}
_textavailablegroups_ [l=zh-tr] {預先設定的群組包括管理者和其他權限分配者。例如，給予使用者權限，以使用圖書館館長界 (Librarian Interface) 面來建立遠端館藏或存款者 (Depositor)： <ul> <li><b>管理者</b>：給予使用者權限，以登入、更改網站配置和用戶資料 <li><b>個人-館藏-編輯</b>：給予使用者權限，以新創建個人館藏 <li><b><館藏-名稱>-館藏-編輯</b>：給予使用者權限，以創建和編輯 "館藏-名稱" 的館藏，例如＂報告-館藏-編輯＂ <li><b>所有-館藏-編輯</b>：給予使用者權限，以新創建個人和綜合館藏，與及編輯<b>所有</b>館藏。同時，給予使用者權限使用收集者(Collector) </ul>}  


######################################################################
# 'users' page
package usersdeleteuser
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdeleteuser_ [l=zh-tr] {刪除使用者}
_textremwarn_ [l=zh-tr] {你確定要永久刪除使用者_cgiargumunHtmlsafe_?}


######################################################################
# 'users' page
package userschangepasswd
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textchangepw_ [l=zh-tr] {更改密碼}
_textoldpw_ [l=zh-tr] {舊密碼}
_textnewpw_ [l=zh-tr] {新密碼}
_textretype_ [l=zh-tr] {再輸入一次新密碼}


######################################################################
# 'users' page
package userschangepasswdok
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsuccess_ [l=zh-tr] {你的密碼更改成功！}


######################################################################
# 'users' page
package users
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textinvalidusername_ [l=zh-tr] {使用者名稱錯誤}
_textinvalidpassword_ [l=zh-tr] {密碼錯誤.}
_textemptypassword_ [l=zh-tr] {請輸入使用者最初設定的密碼}
_textuserexists_ [l=zh-tr] {使用者名稱已存在，請輸入其他使用者名稱。}

_textusernameempty_ [l=zh-tr] {請輸入使用者名稱.}
_textpasswordempty_ [l=zh-tr] {請輸入舊密碼}
_textnewpass1empty_ [l=zh-tr] {輸入你的新密碼後，再在重複輸入一次}
_textnewpassmismatch_ [l=zh-tr] {輸入二次的新密碼不相同}
_textnewinvalidpassword_ [l=zh-tr] {輸入密碼錯誤}
_textfailed_ [l=zh-tr] {使用者名稱或密碼輸入錯誤}


######################################################################
# 'status' pages
package status
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textversion_ [l=zh-tr] {Greenstone 版本}
_textframebrowser_ [l=zh-tr] {你的瀏覽器需要支援功能才能去觀看它。}
_textusermanage_ [l=zh-tr] {使用者管理}
_textlistusers_ [l=zh-tr] {列出使用者}
_textaddusers_ [l=zh-tr] {加入新的使用者}
_textchangepasswd_ [l=zh-tr] {變更密碼}
_textinfo_ [l=zh-tr] {系統資訊}
_textgeneral_ [l=zh-tr] {一般資訊}
_textarguments_ [l=zh-tr] {系統參數}
_textactions_ [l=zh-tr] {Action資訊}
_textbrowsers_ [l=zh-tr] {瀏覽器資訊}
_textprotocols_ [l=zh-tr] {協定資訊}
_textconfigfiles_ [l=zh-tr] {設定檔}
_textlogs_ [l=zh-tr] {日誌}
_textusagelog_ [l=zh-tr] {使用中之日誌}
_textinitlog_ [l=zh-tr] {起始日誌}
_texterrorlog_ [l=zh-tr] {錯誤日誌}
_textadminhome_ [l=zh-tr] {管理者首頁}
_textreturnhome_ [l=zh-tr] {Greenstone首頁}
_titlewelcome_ [l=zh-tr] {管理者 }
_textmaas_ [l=zh-tr] {維護及管理服務皆包含在內：}
_textvol_ [l=zh-tr] {觀看線上日誌}
_textcmuc_ [l=zh-tr] {產生，維護及更新典藏資料庫}
_textati_ [l=zh-tr] {存取系統資訊，例如CGI 引數}

_texttsaa_ [l=zh-tr] {這些服務存取是使用在左手邊頁面之方向航行棒 }

_textcolstat_ [l=zh-tr] {典藏資料庫狀態}

_textcwoa_ [l=zh-tr] {典藏時只會出現”執行中”，當它們建立 之cfg檔案存在且
可讀取，並且在典藏資料庫之索引字典中。(也就是不在建立中之目錄。）
_textcafi_ [l=zh-tr] {按 abbrev鍵. 可以檢視典藏資料庫資訊}

_textcafi_ [l=zh-tr] {按<i>abbrev.</i>可以檢視典藏資料庫的簡介}
_textcctv_ [l=zh-tr] {按典藏資料庫鍵去觀看資料庫情形}
_textsubc_ [l=zh-tr] {確認變更}
_texteom_ [l=zh-tr] {開啟 main.cfg錯誤}
_textftum_ [l=zh-tr] {更新 main.cfg失敗}
_textmus_ [l=zh-tr] {更新main.cfg 成功}


######################################################################
# 'bsummary' pages
package bsummary
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textbsummary_ [l=zh-tr] {建立 _collectionname_ 典藏資料庫的過程紀錄}  
_textflog_ [l=zh-tr] {_collectionname_ 典藏資料庫的失敗日誌}  
_textilog_ [l=zh-tr] {匯入"_collectionname_" 典藏資料庫的日誌}  

############################################################################
#
# This stuff is only used by the usability (SEND FEEDBACK) stuff
#
############################################################################
package Global

# old cusab button
_linktextusab_ [l=zh-tr] {送出信息}  

_greenstoneusabilitytext_ [l=zh-tr] {Greenstone 之可用性}

_textwhy_ [l=zh-tr] {<p>送出這份報告是一個方法，以指出一些有檢視困難或失敗之網頁。}  
_textextraforform_ [l=zh-tr] {你無須填完表格 – 任何訊息都有幫助。}
_textprivacybasic_ [l=zh-tr] {<p>這份報告只包含您所檢視有關 Greenstone 網頁之信息，與及您所使用的檢視技術 ﹝加上您所提供之選擇性資訊﹞。}  
_textstillsend_ [l=zh-tr] {您是否仍舊要送出這份報告？}  

_texterror_ [l=zh-tr] {錯誤}
_textyes_ [l=zh-tr] {是}  
_textno_ [l=zh-tr] {否}  
_textclosewindow_ [l=zh-tr] {關閉視窗}  
_textabout_ [l=zh-tr] {有關}
_textprivacy_ [l=zh-tr] {私下}
_textsend_ [l=zh-tr] {送出}
_textdontsend_ [l=zh-tr] {不要送出}  
_textoptionally_ [l=zh-tr] {選擇性的}  

_textunderdev_ [l=zh-tr] {最後修正的版本將包括詳細預覽報告的功能。}  

_textviewdetails_ [l=zh-tr] {檢視詳細的報告}  
_textmoredetails_ [l=zh-tr] {更詳細}  
_texttrackreport_ [l=zh-tr] {追蹤這份報告}  
_textcharacterise_ [l=zh-tr] {這是屬於哪一類問題}  
_textseverity_ [l=zh-tr] {這問題很糟糕}  
 
_textbadrender_ [l=zh-tr] {頁面看起來很奇怪}  
_textcontenterror_ [l=zh-tr] {內容錯誤}  
_textstrangebehaviour_ [l=zh-tr] {奇怪的行為}  
_textunexpected_ [l=zh-tr] {發生未能預期之情況}  
_textfunctionality_ [l=zh-tr] {很難使用}  
_textother_ [l=zh-tr] {其他}  

_textcritical_ [l=zh-tr] {評論的}  
_textmajor_ [l=zh-tr] {嚴重的}  
_textmedium_ [l=zh-tr] {中等的}  
_textminor_ [l=zh-tr] {較小的}  
_texttrivial_ [l=zh-tr] {瑣碎的}  

_textwhatdoing_ [l=zh-tr] {您嚐試做什麼?}  
_textwhatexpected_ [l=zh-tr] {您期待何事發生?}  
_textwhathappened_ [l=zh-tr] {實際上發生何事?}  

_cannotfindcgierror_ [l=zh-tr] {<h2>對不起！</h2>未能找出 「我欲投訴」的伺服器程式。}  

_textusabbanner_ [l=zh-tr] {the Greenstone koru-類型 標誌}


######################################################################
# GTI text strings
package gti
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------
	
_textgtierror_ [l=zh-tr] {發生錯誤}  

_textgtihome_ [l=zh-tr] {這頁協助您改善 Greenstone 的多語言支援。利用這個支援，你可以
<ul>
  <li> 為部份的 Greenstone 翻譯一些新語言
  <li> 在英語介面有所改變時 (例如引進新的 Greenstone 設備)，更新現存的語言介面
  <li> 糾正現有翻譯的錯誤
</ul>

一系列的網頁將會呈現您的眼前，這包括需要翻譯的詞彙。
透過逐步翻譯語言的介面，您可以繼續。
許多詞彙均包括 HTML 格式的指令：您不應該嚐試翻譯這些詞彙，卻要嚐試保持這些詞彙於已翻譯的版本。一些已有下劃線的詞彙 (例如 _this_ ) 便不應該翻譯了 (因這是 Greenstone "macro" 名稱)。
<p>
倘若您正在更新現存的語言介面，已翻譯的詞彙將不會呈現於您的眼前。有時候，已翻譯的版本並未跟隨英文版本改變。在這情況下，Greenstone 將會提供現有的翻譯，讓您有需要時可以檢查及自我更新。
<p>
如要糾正已更新的翻譯，可使用 Greenstone 提供的 "Correct existing translations" 功能。
<p>
每頁都以 "_textgtisubmit_" 按鈕為終結。當您按下此按鈕，分開安裝 Greenstone 於 nzdl.org 的改變馬上出現；而且每頁均會出現一個按鈕去進入這個網址。}  

_textgtiselecttlc_ [l=zh-tr] {請選擇語言}  

#for status page
_textgtiviewstatus_ [l=zh-tr] {按一下此鍵，以檢視所有語言的翻譯狀態}  
_textgtiviewstatusbutton_ [l=zh-tr] {檢視狀態}  
_textgtistatustable_ [l=zh-tr] {列出所有語言的翻譯狀態}  
_textgtilanguage_ [l=zh-tr] {語言}  
_textgtitotalnumberoftranslations_ [l=zh-tr] {翻譯的總數}  

_textgtiselecttfk_ [l=zh-tr] {請選擇需要工作的檔案}  

_textgticoredm_ [l=zh-tr] {Greenstone 2 介面 (主要)}  
_textgtiauxdm_ [l=zh-tr] {Greenstone 2 介面 (輔助)}  
_textgtiglidict_ [l=zh-tr] {GLI 名錄}  
_textgtiglihelp_ [l=zh-tr] {GLI 助手}  
_textgtiperlmodules_ [l=zh-tr] {Perl 模式}  
_textgtitutorials_ [l=zh-tr] {個人練習}  
_textgtigreenorg_ [l=zh-tr] {Greenstone.org}  
_textgtigs3interface_ [l=zh-tr] {Greenstone 3 界面}  

#for greenstone manuals
_textgtidevmanual_ [l=zh-tr] {Greenstone 開發手冊}  
_textgtiinstallmanual_ [l=zh-tr] {Greenstone 安裝者手冊}  
_textgtipapermanual_ [l=zh-tr] {Greenstone 手冊 (活頁至整個典藏資料庫)}  
_textgtiusermanual_ [l=zh-tr] {Greenstone 使用者手冊}  

_textgtienter_ [l=zh-tr] {輸入}  

_textgticorrectexistingtranslations_ [l=zh-tr] {糾正現存的翻譯}  
_textgtidownloadtargetfile_ [l=zh-tr] {下載檔案}  
_textgtiviewtargetfileinaction_ [l=zh-tr] {檢視這個檔案}  
_textgtitranslatefileoffline_ [l=zh-tr] {離線翻譯這個檔案}  

_textgtinumchunksmatchingquery_ [l=zh-tr] {配合題問的文字數目}  

_textgtinumchunkstranslated_ [l=zh-tr] {翻譯經已完成}  
_textgtinumchunksrequiringupdating_ [l=zh-tr] {因此， _1_ 需要更新}  
_textgtinumchunksrequiringtranslation_ [l=zh-tr] {餘下的翻譯}  

#for status page
_textgtinumchunkstranslated2_ [l=zh-tr] {已完成翻譯的數目}  
_textgtinumchunksrequiringupdating2_ [l=zh-tr] {需要更新的翻譯數目}  
_textgtinumchunksrequiringtranslation2_ [l=zh-tr] {餘下的翻譯數目}  

_textgtienterquery_ [l=zh-tr] {輸入您欲糾正的字句或片語}  
_textgtifind_ [l=zh-tr] {尋找}  

_textgtitranslatingchunk_ [l=zh-tr] {翻譯文字 <i>_1_</i>}  
_textgtiupdatingchunk_ [l=zh-tr] {更新文字 <i>_1_</i>}  
_textgtisubmit_ [l=zh-tr] {送出}  

_textgtilastupdated_ [l=zh-tr] {最後更新}  

_textgtitranslationfilecomplete_ [l=zh-tr] {多謝更新這檔案 - 更新現已完成！<p>利用以上的連結，您可以下載這檔案的副本。這連結亦會記載於新發佈的 Greenstone 上。}  

_textgtiofflinetranslation_ [l=zh-tr] {利用 Microsoft Excel 活頁簿表格檔案，您可以離線翻譯這部份的 Greenstone：
<ol>
<li>下載<a href="_gwcgi_?a=gti&p=excel&e=_compressedoptions_">檔案</a>.
<li> 開啟已下載的 Microsoft Excel 檔案 (Office 2003/XP 或較新的版本) 及儲存為 Microsoft Excel 工作表 (.xls) 格式。
<li> 於已提供的方格內輸入翻譯。
<li> 當你完成翻譯所有的字串，電郵 .xls 格式的檔案至<a href="mailto:_gtiadministratoremail_"> _gtiadministratoremail_</a>。
</ol>}  



############
# gli page
############
package gli

_textglilong_ [l=zh-tr] {Greenstone 圖書館員維護介面}
_textglihelp_ [l=zh-tr] {<p>Greenstone 的圖書館館長介面 (Greenstone Librarian Interface, GLI) 為您提供易於使用的「點選及按鍵」介面，以方便您使用不同的 Greenstone 功能。同時，亦容許您收集文件、匯入或配置元數據，與及建立 Greenstone 典藏資料庫。 

<p>請注意 GLI 是與 Greenstone 伺服器端一起執行的，而且 GLI 是安裝於 Greenstone 的子目錄。倘若您已下載其中一個 Greenstone 的元件，或已從 Greenstone 光碟中選取安裝，情況均是一樣的。

<h4>在 Windows 視窗執行 GLI</h4>

如要在 Windows 視窗執行圖書館館長介面，先在<i>開始</i>工具列中，選取<i>程式集</i>；然後，在<i>Greenstone 數碼圖書館</i>的目錄內，選取<i>圖書館館長介面</i>。

<h4>在 Unix 視窗執行 GLI</h4>

如要在 Unix 視窗執行 GLI，先在 Greenstone 安裝程序中更改 <i>gli</i> 目錄，再執行 <i>gli.sh</i> script。

<h4>在 Mac OS X 視窗執行 GLI</h4>

瀏覽<i>應用程式</i>並選取<i>Greenstone</i> (如您已安裝 Greenstone 在預設的位置內)，然後執行<i>GLI</i>應用程式。}  
