# this file must be UTF-8 encoded
#####################################################################
#
# English Language text and icon macros 
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.

# Under the 'text macros' comments are text macros of the form:
# _macroname_ {macro value}
# Everything between the {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################

######################################################################
# Global (base) package
package Global
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# these three used by the default format statement of the demo and dls collections.

# this is only used by the collector (where the above _collectionextra_
# macro will always be set to another value)

_textdescrcollection_ [l=ko] {}

# Metadata names and navigation bar labels

# Dublin Core Metadata Element Set, Version 1.1

# DLS metadata set

# Miscellaneous Greenstone metadata

# Navigation bar tooltip - to customize this for a specific metadata, add a macro named _textdescrXXX_ where XXX is the metadata name

_textmonth00_ [l=ko] {}

######################################################################
# 'home' page
package home
######################################################################

#####################################################################
# some macros used on the home page from other packages
#####################################################################
package gli

package collector

package depositor

package gti

######################################################################
# 'about' page
package about
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

######################################################################
# document package
package document
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# macros for printing page

######################################################################
# 'search' page
package query
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches

#alt text for query buttons

#these go together in form search:
#"Words  fold case fold accents stem  ... in field"

# _indexselection_, _jselection_, _nselection_ and _gselection_ are set from 
# within the server - _indexselection_ is always set, but the others may be 
# unset

# the space after "level" (before the right bracket) is required, otherwise no space between "Search" and "in"

# the space after "Search" is required, otherwise no space between "Search" and "in"

#text macros for search history

######################################################################
# 'preferences' page
package preferences
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# html options

#####################################################################
# 'browse' package for the dynamic browsing interface
package browse
#####################################################################

######################################################################
# 'help' page -- this is lower priority for translating than the
# rest of this file
package help
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# Macros giving a brief help message for navigation bar access buttons
# The arguments to this will be _textXXX_ and _labelXXX_, where XXX is the metadata name. For example, to print out the help message for a titles classifier, the library will use _textdefaulthelp_(_textTitle_,_labelTitle_)
# To customize this for a specific metadata, add a macro named _textXXXhelp_ where XXX is the metadata name

# help about the icons

