package Style

_textdefaulttitle_ [c=paperspast] {Papers Past}



package Global

_textpaperspast_ {Papers Past}

_textmetadescription_ {Papers Past is a collection of digitised historic New Zealand newspapers which offers browsing and full text searching.}

_textlangen_ {English}
_textlangmi_ {M&#257;ori}
_textemaillink_ {E-mail link}
_textprintlink_ {Print page link}

_textskiptocontent_ {Skip to content}

_texthome_ [c=paperspast] {Papers Past Home}
_textintro_ {Introduction}
_textsearch_ [c=paperspast] {Search}
_textsearchhistory_ {Search history}
_textsearchhelp_ {Search help}
_textbrowse_ {Browse}
_textbydate_ {By date}
_textbyregion_ {By region}
_textbytitle_ {By title}

_textgo_ [c=paperspast] {GO!}
_texthelp_ [c=paperspast] {Help}

_textnatliblogo_ {Go to home page &mdash; National Library of New Zealand Te Puna M&#257;tauranga o Aotearoa}

_textaboutsite_ {About this site}
_textgettingstarted_ {Getting started}
_textfaqs_ {Frequently asked questions (FAQs)}
_textcontactus_ {Contact us}
_textsitemap_ {Site map}
_textaccessibility_ {Accessibility}
_texttechnology_ {Technology}
_texttermsofuse_ {Terms of use}
_textcopyrightguide_ {Copyright guide}

_textemail_ {E-mail}
_textnzgovt_ {newzealand.govt.nz - connecting you to New Zealand central &amp; local government services}

_textnewspapertitles_ [c=paperspast] {newspaper titles}
_textnewspaperissues_ [c=paperspast] {newspaper issues}
_textpages_ [c=paperspast] {pages}
_textarticles_ [c=paperspast] {articles}

_textallpublications_ [c=paperspast] {All newspapers}

_textvolume_ [c=paperspast] {Volume}
_textissue_ [c=paperspast] {Issue}

_textday_ [c=paperspast] {Day}
_textmonth_ [c=paperspast] {Month}
_textyear_ [c=paperspast] {Year}

_textmonth01_ [c=paperspast] {January}
_textmonth02_ [c=paperspast] {February}
_textmonth03_ [c=paperspast] {March}
_textmonth04_ [c=paperspast] {April}
_textmonth05_ [c=paperspast] {May}
_textmonth06_ [c=paperspast] {June}
_textmonth07_ [c=paperspast] {July}
_textmonth08_ [c=paperspast] {August}
_textmonth09_ [c=paperspast] {September}
_textmonth10_ [c=paperspast] {October}
_textmonth11_ [c=paperspast] {November}
_textmonth12_ [c=paperspast] {December}

_textdatebrowsermonth01_ [c=paperspast] {JAN}
_textdatebrowsermonth02_ [c=paperspast] {FEB}
_textdatebrowsermonth03_ [c=paperspast] {MAR}
_textdatebrowsermonth04_ [c=paperspast] {APR}
_textdatebrowsermonth05_ [c=paperspast] {MAY}
_textdatebrowsermonth06_ [c=paperspast] {JUN}
_textdatebrowsermonth07_ [c=paperspast] {JUL}
_textdatebrowsermonth08_ [c=paperspast] {AUG}
_textdatebrowsermonth09_ [c=paperspast] {SEP}
_textdatebrowsermonth10_ [c=paperspast] {OCT}
_textdatebrowsermonth11_ [c=paperspast] {NOV}
_textdatebrowsermonth12_ [c=paperspast] {DEC}

_textpage_ [c=paperspast] {Page _1_}
_textcolumn_ [c=paperspast] {Column _1_}
_texttitlesection_ [c=paperspast] {Masthead}
_textadvertisements_ [c=paperspast] {Advertisements}
_textuntitled_ [c=paperspast] {Untitled}

_texttruncated_ {[truncated]}

_textarticleblocked_ {This article is blocked}
_textissueblocked_ {This issue is blocked}
_textpageblocked_ {This page is blocked}



package home

_textmastheadof_ {Masthead of}
_textdetailof_ {Detail of}

_textnewcontent_ {New content will be available soon on Papers Past! <a href="http://www.natlib.govt.nz/about-us/current-initiatives/papers-past-2010/">Visit the National Library website</a> for more information.}

_texthomepagedesc_ [c=paperspast] {
Papers Past contains more than two million pages of digitised New Zealand newspapers and periodicals. The collection covers the years 1839 to 1945 and includes _numsearchablepublications_ publications from all regions of New Zealand.
}

_textrecentadditions_ {Latest additions to Papers Past}

_textfindoutmore_ {Find out more about Papers Past}

_textsearchnewspapers_ [c=paperspast] {Search Newspapers}



package browse

_textbrowsenewspapers_ {Browse Newspapers}

_textbrowsebydate_ {Browse by date}
_textbrowsebyregion_ {Browse by region}
_textbrowsebytitle_ {Browse by title}

_textbrowsebydatelong_ {View all newspapers and periodicals by date.}
_textbrowsebyregionlong_ {View all newspapers and periodicals by region.}
_textbrowsebytitlelong_ {View all newspapers and periodicals by title.}



package query

_textallpublications_ [c=paperspast] {All newspapers}

_textexactphrase_ {Exact phrase}
_textsomewords_ {Any of your words}
_textallwords_ {All of your words}

_textmoreoptions_ {More search options}

_textspecifysearchtype_ {Specify your search type}

_textentersearchcriteria_ {Enter search criteria}
_textsearchkeywords_ {Search using keywords}

_textprevtip_ {Previous tip}
_textnexttip_ {Next tip}

_textrefinesearch_ [c=paperspast] {Refine search}

_textneedhelpsearching_ {Need help searching?}
_textcheckoutsearchtips_ {Check out our <a href="_gwcgi_?a=p&amp;p=help&amp;_state_" class="dark">search help</a>}
_textstillstumped_ {Still stumped?}
_textrequestresearchassistance_ {Request research assistance}

_textoptionalfilters_ {Optional Filters}
_textfilterby_ {Filter by newspaper, date or content type}
_textselectmultiple_ {To select more than one option hold down "ctrl"}
_textnewspaper_ {Newspaper}
_textdate_ [c=paperspast] {Date}
_textfrom_ [c=paperspast] {From}
_textto_ [c=paperspast] {To}
_textcategory_ {Content type}
_texttypeall_ {All content types}
_texttypeARTICLEs_ {Articles}
_texttypeADVERTISEMENTs_ {Advertisements}
_texttypeILLUSTRATIONs_ {Illustration captions}

_textexactspellingonly_ {<a href="_gwcgi_?a=p&amp;p=help&amp;_state_#exactspelling">Exact spelling</a> only}
_textviewpreviewimages_ {Show <a href="_gwcgi_?a=p&amp;p=help&amp;_state_#previewimages">preview images</a>}
_textshowwordcounts_ {Show <a href="_gwcgi_?a=p&amp;p=help&amp;_state_#wordcounts">word counts</a>}

_textreset_ {Reset}

_textnewsearch_ {New Search}
_textsearchresults_ [c=paperspast] {Search Results}
_textsearchresultsheading_ {Papers Past Search Results}
_textyoursearch_ [c=paperspast] {Your search for "_1_" found <b>_2_ results</b>. }
_textquerytermfrequencies_ [c=paperspast] {Word counts: }
_textshowingresults_ {Showing results _thisfirst_ to _thislast_}

_textfirst_ [c=paperspast] {First}
_textlast_ [c=paperspast] {Last}

_texthresult_ [c=paperspast] {result}
_texthresults_ [c=paperspast] {results}
_textinvalidquery_ [c=paperspast] {Invalid query syntax}
_textstopwordsmsg_ [c=paperspast] {To speed up your search these common words were ignored: }
_textlucenetoomanyclauses_ [c=paperspast] {Your query contained too many search terms; please try a more specific query.}
_textbaddates_ [c=paperspast] {Please enter a "to" date greater than or equal to the "from" date.}
_textnocontenttypes_ [c=paperspast] {Please select at least one content type.}
_textnodocs_ [c=paperspast] {No articles matched the query.}

_textsortresultsby_ [c=paperspast] {Sort results by}
_textsortbestmatch_ [c=paperspast] {best match first}
_textsortdate_ [c=paperspast] {date}
_textsortpubtitle_ [c=paperspast] {newspaper title}
_textsortarticletitle_ [c=paperspast] {article title}
_textsortcontenttype_ [c=paperspast] {content type}

_textof_ [c=paperspast] {of}
_textresultsperpage_ [c=paperspast] {Results per page}

_textprevresults_ {Previous _cgiargoHtmlsafe_ results}
_textnextresults_ {Next _cgiargoHtmlsafe_ results}

# Search history macros
_textviewsearchhistory_ [c=paperspast] {View your search history}
_textnohistory_ [c=paperspast] {
<div id="general-main-1col">
  <div class="inner-contentwrap">
    <p>No search history.</p>
  </div>
</div>
}

_textshexactphrase_ {The exact phrase}
_textshanywords_ {Any of the words}
_textshin_ {in}
_textshpapers_ {papers}
_textshfrom_ {from}
_textshonwards_ {onwards}
_textshupto_ {up to}
_textshto_ {to}
_textshonly_ {only}
_textshcontenttypes_ {content types}
_textshexactspellingoff_ {with exact spelling off}



package about

_textobserverfront_ {Front page of the Observer}

_textwelcome_ {Welcome to Papers Past}

_textcontent_ {
<p>Papers Past contains more than two million pages of digitised New Zealand newspapers and periodicals. The collection covers the years 1839 to 1945 and includes _numsearchablepublications_ publications from all regions of New Zealand.</p>

<p>There are two main ways to find information in Papers Past: searching and browsing. Searching lets you enter a query term and retrieves articles that contain that term. Browsing lets you look at all the newspapers, starting with a year, a region, or a newspaper title. All the newspaper titles on the site can be searched and browsed.</p>

<h3>Getting started</h3>
<p>The Getting started page gives an overview of how to use Papers Past.</p>

<p><a href="_gwcgi_?a=p&amp;p=gettingstarted&amp;_state_">Go to the Getting started page</a></p>

<h3>How to find out more about our newspaper collection</h3>
<p>The newspapers on Papers Past are only a small proportion of New Zealand newspapers. If you cannot find what you are looking for online, it may be available as a paper copy or microfilm. Check the National Newspaper Collection page on the National Library website for more information.</p>

<p><a href="http://www.natlib.govt.nz/collections/a-z-of-all-collections/national-newspaper-collection">National Newspaper Collection &mdash; National Library website</a></p>

<h3>How to find out more about a newspaper</h3>
<p>Each newspaper on Papers Past has its own page containing information about the publication, including the date range which is available online and a link to an essay about the newspaper's history. You can find links to all the newspapers on the Browse by title page.</p>

<p><a href="_gwcgi_?a=d&amp;cl=CL1&amp;_state_">Go to the Browse by title page</a></p>

<h3>Where to find M&#257;ori newspapers</h3>
<p>The <a href="http://www.nzdl.org/niupepa">M&#257;ori Niupepa Collection</a> is a collection of historic newspapers published primarily for a M&#257;ori audience between 1842 and 1932. Digitised copies of these newspapers are available on the New Zealand Digital Library website.</p>

<p><a href="http://www.nzdl.org/niupepa">M&#257;ori Niupepa Collection &mdash; New Zealand Digital Library website</a></p>

<h3>How we select new titles</h3>
<p>National Library curators select new newspaper titles for Papers Past based on a number of factors, such as national and regional significance, the availability of paper or microfilm copies of the newspaper, and ensuring a good range of regions and dates. We do not provide recent material because of copyright restrictions.</p>

<p>To find out about our newspaper digitisation programme, visit the Papers Past page on the National Library website.</p>

<p><a href="http://www.natlib.govt.nz/collections/digital-collections/papers-past">Papers Past - National Library website</a></p>

<h3>What's new</h3>

<p style="padding: 0">In _textmonth05_ 2011 we added:</p>
<ul>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.AS&amp;_state_" class="dark">_pubinfo:titleAS_ (1870-1903)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.ROTWKG&amp;_state_" class="dark">_pubinfo:titleROTWKG_ (1901-1945)</a>
</ul>

<p style="padding: 0">In _textmonth07_ 2011 we added:</p>
<ul>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.AMBPA&amp;_state_" class="dark">_pubinfo:titleAMBPA_ (1877-1920)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.DTN&amp;_state_" class="dark">_pubinfo:titleDTN_ (1881-1901)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.FS&amp;_state_" class="dark">_pubinfo:titleFS_ (1910-1920)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.NA&amp;_state_" class="dark">_pubinfo:titleNA_ (1910-1920)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.TO&amp;_state_" class="dark">_pubinfo:titleTO_ (1910-1920)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.WDT&amp;_state_" class="dark">_pubinfo:titleWDT_ (1902-1919)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.WI&amp;_state_" class="dark">_pubinfo:titleWI_ (1845-1859)</a>
</ul>

<p style="padding: 0">In _textmonth02_ 2012 we added:</p>
<ul>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.MW&amp;_state_" class="dark">_pubinfo:titleMW_ (1910-1924)</a>
<li><a href="_gwcgi_?a=d&amp;cl=CL1.CHP&amp;_state_" class="dark">_pubinfo:titleCHP_ (1861-1915)</a>
</ul>

<h3>Acknowledgements</h3>
<p>The National Library would like to thank all those organisations that provided the original paper copies to the Alexander Turnbull Library for microfilming.</p>
}

_textcollectionstats_ {COLLECTION STATISTICS}
_textcollectioncontains_ {The collection consists of:}



package document

_textbrowsebydateinstructions_ {Use the drop down menu and click on the calendar to view newspapers available by date.}

_textbrowsebyregioninstructions_ {Click on the map to browse a newspaper by region.}
_textNZ_ {New Zealand}
_textNorthIsland_ {<b>NORTH ISLAND</b>}
_textSouthIsland_ {<b>SOUTH ISLAND</b>}
_textNational_ {<b>NATIONAL</b>}
_textnationalpapers_ {NATIONAL NEWSPAPERS}

_textnewspapersfor_ {Newspapers available for}

_textpageheader_ [c=paperspast] {Pages in this issue}
_textarticleheader_ [c=paperspast] {Contents}

_textprevissue_ [c=paperspast] {Previous issue}
_textnextissue_ [c=paperspast] {Next issue}

_texttypeadvertisement_ {Advertisement}
_texttypearticle_ {Article}
_texttypeillustration_ {Illustration}
_texttypesection_ {Section}

_textprevsearchresult_ {Previous search result}
_textprevarticle_ {Previous article}
_textnextsearchresult_ {Next search result}
_textnextarticle_ {Next article}

_textbacktosearchresults_ {List of search results}
_textbacktoissuecontents_ {Back to issue contents}

_textaboutpublication_ {About this newspaper}
_textviewarticletext_ {View computer-generated text}

_textbrowseissuesbydate_ {Browse issues by date}

_textarticleview_ {Article view}
_textarticletextviewsidebar_ {
<p><a class="dark" href="_gwcgi_?a=d&amp;d=_cgiargdUrlsafe_&amp;cl=_cgiargclUrlsafe_&amp;srpos=_cgiargsrposUrlsafe_&amp;_state_"><b>Click here to view this newspaper article</b></a></p>

<p>This text was automatically generated by a computer. It has not been manually reviewed or corrected and may include errors. You can view the article in its <a class="dark" href="_gwcgi_?a=d&amp;d=_cgiargdUrlsafe_&amp;cl=_cgiargclUrlsafe_&amp;srpos=_cgiargsrposUrlsafe_&amp;_state_">original format</a> or read the <a class="dark" href="_gwcgi_?a=d&amp;d=_documentlevel:documentoid_._logicalsectionlevel:logicalsectionmetafirstpagelink_&amp;_state_">entire page</a>.</p>

<h4>About the computer-generated text</h4>

<p>Optical Character Recognition (OCR) is a process for automatically extracting text from scanned pages. OCR enables searching of large quantities of full-text data, but it is not 100% accurate. The level of accuracy depends on the print quality of the original newspaper and its condition at the time of microfilming. Newspapers with poor quality paper, small print, mixed fonts, multiple column layouts or damaged pages may have poor OCR accuracy.</p>

<p>The page where this item appears has an estimated OCR accuracy of _document:articleaccuracy_%.</p>
}

_textimagedisclaimer_ [c=paperspast] {This article has been automatically clipped from the _documenttitle_, organised into a single column, then optimised for display on your computer screen. As a result, it may not look exactly as it did on the original page. The article can be seen in its original form in the <a href="_gwcgi_?a=d&amp;d=_1_&amp;_state_">page view</a>.}

_textloadingimage_ [c=paperspast] {Loading&#044; please wait}
_textarticleimage_ [c=paperspast] {Article image}
_textarticleimagesnippet_ [c=paperspast] {}

_textdownloadpdf_ [c=paperspast] {Download a printable PDF}
_textdownloadpagepdf_ [c=paperspast] {Download a printable PDF version of this newspaper page}
_textdownloadissuepdf_ [c=paperspast] {Download a printable PDF version of this newspaper issue}
_textpdfversion_ {PDF version 1.6}
_textdownloadpageimg_ {Download a high resolution PNG}

_textprevpage_ {Previous page}
_textnextpage_ {Next page}


# Feature codes

_textfeatureAtitle_ [c=paperspast] {Unnumbered}
_textfeatureA_ [c=paperspast] {This newspaper page was printed with no page number.}

_textfeatureCtitle_ [c=paperspast] {}
_textfeatureC_ [c=paperspast] {}

_textfeatureDtitle_ [c=paperspast] {Incorrect date}
_textfeatureD_ [c=paperspast] {This newspaper page has been printed with an incorrect date.}

_textfeatureGtitle_ [c=paperspast] {Issue missing}
_textfeatureG_ [c=paperspast] {This newspaper issue was published but no copy is available.}

_textfeatureItitle_ [c=paperspast] {Issue not published}
_textfeatureI_ [c=paperspast] {This newspaper issue was not published.}

_textfeatureLtitle_ [c=paperspast] {}
_textfeatureL_ [c=paperspast] {}

_textfeatureMtitle_ [c=paperspast] {Missing page}
_textfeatureM_ [c=paperspast] {This newspaper page is missing.}

_textfeatureNtitle_ [c=paperspast] {Incorrect pagination}
_textfeatureN_ [c=paperspast] {This newspaper page was printed with an incorrect page number.}

_textfeaturePtitle_ [c=paperspast] {}
_textfeatureP_ [c=paperspast] {}

_textfeatureStitle_ [c=paperspast] {Supplement}
_textfeatureS_ [c=paperspast] {This page is a supplement to the regular issue.}

_textfeatureTtitle_ [c=paperspast] {}
_textfeatureT_ [c=paperspast] {}

_textfeatureUtitle_ [c=paperspast] {}
_textfeatureU_ [c=paperspast] {}

_textfeatureXtitle_ [c=paperspast] {}
_textfeatureX_ [c=paperspast] {}



package logicalsectionlevel

_textlogicalsectionshowtext_ [c=paperspast] {Text of this article}



package pagelevel

_textpagepdflink_ [c=paperspast] {PDF of this page}



package panojs

_textregularview_ [c=paperspast] {Regular view}
_textzoomableview_ [c=paperspast] {Zoomable view}
_textzoomableviewabout_ [c=paperspast] {(What's this?)}

_textzoomin_ [c=paperspast] {Zoom In}
_textzoomout_ [c=paperspast] {Zoom Out}
_textzoomlevel_ [c=paperspast] {Zoom level}

_textzoomtoread_ [c=paperspast] {Zoom to this article}
_textcliplogicalsection_ [c=paperspast] {Clip this article}

_texttooltipzoomtoread_ [c=paperspast] {Zoom to read this article}
_texttooltiptext_ [c=paperspast] {View text of this article}
_texttooltipclip_ [c=paperspast] {_textcliplogicalsection_}
_texttooltippdf_ [c=paperspast] {Download printable PDF of this page}
_texttooltippagetext_ [c=paperspast] {View text of this page}

_textpagedownloadpng_ [c=paperspast] {PNG of this page}



package help

_textcontent_ [c=paperspast] {
<p>You can search from the search box on the homepage, the search box on newspaper publication pages, or the search page, which offers advanced search options.</p>

<h3>Using the Search box</h3>
<p>Enter your search term/s in the search box and click on the Search button.</p>

<p>If you enter more than one search term, the search engine will retrieve articles containing all of your search terms. For example, new and plymouth.</p>

<p>If you would like to increase the number of search results, select "Any of your words", which will retrieve articles containing either new or plymouth.</p>

<p>If you would like to reduce the number of search results, select "Exact phrase" which will only retrieve articles containing "new plymouth".</p>

<p>You can also use the Boolean operator NOT ("without the words") to narrow your search results. For example, plymouth NOT new will retrieve articles about Plymouth but not New Plymouth.</p>

<h3>Using the Search page</h3>
<p>The search page contains more search options</p>

<p>Restrict your search to particular newspaper titles using the Newspaper drop-down box. Hold down the Ctrl key to select more than one title at once.</p>

<p>Restrict your search to a date range by selecting the desired day, month and year in the "From" and "To" drop-down boxes.</p>

<p>You can also restrict your search to one or more of 3 content types. The searchable content has been divided up into articles, advertisements and illustrations (the search engine searches the illustration captions). Hold down the Ctrl key to select more than one content type at once.</p>

<a name="previewimages"></a>
<h3>Show preview images</h3>
<p>You can choose to display search results with preview images, which highlight the portion of the article which contains your search term/s. This is very useful way of quickly identifying items in which you are interested.</p>

<p>Because showing preview images can slow the loading of the search results, the default setting does not show preview images. You can enable this by turning on "Show preview images".</p>

<h3>Search history</h3>
<p>This lists your previous searches on Papers Past; if you click on the result link it will run the search again.</p>

<p>You can access your search history either by clicking on the "View your search history" link on the Search page or by selecting "Search history" on the Search drop-down list on the navigation bar.</p>

<p>This website uses cookies to remember your previous searches; you may manually disable cookies at any time. Check your browser's "Help" information for instructions.</p>

<h3>Need more help?</h3>
<p><a href="_gwcgi_?a=p&amp;p=contact&amp;_state_">Contact us</a></p>
}



package pubinfo

_textbrowsebydateinpublication_ {Browse by date within this newspaper}
_textselectyear_ {Select the year}

_textlogo_ {logo}
_textreadmore_ {Read more}

_textacknowledgement_ {Acknowledgement}

_textalttitle_ {Also published as}
_textavailableonline_ {Available online}

_textcopyrightstatement_ {Copyright statement}
_textdefaultcopyrightstatement_ {See our <a href="_gwcgi_?a=p&amp;p=copyrightguide&amp;_state_">copyright guide</a> for information on how you may use this title.}

_textpublicationissues_ {issues}
_textpublicationpages_ {Total: _pagescount_ pages}

_textdigitisationcomplete_ {Every known issue of this newspaper is in Papers Past}
_textdigitisationincomplete_ {Not all issues of this newspaper are in Papers Past}

_textregion_ {Region}

_texthideissues_ {Hide issues of this newspaper}
_textshowissues_ {Show all issues of this newspaper}
_textissuecountlots_ {(large page)}

_textsearchinpublication_ {Search within this newspaper}

_textdescription_ {Description}



package aboutsite

_textcontent_ {
<p>This website is provided and run by the <a href="http://www.natlib.govt.nz">National Library of New Zealand Te Puna M&#257;tauranga o Aotearoa</a>.</p>

<p>Papers Past was launched in 2001, with 250,000 pages from historic New Zealand newspapers. New titles have been added regularly since then, and the whole site was re-launched in 2007, with a new interface that added full text search for a third of the collection. The whole collection was made searchable by mid-2009.</p>
}

_textmorecontent_ {
<p>To find out more about Papers Past, visit the Papers Past page on the National Library website.</p>

<p><a href="http://www.natlib.govt.nz/collections/digital-collections/papers-past">Papers Past - National Library website</a></p>
}



package accessibility

_textcontent_ {
<p>The Papers Past site is for everyone.  If you have any questions about accessibility, or suggestions for how we could make our website more accessible, please contact us.</p>

<p><a href="_gwcgi_?a=p&amp;p=contact&amp;_state_">Contact us for accessibility help with this website</a></p>

<h3>Access keys</h3>
<p>Access keys are keyboard shortcuts that have been added as a way of navigating to common website links and page features. This website has the following access keys:</p>

<p>
  <b>1</b> &mdash; home<br />
  <b>2</b> &mdash; site map<br />
  <b>3</b> &mdash; search<br />
  <b>4</b> &mdash; about this site<br />
  <b>5</b> &mdash; browse<br />
  <b>6</b> &mdash; introduction<br />
  <b>9</b> &mdash; contact us<br />
  <b>[</b> &mdash; skip links to jump to start of body content<br />
  <b>/</b> &mdash; re-direct to newzealand.govt.nz<br />
</p>

<p>To use these shortcut keys hold down the ALT key (PC) or CONTROL key (Apple Macintosh) and then one of the keys in the list above. In some browsers you may have to press ENTER to confirm your choice. In the Opera 7 browser press SHIFT-ESC, release those keys, and then press your chosen access key.</p>

<h3>Font re-sizing</h3>
<p>There are common keyboard shortcuts that can make text bigger within your browser.</p>

<h4>Internet Explorer</h4>

<p>
  1. Open the <b>View</b> menu by pressing ALT + V.<br />
  2. Select <b>Text Size</b> by pressing X.<br />
  3. In the <b>Text Size</b> list, move to the text size option you want by pressing the UP ARROW or DOWN ARROW key.<br />
  4. Press ENTER.<br />
</p>

<h4>Mozilla Firefox</h4>

<p>
  Increase font size by pressing CTRL +<br />
  Reduce font size by pressing CTRL &mdash;<br />
</p>

<h3>Access to full text</h3>
<p>By default, newspaper pages and articles on this website are displayed as GIF images. They were scanned as images as part of the digitisation process. The newspapers are also available as full text. This text can be accessed from article pages by following the link to "_document:textviewarticletext_".</p>

<p>The text is automatically generated using Optical Character Recognition (OCR) software. It is not manually reviewed or corrected. OCR enables searching of large quantities of full text data, but it is not 100% accurate. The level of accuracy depends on the print quality of the original newspaper and its condition at the time of microfilming. Newspapers with poor quality paper, small print, mixed fonts, multiple column layouts or damaged pages may have poor OCR accuracy.</p>

<h3>Use of colour to identify search keywords</h3>
<p>On search results pages, and on article pages, a highlighted yellow background colour is used to visually identify keyword matches. The software used to run this website does not provide any way for this information to be conveyed without colour. If you have any questions about this service please contact us.</p>
}



package contact

_textcontent_ {
<p>To get research help from the National Library via email, online chat, phone, fax or post, visit our Ask A Librarian page.</p>

<p><a href="http://www.natlib.govt.nz/services/get-advice/ask-a-librarian">Ask a Librarian &mdash; National Library website</a></p>

<p>To contact us directly about the Papers Past website, please email:</p>

<p><a href="mailto:paperspast@natlib.govt.nz">paperspast@natlib.govt.nz</a></p>
}



package copyrightguide

_textcontent_ {
<h3>Copyright guide</h3>

<p>The Papers Past website provides access to digitised copies of historical New Zealand newspapers. This copyright statement relates specifically to the digitised newspaper content on Papers Past.  Additional information about specific papers can be found on each newspaper title page.</p>

<p>Material on this website has been provided in good faith for users by the National Library on the basis that:</p>

<ul>
<li>the newspaper publications provided from the 19th and early 20th century are out of copyright</li>
<li>in most cases digitised copies replace microfilm versions previously provided to the public</li>
<li>for more recent newspaper publications (up to 1945), permission has been sought from the publisher to reproduce the material on this website</li>
</ul>

<h3>Duration of copyright in New Zealand</h3>

<p>A significant amount of the content on Papers Past is out of copyright.  In New Zealand, where an author or publisher cannot be identified and it can be reasonably assumed the author died 50 or more years ago, copyright has expired.</p>

<p>As a guide, it may be reasonable to assume copyright has expired for newspaper items published more than 100 years ago, and that they are therefore available to be copied and republished without permission.</p>

<p>Where the author or publisher can be identified, in New Zealand the copyright term is the life of the author plus 50 years.  For works that are still in copyright, permission from the copyright holder is needed before copying or republishing the works, with the exceptions of fair dealing for criticism, review, research or private study.</p>

<p>If you are a rights holder and are concerned that you have found in-copyright material on our website, for which you have not given permission, or is not covered by a limitation or exception in New Zealand law, please <a href="mailto:paperspast@natlib.govt.nz">contact us</a> for a copy of our takedown procedure.</p>

<h3>Reproducing material from Papers Past</h3>

<p>If you copy or republish material from this website that is out of copyright or for which you have gained permission from the copyright holder, we kindly ask that you acknowledge the National Library of New Zealand as the source of the information.  If the material is republished online, we would appreciate a link to where you found the information on this website.</p>

<p>This copyright statement does not constitute legal advice, and the National Library of New Zealand is not responsible for any loss or damage caused as a result of following it.</p>

<h3>Find out more about copyright terms and legislation</h3>

<p>Find out more about copyright terms and the public domain on the <a href="http://makeit.digitalnz.org/guidelines/enabling-use-reuse/public-domain-guide/">DigitalNZ website</a>.</p>

<p>Learn more about <a href="http://www.legislation.govt.nz/act/public/1994/0143/latest/DLM345634.html">New Zealand copyright legislation: New Zealand Copyright Act 1994</a>.</p>
}



package gettingstarted

_textcontent_ {
<p>Papers Past provides access to digitised copies of historic New Zealand newspapers.</p>

<p>There are two main ways to find information in Papers Past: searching and browsing. Searching lets you enter a query term and retrieves articles that contain that term. Browsing lets you look at all the newspapers, starting with a year, a region, or a newspaper title. All the newspaper titles on the site can be searched and browsed.</p>

<h3>Issues, pages and articles</h3>
<p>Each newspaper title was published as a series of newspaper issues. Each issue is made up of one or more newspaper pages. You can view all the newspaper issues and pages in Papers Past.</p>

<p>The newspapers in Papers Past have their pages divided up into articles, advertisements, and illustrations. Every issue has a Contents list that gives you direct access to the articles, advertisements and illustrations.</p>

<h3>Browse by date</h3>
<p>Use the Browse by date page to find titles published on a certain date. Select a year from the drop-down list, then click on the month you're interested in, and then on the day. A list of the newspaper titles available on this day appears, and you can click on the title you would like to look at. If there are no newspapers available for a month or day, they will not be clickable.</p>

<p><a href="_gwcgi_?a=d&amp;cl=CL2&amp;_state_">Go to the Browse by date page</a></p>

<h3>Browse by region</h3>
<p>Use the Browse by region page to see which newspapers are available for the places you are interested in. There is a map on the page, which you can click on to see the newspaper titles available for that region. The page also shows newspaper titles with national coverage.</p>

<p><a href="_gwcgi_?a=d&amp;cl=CL3&amp;_state_">Go to the Browse by region page</a></p>

<h3>Browse by title</h3>
<p>This page lists all the newspaper and periodical titles available on Papers Past.</p>

<p><a href="_gwcgi_?a=d&amp;cl=CL1&amp;_state_">Go to the Browse by title page</a></p>

<h3>Search</h3>
<p>The Search page lets you enter a query term and retrieves articles that contain that term. Find out more about using Search on the Search help page.</p>

<p><a href="_gwcgi_?a=q&amp;_state_">Go to the Search page</a></p>

<p><a href="_gwcgi_?a=p&amp;p=help&amp;_state_">Go to the Search help page</a></p>

<h3>Printing</h3>
<p>Papers Past provides copies of the newspaper issues and newspaper pages in Adobe PDF (Portable Document Format) format that are easy to print. The PDF files are generated automatically at the time you request them, so they can take a long time to generate, especially for newspaper issues with many pages.</p>

<p>The newspaper pages are displayed in reduced resolution so they are easier to download. You can also select a high resolution PNG version of each newspaper page if required.</p>

<h3>Need more help?</h3>
<p><a href="_gwcgi_?a=p&amp;p=faqs&amp;_state_">Frequently asked questions (FAQs)</a></p>

<p><a href="_gwcgi_?a=p&amp;p=contact&amp;_state_">Contact us</a></p>
}



package faqs

_textcontent_ {
<h3 style="text-transform: uppercase">Using Papers Past</h3>

<h3>How do I print out an article?</h3>
<p>One way to do this is to use your browser's print command to print out an article you have retrieved.</p>

<p>Another method is to download the PDF version of the page containing the article and open it in the Adobe Acrobat Reader program. Once you have done this, select the desired article by clicking on the camera icon or snapshot tool, and then use the mouse to drag a box around the region you want to print. Choose "Print" from the file menu, tell Acrobat to print the selected region only, and to scale it up using the "Fit to Paper" option.</p>

<h3>How do I print out a page or a newspaper issue?</h3>
<p>Download the page-level or issue-level PDF by clicking on the "_document:textdownloadpdf_" button, load the document in Acrobat Reader, and then click on the print button.</p>

<h3>How do I re-size articles?</h3>
<p>Download the page-level or issue-level PDF by clicking on the "_document:textdownloadpdf_" button, then you can use the zoom function in Adobe Acrobat to enlarge articles.</p>

<h3>How do I save an article?</h3>
<p>One method is to get the article on the screen and use the File menu in your browser to save the web page. (Note that if you right-click on the article image and try to save or copy it you may only get part of the article.)</p>

<p>Another method is to download the PDF version of the page containing the article and open it in the Adobe Acrobat Reader program, select the desired article by clicking on the camera icon or snapshot tool, and then copy the article into a word processor document and save it.</p>

<h3>How do I save a page/newspaper issue?</h3>
<p>Download the page-level or issue-level PDF by clicking on the "_document:textdownloadpdf_" button, load the document in Acrobat Reader, then click on the "Save a Copy" button.</p>

<h3>How do I copy text from articles?</h3>
<p>Click on the "_document:textviewarticletext_" button on the article page, then cut and paste the text into Word. You will then need to compare the text against the original article and correct any errors that have resulted from the automated optical character recognition process.</p>

<h3>How do I move from one newspaper issue to the next?</h3>
<p>Click on the green arrow to the top right of the issue page.</p>

<h3>How do I move from one newspaper page to the next?</h3>
<p>Click on the green arrow to the top right of the newspaper page.</p>


<h3 style="text-transform: uppercase; padding-top: 20px">About the Papers Past website</h3>

<h3>What's next for Papers Past?</h3>
<p>As well as adding new titles to Papers Past every year, we also hope to do research into ways to improve the accuracy of the optical character recognition (OCR) process and into the editing of text.</p>

<h3>Are you going to correct errors in the text?</h3>
<p>The accuracy of text created from optical character recognition (OCR) will never be 100%, especially when you are working from historical newspapers that are often not in very good condition. With more than a million pages, it is not possible for us to correct all errors manually. However, we are interested in investigating how we can involve users in improving the OCR text.</p>

<h3>Are you planning to add M&#257;ori newspapers to Papers Past?</h3>
<p>A selection of M&#257;ori newspapers is already available online. The <a href="http://www.nzdl.org/niupepa">M&#257;ori Niupepa Collection</a> is a collection of historic newspapers published primarily for a M&#257;ori audience between 1842 and 1932. Digitised copies of these newspapers are available on the New Zealand Digital Library website.</p>

<h3>Are you planning to add the New Zealand Herald to Papers Past?</h3>
<p>We are investigating options for working with other institutions to make the early years of the New Zealand Herald available through Papers Past.</p>

<h3>Why does it take so long to download images of pages and articles?</h3>
<p>The pages are scaled down before being sent over the internet to your browser. It takes quite a lot of CPU power to do this, which takes some time when the system is under a heavy load. As a result of this processing, however, a much smaller page is sent to your browser. This means that people on slow connections can download the (smaller) pages much faster then they used to.</p>

<h3>What's the best way to link to Papers Past?</h3>
<p>The official URL for Papers Past is: </p>
<p><a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/">http://paperspast.natlib.govt.nz/</a></p>
<p>The M&#257;ori language version of the homepage is: </p>
<p><a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/cgi-bin/paperspast?l=mi">http://paperspast.natlib.govt.nz/cgi-bin/paperspast?l=mi</a></p>

<h3>What's the best way to link to a specific newspaper?</h3>
<p>The URL for the "newspaper page" for the Bay of Plenty Times newspaper looks like this:</p>
<p><a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.BOPT">http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.<span style="background: yellow; text-decoration: underline">BOPT</span></a></p>
<p>Note the acronym for BOPT is highlighted. To make a URL for any other newspaper, first find out its acronym, and replace BOPT. Here are some examples:</p>
<p>
<a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.DSC">http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.DSC</a><br />
<a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.NZGWS">http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.NZGWS</a><br />
<a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.WT">http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL1.WT</a></p>

<h3>What's the best way to link to other pages in Papers Past?</h3>
<p>Take the URL out of your browser, and remove the "e=" part from the end.</p>
<p><a style="padding-left: 25px" href="http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL3">http://paperspast.natlib.govt.nz/cgi-bin/paperspast?a=d&amp;cl=CL3</a></p>
<p>takes you to the Regions page, for example.</p>
}



package sitemap

_textcontent_ {
The main pages on this site are listed below.
}



package technology

_textcontent_ {
<a name="zoomableview"></a>
<h3>Zoomable view</h3>

<p>The zoomable view is an optional view of newspaper pages and articles in Papers Past, available when Javascript is enabled on your web browser.  The view allows you to zoom in and out of newspaper pages and articles as well as pan across multiple pages and articles by dragging your mouse inside the viewer.</p>

<p>By clicking on an article you will be given a suite of options to choose from:</p>

<ul>
<li>zoom in to the selected article</li>
<li>view the computer-generated text of the article</li>
<li>clip the article and view separately</li>
<li>download a PDF or PNG of the entire page</li>
</ul>

<p>You can exit the zoomable viewer anytime by clicking on "Regular view" just above the viewer box.</p>

<h3>Optical Character Recognition (OCR)</h3>
<p>Optical Character Recognition is a process by which software reads a page image and translates it into a text file by recognising the shapes of the letters. All the newspaper text in this collection has been automatically generated using OCR software. It has not been manually reviewed or corrected. To look at the OCR text for an article, click on the "_document:textviewarticletext_" link on the Article page.</p>

<h3>OCR mistakes</h3>
<p>OCR enables searching of large quantities of full text data, but it is never 100% accurate. For the Papers Past project, the level of accuracy depends on the print quality of the original newspaper, its condition at the time of microfilming, and the level of detail captured by the microfilm scanner. Newspapers with poor quality paper, small print, mixed fonts, multiple column layouts, or damaged pages may have poor OCR accuracy. This means that most pages will have some errors in the computer-generated text, and some will have a lot of errors.</p>

<h3>Veridian Digital Library Software</h3>
<p>Veridian is computer software for making digital collections available in full-text searchable form over the Internet. It is designed specifically to support collections of digitised printed materials (e.g. newspapers, books, and journals), and to take advantage of the latest technologies used in large digitisation projects.</p>

<p>Veridian was developed in New Zealand by DL Consulting Ltd, using the Greenstone digital library software. Greenstone was developed by the New Zealand Digital Library Project at the University of Waikato, and is distributed in cooperation with UNESCO and the Human Info NGO.</p>

<p><a href="http://www.dlconsulting.com/veridian">Veridian homepage</a></p>

<p><a href="http://www.greenstone.org">Greenstone homepage</a></p>
}



package terms

_textcontent_ {
<p>The National Library welcomes visitors from New Zealand and around the world to use its websites, and encourages you to access and link to works from our collections.</p>

<p>By using this website you agree to be legally bound by these terms of use and our Privacy Notice, which take effect immediately on your first use of the website. If you do not agree to be legally bound by all these terms, please do not access or use this website.</p>

<h3>Content disclaimer</h3>
<p>This website contains content that was not produced by the National Library. The National Library is not responsible for third-party content, and does not necessarily endorse the views expressed in it.</p>
<p>The Library accepts no liability or responsibility for the manner in which the information on this website is interpreted or used, or the results of such use.</p>
<p>The National Library may change these terms at any time by posting changes online.</p>

<h3>External links from this website</h3>
<p>This website may include links to other agencies and organisations. These links are for convenience and information purposes only. Linking should not be taken as endorsement of any kind by the National Library of those other agencies and organisations.</p>
<p>The National Library is not responsible for the content of external internet sites and does not necessarily endorse the views expressed within them. Contact the external site owner for answers to questions regarding their content.</p>

<h3>Copyright and reproduction statement</h3>
<p>This website is copyright to the National Library of New Zealand Te Puna M&#257;tauranga o Aotearoa. All use of information from this website must be acknowledged appropriately, and permission must be sought before copying any images, programs, and so on from the website.</p>
<p>For information about copyright and reproduction of digitised material available through this website, see the <a href="_gwcgi_?a=p&amp;p=copyrightguide&amp;_state_">Copyright Guide</a>.</p>

<h3>Privacy notice</h3>
<p>We will safeguard your personal information (information that identifies you as a natural person) and respect your rights under the Privacy Act 1993.</p>
<p>You may browse this website without providing any personal information.</p>
<p>If you send us personal information (for example, your email address when asking a research question), we will only use this personal information for the purpose for which it was provided.</p>
<p>We will keep any personal information you provide to us secure and will not disclose it to any other parties without your prior consent. To access or correct any of your personal information that we hold, or if you have any concerns about personal information that we hold, please contact us. You can email us with your privacy questions: <a href="mailto:privacy@natlib.govt.nz">privacy@natlib.govt.nz</a></p>

<h3>Tracking of website usage</h3>
<p>If you visit this site to read or download information, we collect and store statistical information about the visit.</p>
<p>This information includes the server address, top-level domain name, date and time of the visit, pages accessed and documents downloaded, previous site visited, and type of browser used.</p>
<p>Site statistics allow us to assess the number of visitors to the different sections of our websites, identify what information is of interest, monitor system performance, and help us make our sites more useful to visitors. Information is not passed to any other parties.</p>

<h3>Cookies</h3>
<p>Cookies are small files that are sent by a website and stored on your computer's hard-drive. Browser cookies are used by this website to help provide the statistical information described under "Tracking of website usage". This website also uses cookies to remember your previous searches. You can see these listed under Search History. You may manually disable cookies at any time. Check your browser's "Help" information for instructions.</p>

<h3>Linking to this website</h3>
<p>You are welcome to link to pages on the Papers Past website. Links should not say, or imply, that the material is the copyright of anyone other than the National Library or the relevant copyright holder.</p>
<p>Linking to this website from any other website or organisation should not be taken as endorsement of any kind by the National Library.</p>
}
