#ifndef D2MH
#define D2MH

#include <stdio.h>

#define  TRUE    1
#define  FALSE   0

#define  HTML_TITLE           "d2m: Dublin Core to MARC conversion"

#define  D2M_LINELEN          80
#define  D2M_TEMPFILE         "/tmp/d2m.data"
#define  D2M_TRACEFILE        "/tmp/d2m.trace"
#define  D2M_DEFAULT_SYNTAX   "plain"
#define  D2M_DEFAULT_FORMAT   "NORMARC"        
#define  D2M_DEFAULT_URL      "http://www.bibsys.no/meta/test.html"

struct metatag {
   char    *name;
   char    *type;
   char    *scheme;
   char    *value;
               };

struct marcrec {
   int     ntitles;
   int     ncreators;
   char    *marcline;
   char    *partitle;
   char    *subtitle;
   char    *year;
   char    *url;
   char    *fmat;
   char    *s008;
               };

enum mformats {
   USMARC,
   UNIMARC,
   DANMARC,
   FINMARC,
   ISMARC,
   NORMARC,
   SWEMARC    };

enum SOURCES { TEXTAREA, URL };

enum fields_in_008 {
   F008_DATE_ENTERED,
   F008_TYPE_OF_DATE,
   F008_DATE1,
   F008_LANGUAGE,
   F008_FORM_OF_PUBLICATION };
              
enum levels {
  LNAME,
  LTYPE,
  LSCHEME,
  LOCC,
  LTAG,
  LIND,
  LSUBF,
  LRULE
            };

extern void write_field(char *i, FILE *of, int l, int n, int s);
extern int write_trace(char *n, FILE *of);
extern struct metatag *dc_parse(char *b); 
extern char *cstr(char *h, char *n);
extern void unescape(char *n);
extern char *poq();
extern int  put008(char *n, char *s, int p);
extern int  find_year(char *n);
extern int  split_name(char *n);
extern int  split_subj(char *n);

#endif
