/**********************************************************************
 *
 * dublincore.cpp --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#include "dublincore.h"
#include "gsdltools.h"

dublin_core::dublin_core() : metaformat() {
  // These element names taken from the schema
  // http://www.openarchives.org/OAI/2.0/oai_dc.xsd
  elementSet.insert("contributor");
  elementSet.insert("coverage");
  elementSet.insert("creator");
  elementSet.insert("date");
  elementSet.insert("description");
  elementSet.insert("format");
  elementSet.insert("identifier");
  elementSet.insert("language");
  elementSet.insert("publisher");
  elementSet.insert("relation");
  elementSet.insert("rights");
  elementSet.insert("source");
  elementSet.insert("subject");
  elementSet.insert("title");
  elementSet.insert("type");
 

}

const text_t dublin_core::formatName() {
  return "oai_dc";
}

const text_t dublin_core::formatPrefix() {
  return "dc";
}

bool dublin_core::output_record(ostream &output, recptproto *protocol, const text_t &collection, 
				const text_t &record_OID) 
{
  return metaformat::output_record(output, protocol, collection, record_OID);
}

void dublin_core::output_metadata_header(ostream &output)
{ 
  output << "    <metadata>\n";
  
  if (this->oaiConfigure->getOAIVersion() <= 110){
    // output dublin core wrapper for OAI v1.1
    output << "      <dc xmlns=\"http://purl.org/dc/elements/1.1/\"\n"
	   << "          xmlns:xsi=\"http://www.w3c.org/2001/XMLSchema-instance\"\n"
	   << "          xsi:schemaLocation=\"http://purl.org/dc/elements/1.1/\n"
	   << "                              http://www.openarchives.org/OAI/1.1/dc.xsd\">\n";
  }
  else { 
    output << "      <oai_dc:dc\n"
	   << "          xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"\n"
	   << "          xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n"
	   << "          xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
	   << "          xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/\n"
	   << "                              http://www.openarchives.org/OAI/2.0/oai_dc.xsd\">\n";
  }
}

void dublin_core::output_metadata_footer(ostream &output)
{
  if (this->oaiConfigure->getOAIVersion() <= 110) {
    output << "      </dc>" << endl;
  }
  else {
    output << "      </oai_dc:dc>" << endl;
  }

  output << "    </metadata>" << endl; 
  output.flush();
}

// output dc:identifier for gs.OAIResourceURL, srclink, and link (whichever are defined)
bool dublin_core::output_custom_metadata(ostream &output, outconvertclass &outconvert, bool &headerDone, const text_t &collection, ResultDocInfo_t &docInfo) {
  text_tarray values;
  text_t value = get_metadata_value(docInfo, "gs.OAIResourceURL");
  if (!value.empty()) {
    values.push_back(value);
  }
  // try srclinkFile (the metaname "srclink_file" is deprecated, use "srclinkFile")
  value = get_metadata_value(docInfo, "srclinkFile");
  if (!value.empty()) {
    if (starts_with(value, "[")) {
      // its a format statement type value eg [SourceFile], need to get the appropriate metadata
      value = substr(findchar(value.begin(), value.end(), '[')+1,findchar(value.begin(), value.end(), ']') );
      value = get_metadata_value(docInfo, value);
    }
    
    if (!value.empty()) {
      text_t assocfilepath = get_metadata_value(docInfo, "assocfilepath");
      if (!assocfilepath.empty()) {
	value = this->oaiConfigure->getBaseDocRoot()+"/collect/"+collection+"/index/assoc/"+assocfilepath+"/"+value;
	values.push_back(value);
      } else {
	value = "";
      }
    }
  }
  // now add link
  value = this->oaiConfigure->getBaseLibraryURL()+"?a=d&c="+collection+"&d="+docInfo.OID;
  values.push_back(value);

  if (!headerDone) {
    this->output_metadata_header(output);
    headerDone = true;
  }
  for (int i=0; i<values.size(); i++) {
    if (this->oaiConfigure->getOAIVersion() >= 200) { 
      output << outconvert << "        <dc:identifier>" << xml_safe(values[i]) << "</dc:identifier>\n";
    }
    else {
      output << outconvert << "        <identifier>"  << xml_safe(values[i]) << "</identifier>\n";
    }
  }
  
  return true;
}

bool dublin_core::output_formatdata(ostream &output)
{
  output << "    <metadataPrefix>oai_dc</metadataPrefix>" << endl;

  if (this->oaiConfigure->getOAIVersion() <= 110) {
    output << "    <schema>http://www.openarchives.org/OAI/1.1/dc.xsd</schema>" << endl
	   << "    <metadataNamespace>http://purl.org/dc/elements/1.1/</metadataNamespace>" << endl;
  }
  else {
    output << "    <schema>http://www.openarchives.org/OAI/2.0/oai_dc.xsd</schema>" << endl
	   << "    <metadataNamespace>http://www.openarchives.org/OAI/2.0/oai_dc/</metadataNamespace>" 
	   << endl;
  }
  return true;
}

