/**********************************************************************
 *
 * resumptiontoken.cpp --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "resumptiontoken.h"


ResumptionToken::ResumptionToken(const text_t &build_date, const text_t &set, const text_t &metadata_prefix,
				 const text_t &from, const text_t &until, const text_t &position)
{
  this->build_date = build_date;
  this->set = set;
  this->metadata_prefix = metadata_prefix;
  this->from = from;
  this->until = until;
  this->position = position;
  this->valid = true;
}


ResumptionToken::ResumptionToken(const text_t &resumption_token_string)
{
  this->build_date = "";
  this->set = "";
  this->metadata_prefix = "";
  this->from = "";
  this->until = "";
  this->position = "";

  // This uses custom code instead of the text_t splitchar() function because that is buggy
  text_tarray resumption_token_string_parts;
  text_t resumption_token_string_part;
  text_t::const_iterator resumption_token_string_iterator = resumption_token_string.begin();
  while (resumption_token_string_iterator != resumption_token_string.end())
  {
    if (*resumption_token_string_iterator == ',')
    {
      resumption_token_string_parts.push_back(resumption_token_string_part);
      resumption_token_string_part.clear();
    }
    else
    {
      resumption_token_string_part.push_back(*resumption_token_string_iterator);
    }

    resumption_token_string_iterator++;
  }
  resumption_token_string_parts.push_back(resumption_token_string_part);

  if (resumption_token_string_parts.size() != 6)
  {
    // The resumption token is invalid -- there should be exactly 6 parts
    this->valid = false;
    return;
  }

  this->build_date = resumption_token_string_parts[0];
  this->set = resumption_token_string_parts[1];
  this->metadata_prefix = resumption_token_string_parts[2];
  this->from = resumption_token_string_parts[3];
  this->until = resumption_token_string_parts[4];
  this->position = resumption_token_string_parts[5];
  this->valid = true;
}


text_t ResumptionToken::getResumptionTokenString()
{
  return this->build_date + "," + this->set + "," + this->metadata_prefix + "," + this->from + "," + this->until + "," + this->position;
}


bool ResumptionToken::isValid()
{
  return this->valid;
}
