/**********************************************************************
 *
 * resumptiontoken.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _RESUMPTIONTOKEN_H_
#define _RESUMPTIONTOKEN_H_

#include "text_t.h"


class ResumptionToken
{
 private:
  text_t build_date;
  text_t set;
  text_t metadata_prefix;
  text_t from;
  text_t until;
  text_t position;

  bool valid;

 public:
  ResumptionToken(const text_t &build_date, const text_t &set, const text_t &metadata_prefix,
		  const text_t &from, const text_t &until, const text_t &position);
  ResumptionToken(const text_t &resumption_token_string);

  text_t getBuildDate() { return build_date; }
  text_t getSet() { return set; }
  text_t getMetadataPrefix() { return metadata_prefix; }
  text_t getFrom() { return from; }
  text_t getUntil() { return until; }
  text_t getPosition() { return position; }

  text_t getResumptionTokenString();
  bool isValid();
};


#endif
