/**********************************************************************
 *
 * maincfg.cpp -- 
 * Copyright (C) 2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "maincfg.h"
#include "fileutil.h"


#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace/std/iostream>
#  include <ospace/std/fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#  include <fstream.h>
#else
#  include <iostream>
#  include <fstream>
#endif


bool main_cfg_read (receptionist &recpt, const text_t &gsdlhome,
		    const text_t &collection) 
{

  cerr << "Warning: Using version of main_cfg_read() that does not support 'collecthome'" << endl;

  text_t collecthome = filename_cat(gsdlhome,"collect");

  cerr << "Setting collecthome to be " << collecthome << endl;


  return main_cfg_read(recpt,gsdlhome,collecthome,collection);
}


// main_cfg_read reads both main.cfg and collect.cfg. It attempts
// to read main.cfg first so values in collect.cfg override those
// set earlier by main.cfg
bool main_cfg_read (receptionist &recpt, const text_t &gsdlhome,
		    const text_t& collecthome, const text_t &collection) {

  // read in the main configuration file
  bool rv = false;

  text_t key, filename;
  text_tarray cfgline;
  filename = filename_cat (gsdlhome, "etc", "main.cfg");
  if (!collection.empty() && file_exists(filename)) {
    rv = recpt.read_configfile(filename);
  } else {
    if (file_exists (filename)) {
      rv = recpt.read_configfile(filename);
    }
  }

  // Look for collect.cfg in <collecthome>/collection-name/etc directory 
  // (if this is for a particular collection), and then GSDLHOME/etc.
  if (!collection.empty()) {
    filename = filename_cat (collecthome, collection, "etc", "collect.cfg");
    if (!file_exists (filename)) {
      filename = filename_cat (gsdlhome, "etc", "collect.cfg");
      if (!file_exists (filename)) filename.clear();
    }

    if (!filename.empty()) {
      rv |= recpt.read_configfile(filename);
    }

    // Look for custom.cfg in <collecthome>/collection-name/custom/collection-name/etc too
    filename = filename_cat (collecthome, collection, "custom", collection, "etc", "custom.cfg");
    if (file_exists(filename))
    {
      rv |= recpt.read_configfile(filename);
    }
  }
  return rv;
}
