/**********************************************************************
 *
 * os_process.h -- base class for OS specific calls related to creating 
 *                 process *without* (in the case of Windows) opening a 
 *                 DOS window.  
 *
 *                 Nett effect is OS neutral way to support
 *                 popen() and related functions
 *
 * Copyright (C) 2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef OS_PROCESS_H
#define OS_PROCESS_H

#include <stdlib.h>

enum OSProcessPipeMode   { uniRead=0, uniWrite=1, biReadWrite=2 };
enum OSProcessWarnStatus { withoutWarning, withWarning };

class osprocess 
{
  
 public:
  osprocess(OSProcessPipeMode mode,
	    char* prog_name, char* argv[]=NULL, char* envp[]=NULL);

  virtual ~osprocess();
  
  /* one day might want these
  virtual bool end_of_pipe();  
  virtual bool end_of_read_pipe(); 
  virtual bool end_of_write_pipe();
  */

  virtual int write(char* buffer, const int buffer_len)=0;
  virtual int read(char* buffer, const int buffer_len)=0;

  virtual void wait()=0;

  virtual bool close_write_pipe(OSProcessWarnStatus warn_status=withWarning)=0;
  virtual bool close_read_pipe(OSProcessWarnStatus warn_status=withWarning)=0;
  virtual bool close();

  
 protected:
  OSProcessPipeMode mode_;
};

#endif

