###########################################################################
#
# win32 makefile -- src/z3950
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDL_DIR = ..\..\..
COMMON_DIR = $(GSDL_DIR)\common-src
RUNTIME_DIR = $(GSDL_DIR)\runtime-src

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages
PACKAGES_DIR = $(RUNTIME_DIR)\packages
COLSERVR_DIR = $(RUNTIME_DIR)\src\colservr
PROTOCOL_DIR = $(RUNTIME_DIR)\src\protocol


GSDL_VC4 = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
ENABLE_ACCENTFOLD = 1
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS = 
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

!IF $(ENABLE_ACCENTFOLD)
ACCENTFOLD_LIBS = "$(INDEXERS_DIR)\packages\unac\libunac.lib" "$(INDEXERS_DIR)\packages\windows\iconv\iconv\lib\iconv.lib"
!ELSE
ACCENTFOLD_LIBS = 
!ENDIF

!IF $(USE_GDBM)
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3" \
	-I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\windows"
GDBM_LIBS = "$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\gdbm.lib"
GDBM_DEFINES = -DUSE_GDBM
!ELSE
GDBM_INCLUDES = 
GDBM_LIBS = 
GDBM_DEFINES =
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_DEFINES =
!ENDIF

!IF $(USE_SQLITE)
SQLITE_LIBS = "$(COMMON_PACKAGES_DIR)\sqlite\lib\sqlite3.lib"
SQLITE_DEFINES = -DUSE_SQLITE
!ELSE
SQLITE_LIBS = 
SQLITE_DEFINES =
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_DEFINES =
!ENDIF

!IF $(ENABLE_MG)
MG_DEFS = -DENABLE_MG
MG_LIBS = "$(INDEXERS_DIR)\mg\src\text\libmgtext.lib" \
	"$(INDEXERS_DIR)\mg\lib\libmglib.lib"
!ELSE
MG_DEFS =
MG_LIBS =
!ENDIF

!IF $(ENABLE_MGPP)
MGPP_DEFS = -DENABLE_MGPP
MGPP_LIBS = "$(INDEXERS_DIR)\mgpp\text\libmgpptext.lib" \
	"$(INDEXERS_DIR)\mgpp\lib\libmgpplib.lib"
MGPP_INCLUDES = -I"$(INDEXERS_DIR)\mgpp\text" -I"$(INDEXERS_DIR)\mgpp\lib"
!ELSE
MGPP_DEFS =
MGPP_LIBS =
MGPP_INCLUDES =
!ENDIF

!IF $(ENABLE_LUCENE)
LUCENE_DEFS = -DENABLE_LUCENE
!ELSE
LUCENE_DEFS=
!ENDIF

AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
	$(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES) \
	$(MG_DEFS) $(MGPP_DEFS) $(LUCENE_DEFS)
# Do NOT add the "recpt" directory here: the z39.50 code should be independent of the receptionist!
INCLUDES = -I"$(GSDL_DIR)" -I"$(COMMON_DIR)\src\lib" -I"$(COLSERVR_DIR)" -I"$(PROTOCOL_DIR)" \
	$(MGPP_INCLUDES) -I"$(PACKAGES_DIR)\yaz\yaz-2.1.56\include" \
	-I"$(PACKAGES_DIR)\yaz\yaz-2.1.56\client" -I"$(PACKAGES_DIR)\d2m" \
	$(GDBM_INCLUDES)
LIBS = "$(COMMON_PACKAGES_DIR)\expat\lib\libexpat.lib" $(GDBM_LIBS) \
        "$(PACKAGES_DIR)\d2m\libd2m.lib" "$(PACKAGES_DIR)\yaz\yaz-2.1.56\lib\yaz.lib" $(ACCENTFOLD_LIBS) \
	$(SQLITE_LIBS)

!IF $(GSDL_VC4)
DEFS=$(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS) -Fe"$@"


.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


LIBRARY_SOURCES = \
	yaz_zclient.c \
	z3950proto.cpp \
	z3950proxy.cpp \
	zparse.tab.c \
	zparse.yy.c

LIBRARY_OBJECTS = \
	yaz_zclient.obj \
	z3950proto.obj \
	z3950proxy.obj \
	zparse.tab.obj \
	zparse.yy.obj

LIBRARY = gsdlz3950.lib


SOURCES = \
	z3950explain.cpp \
	z3950parser.cpp \
	z3950server.cpp \
	z3950_to_gsdl.cpp

OBJECTS = \
	z3950explain.obj \
	z3950parser.obj \
	z3950server.obj \
	z3950_to_gsdl.obj

GSDL_LIBS = \
	gsdlz3950.lib \
	$(PROTOCOL_DIR)\gsdlprotocol.lib \
	$(COLSERVR_DIR)\gsdlcolservr.lib \
	$(MG_LIBS) \
	$(MGPP_LIBS) \
	$(COMMON_DIR)\src\lib\gsdllib.lib

EXECUTABLE_OBJECTS = \
	$(OBJECTS) \
	$(GSDL_LIBS)

EXECUTABLE = z3950server.exe


# Default target: make both gsdlz3950.lib and z3950server.exe
all: $(LIBRARY) $(EXECUTABLE)

gsdlz3950.lib: $(LIBRARY_OBJECTS)
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(LIBRARY_OBJECTS) $(PACKAGES_DIR)/yaz/yaz-2.1.56/win/obj/tabcomplete.obj

z3950server.exe: $(EXECUTABLE_OBJECTS)
	$(LINK) $(EXECUTABLE_OBJECTS) $(LIBS)

install: $(EXECUTABLE)
	copy $(EXECUTABLE) "$(GSDL_DIR)\bin\windows"

clean:
	del *.obj
	del $(LIBRARY)
	del $(EXECUTABLE)
