###########################################################################
#
# win32 makefile -- crypt
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 2000 The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

AR = lib
CC = cl
CPPFLAGS =
DEFS = -DDOS -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = 

COMPILE = $(CC) -nologo -c $(CPPFLAGS) $(DEFS) $(INCLUDES)

.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 

HEADERS = \
  crypt.h crypt-entry.h cryptutl.h

SOURCES = \
  crypt.c crypt-entry.c cryptutl.c

OBJECTS = \
  crypt.obj crypt-entry.obj cryptutl.obj

all: crypt.lib

crypt.lib : $(OBJECTS)
	if EXIST crypt.lib del crypt.lib
	$(AR) -nologo /out:crypt.lib $(OBJECTS)

clean:
	del *.obj 
	del crypt.lib

install:
