package org.greenstone.gatherer.gui;


import java.awt.*;
import javax.swing.*;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataTools;


public class MetadataElementListCellRenderer
    extends JLabel
    implements ListCellRenderer
{
    private byte previous_directionality = Character.DIRECTIONALITY_UNDEFINED;


    public byte getDirectionality()
    {
	if (previous_directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT || previous_directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC || previous_directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING || previous_directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE) {
	    return Character.DIRECTIONALITY_RIGHT_TO_LEFT;
	}
	else {
	    return Character.DIRECTIONALITY_LEFT_TO_RIGHT;
	}
    }


    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
    {
	if (value instanceof MetadataElement) {
	    MetadataElement metadata_element = (MetadataElement) value;

	    String interface_language_code = Configuration.getLanguage();
	    String metadata_element_display = "";

	    String metadata_element_display_name = metadata_element.getDisplayName();
	    if (metadata_element_display_name != null) {
		metadata_element_display += metadata_element_display_name + ":";
	    }
	    else {
		metadata_element_display += metadata_element.getName() + ":";
	    }

	    String metadata_element_definition = MetadataTools.getMetadataElementAttribute(metadata_element, "definition", interface_language_code, "en");
	    if (metadata_element_definition != null) {
		metadata_element_display += " " + metadata_element_definition;
	    }

// 	    String metadata_element_comment = MetadataTools.getMetadataElementAttribute(metadata_element, "comment", interface_language_code, "en");
// 	    if (metadata_element_comment != null) {
// 		metadata_element_display += " " + metadata_element_comment;
// 	    }

	    setText(metadata_element_display);

// 	    // Determine if the text should be left aligned or right aligned
// 	    String text = metadata_element_display;
// 	    int text_index = 0;
// 	    byte directionality = Character.DIRECTIONALITY_UNDEFINED;
// 	    while (directionality == Character.DIRECTIONALITY_UNDEFINED && text_index < text.length()) {
// 		directionality = Character.getDirectionality(text.charAt(text_index));
// 		text_index++;
// 	    }
// 	    if (directionality != previous_directionality) {
// 		previous_directionality = directionality;
// 		if (directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT || directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC || directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING || directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE) {
// 		    setHorizontalAlignment(JLabel.TRAILING);
// 		    setHorizontalTextPosition(JLabel.TRAILING);
// 		    setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
// 		}
// 		else {
// 		    setHorizontalAlignment(JLabel.LEADING);
// 		    setHorizontalTextPosition(JLabel.LEADING);
// 		    setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
// 		}
// 	    }
	}

	return this;
    }
}
