@echo off

set LUCENEHOME=.

set LUCENE_VER=4.7.2

rem ---- Where to put class files ----
set JAVACLASSDIR4=classes4
set JAVACLASSDIR3=classes3

rem ---- Name and location of java programs ----
set JAVAC="%JAVA_HOME%\bin\javac"
set JAVA="%JAVA_HOME%\bin\java"
set JAVADOC="%JAVA_HOME%\bin\javadoc"
set JAR="%JAVA_HOME%\bin\jar"

::set JAVACOPTIONS=-deprecation -g -O
set JAVACOPTIONS=

:: Note that both jar file lists need to be modified simultaneously when the jar dependencies are changed
set LUCENE4_JAR=.\lib\lucene4\lucene-core-4.7.2.jar;.\lib\lucene4\lucene-analyzers-common-4.7.2.jar;.\lib\lucene4\lucene-analyzers-kuromoji-4.7.2.jar;.\lib\lucene4\lucene-queryparser-4.7.2.jar
set LUCENE3_JAR=.\lib\lucene-core-3.3.0.jar

set MYCLASSPATH4=%LUCENE4_JAR%;%JAVACLASSDIR4%
set MYCLASSPATH3=%LUCENE3_JAR%;%JAVACLASSDIR3%


if "%DEBUG%" == "" (
  set MAKE_VARS=DEBUG=0
) else (
  set MAKE_VARS=DEBUG=%DEBUG%
)

if ""%1"" == """" goto all
if ""%1"" == ""all"" goto all
if ""%1"" == ""install"" goto install
if ""%1"" == ""clean"" goto clean

:unknown
	echo Error: Unrecognized argument %1.
	goto done

:lucene3
       if not exist %JAVACLASSDIR3% mkdir %JAVACLASSDIR3%
       echo Compiling Greenstone Lucene version 3.x Java classes ...
       %JAVAC% -d %JAVACLASSDIR3% -classpath %MYCLASSPATH3% %JAVACOPTIONS% -sourcepath src src\org\greenstone\LuceneWrapper3\*.java
       cd %JAVACLASSDIR3%
       %JAR% xf ..\%LUCENE3_JAR%
       cd ..
       %JAR% cf LuceneWrapper3.jar -C %JAVACLASSDIR3% .
       goto done

	   
rem http://stackoverflow.com/questions/138981/how-do-i-test-if-a-file-is-a-directory-in-a-batch-script
:all
	if not exist %JAVACLASSDIR4% mkdir %JAVACLASSDIR4%
	echo Compiling Greenstone Lucene version 4.x Java classes ...
	%JAVAC% -d %JAVACLASSDIR4% -classpath %MYCLASSPATH4% %JAVACOPTIONS% -sourcepath src src\org\greenstone\LuceneWrapper4\*.java
	pushd %JAVACLASSDIR4% 
	for %%G in (..\lib\lucene4\*%LUCENE_VER%.jar) do %JAR% xf %%G
	popd	
	copy LICENSE.txt %JAVACLASSDIR4%\META-INF\LICENSE-LUCENE_WRAPPER.txt
	copy LICENSE-GPLv2.txt %JAVACLASSDIR4%\META-INF\.
	copy LICENSE-GPLv3.txt %JAVACLASSDIR4%\META-INF\.
	%JAR% cf LuceneWrapper4.jar -C %JAVACLASSDIR4% .	
	goto done

:install
	goto done

:clean
	echo Cleaning up Greenstone Lucene ...
	if exist %JAVACLASSDIR4% rmdir /S /Q %JAVACLASSDIR4%
        if exist LuceneWrapper4.jar del LuceneWrapper4.jar
	if exist %JAVACLASSDIR3% rmdir /S /Q %JAVACLASSDIR3%
        if exist LuceneWrapper3.jar del LuceneWrapper3.jar
	goto done 

:done

