###########################################################################
#
# win32 makefile -- mgpp\lib
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

MGPPHOME = ..

UNAC_DIR = ../../packages/unac
ICONV_DIR = ../../packages/windows/iconv/iconv

DEBUG = 0
GSDL_VC4 = 0
ENABLE_ACCENTFOLD = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(ENABLE_ACCENTFOLD)
AFLIBS = "$(UNAC_DIR)\libunac.lib"  "$(ICONV_DIR)\lib\iconv.lib"
AFINCLUDES = -I"$(UNAC_DIR)"
AFDEFS = -DENABLE_ACCENTFOLD
!ELSE
AFLIBS = 
AFINCLUDES = 
AFDEFS = 
!ENDIF

# for now put executables in indexers/bin
INSTALLDIR = ..\..\bin
AR = lib
CC = cl

DEFS = -DQUIET -DHAVE_CONFIG_H -D__WIN32__ -DSILENT -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
        -D__STDC__ -D__GNU_LIBRARY__ -D__MSDOS__ $(AFDEFS)
INCLUDES = -I"." -I"$(MGPPHOME)" -I"$(MGPPHOME)\lib" $(AFINCLUDES)
COMPILE = $(CC) -c $(CXXFLAGS) $(DEFS) $(INCLUDES)

LINK = $(CC) $(LDFLAGS)

LIBS = $(MGPPHOME)\lib\libmgpplib.lib $(AFLIBS) 

.SUFFIXES:
.SUFFIXES: .c .cpp .obj
.c.obj:
	$(COMPILE) $<
.cpp.obj:
	$(COMPILE) $<

ANSI2KNR = 
o = .obj
e = .exe

HEADERS = \
  FIvfLevelInfo.h     TextEl.h            hash.h              stemmer.h  \
  FText.h             TextGet.h           invf.h              text.h     \
  FileBuf.h           UCArray.h           locallib.h          words.h    \
  FragLevelConvert.h  WordData.h          mg.h                           \
  IndexData.h         build.h             mg_errors.h                    \
  TagInfo.h           comp_dict.h         mg_files.h          Weights.h  \
  MGQuery.h           Terms.h             QueryLex.h          QueryParser.h \
  GSDLQueryLex.h	GSDLQueryParser.h


SOURCES = \
  FIvfLevelInfo.cpp        ivf.pass1.cpp            mgpp_invf_dump.cpp       \
  FText.cpp                ivf.pass2.cpp            mgpp_passes.cpp          \
  FileBuf.cpp              locallib.cpp             mgpp_perf_hash_build.cpp \
  FragLevelConvert.cpp     mg.special.cpp           mgpp_stem_idx.cpp        \
  IndexData.cpp            mgpp_compression_dict.cpp  mgpp_weights_build.cpp   \
  TagInfo.cpp              mgpp_decompress_text.cpp   stemmer.cpp            \
  TextEl.cpp               mg_errors.cpp            text.cpp               \
  TextGet.cpp              mgpp_fast_comp_dict.cpp    text.pass1.cpp         \
  UCArray.cpp              mg_files.cpp             text.pass2.cpp         \
  comp_dict.cpp            mgpp_invf_dict.cpp         words.cpp              \
  invf.cpp                 mgpp_invf_dict_dump.cpp    Weights.cpp            \
  MGQuery.cpp              Terms.cpp                QueryTester.cpp        \
  QueryLex.cpp             QueryParser.cpp         \
  GSDLQueryLex.cpp	   GSDLQueryParser.cpp      Queryer.cpp


EXEC          = mgpp_passes$e mgpp_decompress_text$e mgpp_perf_hash_build$e \
                mgpp_invf_dump$e mgpp_weights_build$e mgpp_invf_dict$e \
		mgpp_stem_idx$e mgpp_invf_dict_dump$e mgpp_compression_dict$e \
		mgpp_fast_comp_dict$e QueryTester$e Queryer$e

DISTFILES = Makefile.in $(HEADERS) $(SOURCES)
 
all : $(EXEC) libmgpptext.lib libmgpppass.lib


PASSES_OBJS = \
	mgpp_passes$o text.pass1$o comp_dict$o \
	text.pass2$o locallib$o \
	ivf.pass1$o ivf.pass2$o mg.special$o mg_files$o \
	words$o invf$o FileBuf$o TextEl$o UCArray$o TagInfo$o \
        FText$o text$o FIvfLevelInfo$o

mgpp_passes$e: $(PASSES_OBJS)
	$(LINK) $(PASSES_OBJS) $(LIBS)

QUERYER_OBJS = Queryer$o mg_files$o mg_errors$o locallib$o invf$o UCArray$o \
               FIvfLevelInfo$o FragLevelConvert$o Terms$o MGQuery$o \
               IndexData$o stemmer$o Weights$o TextGet$o text$o FText$o \
               GSDLQueryParser$o GSDLQueryLex$o words$o

Queryer$e: $(QUERYER_OBJS)
	$(LINK) $(QUERYER_OBJS) $(LIBS)

QUERY_TESTER_OBJS = QueryTester$o mg_files$o invf$o UCArray$o \
                    FIvfLevelInfo$o FragLevelConvert$o Terms$o MGQuery$o \
                    IndexData$o stemmer$o Weights$o

QueryTester$e: $(QUERY_TESTER_OBJS)
	$(LINK) $(QUERY_TESTER_OBJS) $(LIBS)

WEIGHTS_BUILD_OBJS = mgpp_weights_build$o mg_files$o invf$o UCArray$o \
                     FIvfLevelInfo$o FragLevelConvert$o

mgpp_weights_build$e: $(WEIGHTS_BUILD_OBJS)
	$(LINK) $(WEIGHTS_BUILD_OBJS) $(LIBS)

COMP_DICT_OBJS = mgpp_compression_dict$o mg_files$o locallib$o

mgpp_compression_dict$e: $(COMP_DICT_OBJS)
	$(LINK) $(COMP_DICT_OBJS) $(LIBS)

FAST_COMP_OBJS = mgpp_fast_comp_dict$o mg_files$o locallib$o

mgpp_fast_comp_dict$e: $(FAST_COMP_OBJS)
	$(LINK) $(FAST_COMP_OBJS) $(LIBS)

INVF_DUMP_OBJS = mgpp_invf_dump$o locallib$o mg_files$o invf$o UCArray$o

mgpp_invf_dump$e: $(INVF_DUMP_OBJS)
	$(LINK) $(INVF_DUMP_OBJS) $(LIBS)

INVF_DICT_OBJS = mgpp_invf_dict$o mg_files$o invf$o UCArray$o

mgpp_invf_dict$e: $(INVF_DICT_OBJS)
	$(LINK) $(INVF_DICT_OBJS) $(LIBS)

INVF_DICT_DUMP_OBJS = mgpp_invf_dict_dump$o mg_files$o invf$o UCArray$o

mgpp_invf_dict_dump$e: $(INVF_DICT_DUMP_OBJS)
	$(LINK) $(INVF_DICT_DUMP_OBJS) $(LIBS)

PERF_HASH_OBJS = mgpp_perf_hash_build$o mg_files$o invf$o UCArray$o

mgpp_perf_hash_build$e: $(PERF_HASH_OBJS)
	$(LINK) $(PERF_HASH_OBJS) $(LIBS)

STEM_IDX_OBJS = mgpp_stem_idx$o mg_files$o stemmer$o \
                invf$o UCArray$o

mgpp_stem_idx$e: $(STEM_IDX_OBJS)
	$(LINK)  $(STEM_IDX_OBJS) $(LIBS) 
#/link /NODEFAULTLIB:libc

DECOMPRESS_TEXT_OBJS = \
                mgpp_decompress_text$o mg_files$o mg_errors$o \
                locallib$o text$o UCArray$o TextGet$o FText$o

mgpp_decompress_text$e: $(DECOMPRESS_TEXT_OBJS)
	$(LINK) $(DECOMPRESS_TEXT_OBJS) $(LIBS)


LIB_OBJS = mg_files$o  mg_errors$o locallib$o invf$o UCArray$o \
           FIvfLevelInfo$o FragLevelConvert$o Terms$o MGQuery$o \
           IndexData$o stemmer$o Weights$o TextGet$o text$o FText$o \
           GSDLQueryParser$o GSDLQueryLex$o words$o

libmgpptext.lib: $(LIB_OBJS)
        if exist libmgpptext.lib del libmgpptext.lib
        $(AR) /out:libmgpptext.lib $(LIB_OBJS)

JNI_LIB_OBJS = \
	mgpp_passes_4jni$o text.pass1$o comp_dict$o \
	text.pass2$o locallib$o \
	ivf.pass1$o ivf.pass2$o mg.special$o mg_files$o \
	words$o invf$o FileBuf$o TextEl$o UCArray$o TagInfo$o \
        FText$o text$o FIvfLevelInfo$o

libmgpppass.lib: $(JNI_LIB_OBJS)
	if exist libmgpppass.lib del libmgpppass.lib
	$(AR) /out:libmgpppass.lib $(JNI_LIB_OBJS)

install: 
	if not exist "$(INSTALLDIR)" mkdir "$(INSTALLDIR)"
	for %%i in ($(EXEC)) do \
	  copy %%i "$(INSTALLDIR)"
 
clean:
	if exist *$o del *$o 
	if exist *$e del *$e
        if exist libmgpptext.lib del libmgpptext.lib 
        if exist libmgpppass.lib del libmgpppass.lib
	if exist *.pdb del *.pdb

