class DisplayJavaVersion
{
    public static void main(String args[])
    {  
	boolean verbose = false;

	if (args.length == 1) {
	    String arg0 = args[0];

	    if (arg0.equals("-v") || arg0.equals("-verbose") || arg0.equals("--verbose")) {
		verbose = true;
	    }
	}

	// Adapted from:
	//  https://stackoverflow.com/questions/2591083/getting-java-version-at-runtime
	
	String era, major, minor, update, build;

	// 'java.version' property returns:
	//    era.major.minor
	// 'java.runtime.version' returns:
	//    era.major.minor_update-build

	// The simpler case can be deal with using:
	//   String[] javaVersionElements = System.getProperty("java.version").split("\\.");
	//
	// However, as search4j.cpp has already been written assuming that version information
	// includes update (but not build number) details, then do the following:
	//
	String[] javaVersionElements = System.getProperty("java.runtime.version").split("\\.|_|-b");

	era     = javaVersionElements[0];
	major   = javaVersionElements[1];
	minor   = javaVersionElements[2];
	update  = javaVersionElements[3];
	build   = javaVersionElements[4]; // (unused)


	// Testing bitness of JVM
	//   https://www.baeldung.com/java-detect-jvm-64-or-32-bit	
	//boolean is_64bit = com.sun.jna.Platform.is64Bit();

	String version_str = era+"."+major+"."+minor+"_"+update;
    
	if (verbose) {
	    System.out.println("Version: " + version_str);
	}
	else {
	    System.out.println(version_str);
	}
    }
}

