/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Locale;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class ThreadDumpHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        NamedList lst;
        ThreadInfo[] tinfos;
        SimpleOrderedMap system = new SimpleOrderedMap();
        rsp.add("system", system);
        ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
        SimpleOrderedMap nl = new SimpleOrderedMap();
        nl.add("current", (Object)tmbean.getThreadCount());
        nl.add("peak", (Object)tmbean.getPeakThreadCount());
        nl.add("daemon", (Object)tmbean.getDaemonThreadCount());
        system.add("threadCount", (Object)nl);
        long[] tids = tmbean.findMonitorDeadlockedThreads();
        if (tids != null) {
            tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
            lst = new NamedList();
            for (ThreadInfo ti : tinfos) {
                if (ti == null) continue;
                lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
            }
            system.add("deadlocks", (Object)lst);
        }
        tids = tmbean.getAllThreadIds();
        tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
        lst = new NamedList();
        for (ThreadInfo ti : tinfos) {
            if (ti == null) continue;
            lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
        }
        system.add("threadDump", (Object)lst);
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getThreadInfo(ThreadInfo ti, ThreadMXBean tmbean) {
        SimpleOrderedMap info = new SimpleOrderedMap();
        long tid = ti.getThreadId();
        info.add("id", (Object)tid);
        info.add("name", (Object)ti.getThreadName());
        info.add("state", (Object)ti.getThreadState().toString());
        if (ti.getLockName() != null) {
            info.add("lock", (Object)ti.getLockName());
        }
        if (ti.isSuspended()) {
            info.add("suspended", (Object)true);
        }
        if (ti.isInNative()) {
            info.add("native", (Object)true);
        }
        if (tmbean.isThreadCpuTimeSupported()) {
            info.add("cpuTime", (Object)ThreadDumpHandler.formatNanos(tmbean.getThreadCpuTime(tid)));
            info.add("userTime", (Object)ThreadDumpHandler.formatNanos(tmbean.getThreadUserTime(tid)));
        }
        if (ti.getLockOwnerName() != null) {
            SimpleOrderedMap owner = new SimpleOrderedMap();
            owner.add("name", (Object)ti.getLockOwnerName());
            owner.add("id", (Object)ti.getLockOwnerId());
        }
        int i = 0;
        String[] trace = new String[ti.getStackTrace().length];
        for (StackTraceElement ste : ti.getStackTrace()) {
            trace[i++] = ste.toString();
        }
        info.add("stackTrace", (Object)trace);
        return info;
    }

    private static String formatNanos(long ns) {
        return String.format(Locale.ROOT, "%.4fms", (double)ns / 1000000.0);
    }

    @Override
    public String getDescription() {
        return "Thread Dump";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/core/src/java/org/apache/solr/handler/admin/ThreadDumpHandler.java $";
    }
}

