/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockReleaseFailedException;
import org.apache.solr.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsLockFactory
extends LockFactory {
    public static Logger log = LoggerFactory.getLogger(HdfsLockFactory.class);
    private Path lockPath;
    private Configuration configuration;

    public HdfsLockFactory(Path lockPath, Configuration configuration) {
        this.lockPath = lockPath;
        this.configuration = configuration;
    }

    public Lock makeLock(String lockName) {
        if (this.lockPrefix != null) {
            lockName = this.lockPrefix + "-" + lockName;
        }
        HdfsLock lock = new HdfsLock(this.lockPath, lockName, this.configuration);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLock(String lockName) throws IOException {
        FileSystem fs = null;
        try {
            fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.configuration);
            while (true) {
                if (!fs.exists(this.lockPath)) continue;
                if (this.lockPrefix != null) {
                    lockName = this.lockPrefix + "-" + lockName;
                }
                Path lockFile = new Path(this.lockPath, lockName);
                try {
                    if (fs.exists(lockFile) && !fs.delete(lockFile, false)) {
                        throw new IOException("Cannot delete " + lockFile);
                    }
                }
                catch (RemoteException e) {
                    if (e.getClassName().equals("org.apache.hadoop.hdfs.server.namenode.SafeModeException")) {
                        log.warn("The NameNode is in SafeMode - Solr will wait 5 seconds and try again.");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e1) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fs);
    }

    public Path getLockPath() {
        return this.lockPath;
    }

    public void setLockPath(Path lockPath) {
        this.lockPath = lockPath;
    }

    static class HdfsLock
    extends Lock {
        private Path lockPath;
        private String lockName;
        private Configuration conf;

        public HdfsLock(Path lockPath, String lockName, Configuration conf) {
            this.lockPath = lockPath;
            this.lockName = lockName;
            this.conf = conf;
        }

        /*
         * Exception decompiling
         */
        public boolean obtain() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            FileSystem fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.conf);
            try {
                if (fs.exists(new Path(this.lockPath, this.lockName)) && !fs.delete(new Path(this.lockPath, this.lockName), false)) {
                    throw new LockReleaseFailedException("failed to delete " + new Path(this.lockPath, this.lockName));
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)fs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLocked() throws IOException {
            boolean isLocked = false;
            FileSystem fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.conf);
            try {
                isLocked = fs.exists(new Path(this.lockPath, this.lockName));
            }
            finally {
                IOUtils.closeQuietly((Closeable)fs);
            }
            return isLocked;
        }
    }
}

