/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Vector;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.HdfsDirectoryFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.HdfsUpdateLog;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateHandler
implements SolrInfoMBean {
    protected static final Logger log = LoggerFactory.getLogger(UpdateHandler.class);
    protected final SolrCore core;
    protected final SchemaField idField;
    protected final FieldType idFieldType;
    protected Vector<SolrEventListener> commitCallbacks = new Vector();
    protected Vector<SolrEventListener> softCommitCallbacks = new Vector();
    protected Vector<SolrEventListener> optimizeCallbacks = new Vector();
    protected final UpdateLog ulog;

    private void parseEventListeners() {
        Class<SolrEventListener> clazz = SolrEventListener.class;
        String label = "Event Listener";
        for (PluginInfo info : this.core.getSolrConfig().getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("postCommit".equals(event)) {
                obj = this.core.createInitInstance(info, clazz, "Event Listener", null);
                this.commitCallbacks.add(obj);
                log.info("added SolrEventListener for postCommit: " + obj);
                continue;
            }
            if (!"postOptimize".equals(event)) continue;
            obj = this.core.createInitInstance(info, clazz, "Event Listener", null);
            this.optimizeCallbacks.add(obj);
            log.info("added SolrEventListener for postOptimize: " + obj);
        }
    }

    protected void callPostCommitCallbacks() {
        for (SolrEventListener listener : this.commitCallbacks) {
            listener.postCommit();
        }
    }

    protected void callPostSoftCommitCallbacks() {
        for (SolrEventListener listener : this.softCommitCallbacks) {
            listener.postSoftCommit();
        }
    }

    protected void callPostOptimizeCallbacks() {
        for (SolrEventListener listener : this.optimizeCallbacks) {
            listener.postCommit();
        }
    }

    public UpdateHandler(SolrCore core) {
        this(core, null);
    }

    public UpdateHandler(SolrCore core, UpdateLog updateLog) {
        this.core = core;
        this.idField = core.getLatestSchema().getUniqueKeyField();
        this.idFieldType = this.idField != null ? this.idField.getType() : null;
        this.parseEventListeners();
        PluginInfo ulogPluginInfo = core.getSolrConfig().getPluginInfo(UpdateLog.class.getName());
        if (updateLog == null && ulogPluginInfo != null && ulogPluginInfo.isEnabled()) {
            DirectoryFactory dirFactory;
            String dataDir = (String)ulogPluginInfo.initArgs.get("dir");
            String ulogDir = core.getCoreDescriptor().getUlogDir();
            if (ulogDir != null) {
                dataDir = ulogDir;
            }
            if (dataDir == null || dataDir.length() == 0) {
                dataDir = core.getDataDir();
            }
            this.ulog = dataDir != null && dataDir.startsWith("hdfs:/") ? ((dirFactory = core.getDirectoryFactory()) instanceof HdfsDirectoryFactory ? new HdfsUpdateLog(((HdfsDirectoryFactory)dirFactory).getConfDir()) : new HdfsUpdateLog()) : new UpdateLog();
            if (!core.isReloaded() && !core.getDirectoryFactory().isPersistent()) {
                this.ulog.clearLog(core, ulogPluginInfo);
            }
            this.ulog.init(ulogPluginInfo);
            this.ulog.init(this, core);
        } else {
            this.ulog = updateLog;
        }
    }

    public abstract void newIndexWriter(boolean var1) throws IOException;

    public abstract SolrCoreState getSolrCoreState();

    public abstract int addDoc(AddUpdateCommand var1) throws IOException;

    public abstract void delete(DeleteUpdateCommand var1) throws IOException;

    public abstract void deleteByQuery(DeleteUpdateCommand var1) throws IOException;

    public abstract int mergeIndexes(MergeIndexesCommand var1) throws IOException;

    public abstract void commit(CommitUpdateCommand var1) throws IOException;

    public abstract void rollback(RollbackUpdateCommand var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract UpdateLog getUpdateLog();

    public void registerCommitCallback(SolrEventListener listener) {
        this.commitCallbacks.add(listener);
    }

    public void registerSoftCommitCallback(SolrEventListener listener) {
        this.softCommitCallbacks.add(listener);
    }

    public void registerOptimizeCallback(SolrEventListener listener) {
        this.optimizeCallbacks.add(listener);
    }

    public abstract void split(SplitIndexCommand var1) throws IOException;
}

